/*
 * Decompiled with CFR 0.152.
 */
package hmi.bml.core;

import hmi.bml.core.HeadBehaviour;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;

public class HeadBehaviourTest {
    private static final double PARAMETER_PRECISION = 1.0E-4;

    @Test
    public void testReadXML() throws IOException {
        String str = "<head id=\"head1\" repetition=\"2\" amount=\"0.3\" start=\"1\" lexeme=\"NOD\"/>";
        HeadBehaviour beh = new HeadBehaviour("bml1", new XMLTokenizer(str));
        Assert.assertEquals((Object)"head1", (Object)beh.id);
        Assert.assertEquals((Object)"bml1", (Object)beh.bmlId);
        Assert.assertEquals((Object)"NOD", (Object)beh.getStringParameterValue("lexeme"));
        Assert.assertEquals((double)0.3, (double)beh.getFloatParameterValue("amount"), (double)1.0E-4);
        Assert.assertEquals((double)2.0, (double)beh.getFloatParameterValue("repetition"), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)beh.getSyncPoints().get((int)0).getRef().offset, (double)1.0E-4);
    }

    @Test
    public void testWriteXML() throws IOException {
        String str = "<head id=\"head1\" repetition=\"2\" amount=\"0.3\" start=\"1\" lexeme=\"NOD\"/>";
        HeadBehaviour behIn = new HeadBehaviour("bml1", new XMLTokenizer(str));
        StringBuilder buf = new StringBuilder();
        behIn.appendXML(buf);
        HeadBehaviour behOut = new HeadBehaviour("bml1", new XMLTokenizer(buf.toString()));
        Assert.assertEquals((Object)"head1", (Object)behOut.id);
        Assert.assertEquals((Object)"bml1", (Object)behOut.bmlId);
        Assert.assertEquals((Object)"NOD", (Object)behOut.getStringParameterValue("lexeme"));
        Assert.assertEquals((double)0.3, (double)behOut.getFloatParameterValue("amount"), (double)1.0E-4);
        Assert.assertEquals((double)2.0, (double)behOut.getFloatParameterValue("repetition"), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)behOut.getSyncPoints().get((int)0).getRef().offset, (double)1.0E-4);
    }
}

