/*
 * Decompiled with CFR 0.152.
 */
package hmi.bml.core;

import com.google.common.collect.ImmutableList;
import hmi.bml.core.Behaviour;
import hmi.bml.parser.SyncPoint;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;

public class HeadBehaviour
extends Behaviour {
    private int repeats;
    private String lexeme;
    private float amount;
    private static final List<String> DEFAULT_SYNCS = ImmutableList.of((Object)"start", (Object)"ready", (Object)"strokeStart", (Object)"stroke", (Object)"strokeEnd", (Object)"relax", (Object)"end");
    private static final String XMLTAG = "head";

    public static List<String> getDefaultSyncPoints() {
        return DEFAULT_SYNCS;
    }

    @Override
    public void addDefaultSyncPoints() {
        for (String s : HeadBehaviour.getDefaultSyncPoints()) {
            this.addSyncPoint(new SyncPoint(this.bmlId, this.id, s));
        }
    }

    @Override
    public String getStringParameterValue(String name) {
        if (name.equals("repetition")) {
            return "" + this.repeats;
        }
        if (name.equals("amount")) {
            return "" + this.amount;
        }
        if (name.equals("lexeme")) {
            return this.lexeme;
        }
        return null;
    }

    @Override
    public boolean satisfiesConstraint(String name, String value) {
        if (name.equals("repetition")) {
            return Integer.parseInt(value) == this.repeats;
        }
        if (name.equals("lexeme")) {
            return this.lexeme.equals(value);
        }
        return false;
    }

    public HeadBehaviour(String bmlId, XMLTokenizer tokenizer) throws IOException {
        super(bmlId);
        this.readXML(tokenizer);
    }

    @Override
    public StringBuilder appendAttributeString(StringBuilder buf) {
        HeadBehaviour.appendAttribute((StringBuilder)buf, (String)"lexeme", (String)this.lexeme);
        HeadBehaviour.appendAttribute((StringBuilder)buf, (String)"repetition", (int)this.repeats);
        HeadBehaviour.appendAttribute((StringBuilder)buf, (String)"amount", (float)this.amount);
        return super.appendAttributeString(buf);
    }

    @Override
    public float getFloatParameterValue(String name) {
        if (name.equals("repetition")) {
            return this.repeats;
        }
        if (name.equals("amount")) {
            return this.amount;
        }
        throw new IllegalArgumentException("Parameter " + name + " not found/not a float.");
    }

    @Override
    public boolean specifiesParameter(String name) {
        return name.equals("repetition") || name.equals("amount") || name.equals("lexeme");
    }

    @Override
    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        this.repeats = this.getOptionalIntAttribute("repetition", attrMap, 1);
        if (this.repeats > 1) {
            for (int i = 1; i < this.repeats; ++i) {
                this.addSyncPoint(new SyncPoint(this.bmlId, this.id, "stroke", i));
            }
        }
        this.amount = this.getOptionalFloatAttribute("amount", attrMap, 0.5f);
        this.lexeme = this.getRequiredAttribute("lexeme", attrMap, tokenizer);
        super.decodeAttributes(attrMap, tokenizer);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    @Override
    public String getXMLTag() {
        return XMLTAG;
    }
}

