/*
 * Decompiled with CFR 0.152.
 */
package hmi.bml.core;

import com.google.common.collect.ImmutableList;
import hmi.bml.core.Behaviour;
import hmi.bml.parser.SyncPoint;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;

public class GestureBehaviour
extends Behaviour {
    private String type;
    private Hand hand;
    private int repetition;
    private String target;
    private String lexeme = "";
    private boolean dynamic;
    private static final List<String> DEFAULT_SYNCS = ImmutableList.of((Object)"start", (Object)"ready", (Object)"strokeStart", (Object)"stroke", (Object)"strokeEnd", (Object)"relax", (Object)"end");
    private static final String XMLTAG = "gesture";

    @Override
    public void addDefaultSyncPoints() {
        for (String s : GestureBehaviour.getDefaultSyncPoints()) {
            this.addSyncPoint(new SyncPoint(this.bmlId, this.id, s));
        }
    }

    public static List<String> getDefaultSyncPoints() {
        return DEFAULT_SYNCS;
    }

    public GestureBehaviour(String bmlId, XMLTokenizer tokenizer) throws IOException {
        super(bmlId);
        this.readXML(tokenizer);
    }

    @Override
    public boolean satisfiesConstraint(String name, String value) {
        if (name.equals("type")) {
            return this.type.equals(value);
        }
        if (name.equals("hand")) {
            return this.hand.toString().equals(value);
        }
        if (name.equals("lexeme")) {
            return this.lexeme.equals(value);
        }
        if (name.equals("dynamic")) {
            return ("" + this.dynamic).equals(value);
        }
        return false;
    }

    @Override
    public String getStringParameterValue(String name) {
        if (name.equals("type")) {
            return this.type;
        }
        if (name.equals("hand")) {
            return this.hand.toString();
        }
        if (name.equals("repetition")) {
            return "" + this.repetition;
        }
        if (name.equals("target")) {
            return this.target;
        }
        if (name.equals("lexeme")) {
            return this.lexeme;
        }
        if (name.equals("dynamic")) {
            return "" + this.dynamic;
        }
        return null;
    }

    @Override
    public float getFloatParameterValue(String name) {
        if (name.equals("repetition")) {
            return this.repetition;
        }
        throw new IllegalArgumentException("Parameter " + name + " not found/not a float.");
    }

    @Override
    public boolean specifiesParameter(String name) {
        if (name.equals("type")) {
            return true;
        }
        if (name.equals("hand")) {
            return true;
        }
        if (name.equals("repetition")) {
            return true;
        }
        if (name.equals("target")) {
            return true;
        }
        if (name.equals("lexeme")) {
            return true;
        }
        return name.equals("dynamic");
    }

    @Override
    public StringBuilder appendAttributeString(StringBuilder buf) {
        GestureBehaviour.appendAttribute((StringBuilder)buf, (String)"type", (String)this.type);
        GestureBehaviour.appendAttribute((StringBuilder)buf, (String)"hand", (String)this.hand.toString());
        GestureBehaviour.appendAttribute((StringBuilder)buf, (String)"repetition", (int)this.repetition);
        GestureBehaviour.appendAttribute((StringBuilder)buf, (String)"target", (String)this.target);
        GestureBehaviour.appendAttribute((StringBuilder)buf, (String)"lexeme", (String)this.lexeme);
        GestureBehaviour.appendAttribute((StringBuilder)buf, (String)"dynamic", (boolean)this.dynamic);
        return super.appendAttributeString(buf);
    }

    @Override
    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        this.type = this.getRequiredAttribute("type", attrMap, tokenizer);
        this.hand = Hand.valueOf(this.getOptionalAttribute("hand", attrMap, Hand.UNSPECIFIED.toString()));
        this.dynamic = this.getOptionalBooleanAttribute("dynamic", attrMap, false);
        this.repetition = this.getOptionalIntAttribute("repetition", attrMap, 1);
        if (this.repetition > 1) {
            for (int i = 1; i < this.repetition; ++i) {
                this.addSyncPoint(new SyncPoint(this.bmlId, this.id, "stroke", i));
            }
        }
        this.target = this.type.equals("POINT") ? this.getRequiredAttribute("target", attrMap, tokenizer) : this.getOptionalAttribute("target", attrMap);
        this.lexeme = this.type.equals("LEXICALIZED") ? this.getRequiredAttribute("lexeme", attrMap, tokenizer) : this.getOptionalAttribute("lexeme", attrMap);
        super.decodeAttributes(attrMap, tokenizer);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    @Override
    public String getXMLTag() {
        return XMLTAG;
    }

    private static enum Hand {
        LEFT,
        RIGHT,
        BOTH,
        UNSPECIFIED;

    }
}

