/*
 * Decompiled with CFR 0.152.
 */
package hmi.bml.core;

import com.google.common.collect.ImmutableList;
import hmi.bml.core.Behaviour;
import hmi.bml.core.OffsetDirection;
import hmi.bml.parser.SyncPoint;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;

public class GazeBehaviour
extends Behaviour {
    private String target;
    private float offsetAngle;
    private OffsetDirection offsetDirection = OffsetDirection.NONE;
    private String influence = "";
    private static final List<String> DEFAULT_SYNCS = ImmutableList.of((Object)"start", (Object)"ready", (Object)"relax", (Object)"end");
    private static final String XMLTAG = "gaze";

    @Override
    public void addDefaultSyncPoints() {
        for (String s : GazeBehaviour.getDefaultSyncPoints()) {
            this.addSyncPoint(new SyncPoint(this.bmlId, this.id, s));
        }
    }

    public static List<String> getDefaultSyncPoints() {
        return DEFAULT_SYNCS;
    }

    @Override
    public boolean satisfiesConstraint(String name, String value) {
        if (name.equals("influence")) {
            return this.influence.equals(value);
        }
        if (name.equals("target")) {
            return this.target.equals(value);
        }
        if (name.equals("offsetDirection")) {
            return this.offsetDirection.equals(value);
        }
        return false;
    }

    @Override
    public float getFloatParameterValue(String name) {
        if (name.equals("offsetAngle")) {
            return this.offsetAngle;
        }
        throw new IllegalArgumentException("Parameter " + name + " not found/not a float.");
    }

    @Override
    public String getStringParameterValue(String name) {
        if (name.equals("target")) {
            return this.target;
        }
        if (name.equals("offsetAngle")) {
            return "" + this.offsetAngle;
        }
        if (name.equals("offsetDirection")) {
            return this.offsetDirection.toString();
        }
        if (name.equals("influence")) {
            return this.influence;
        }
        throw new IllegalArgumentException("Parameter " + name + " not found");
    }

    @Override
    public boolean specifiesParameter(String name) {
        if (name.equals("target")) {
            return true;
        }
        if (name.equals("offsetAngle")) {
            return true;
        }
        if (name.equals("offsetDirection")) {
            return true;
        }
        return name.equals("influence");
    }

    public GazeBehaviour(String bmlId, XMLTokenizer tokenizer) throws IOException {
        super(bmlId);
        this.readXML(tokenizer);
    }

    @Override
    public StringBuilder appendAttributeString(StringBuilder buf) {
        GazeBehaviour.appendAttribute((StringBuilder)buf, (String)"target", (String)this.target);
        GazeBehaviour.appendAttribute((StringBuilder)buf, (String)"offsetAngle", (float)this.offsetAngle);
        GazeBehaviour.appendAttribute((StringBuilder)buf, (String)"offsetDirection", (String)this.offsetDirection.toString());
        GazeBehaviour.appendAttribute((StringBuilder)buf, (String)"influence", (String)this.influence);
        return super.appendAttributeString(buf);
    }

    @Override
    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        this.target = this.getOptionalAttribute("target", attrMap);
        this.offsetAngle = this.getOptionalFloatAttribute("offsetAngle", attrMap, 0.0f);
        this.offsetDirection = OffsetDirection.valueOf(this.getOptionalAttribute("offsetDirection", attrMap, OffsetDirection.NONE.toString()));
        this.influence = this.getOptionalAttribute("influence", attrMap, "");
        super.decodeAttributes(attrMap, tokenizer);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    @Override
    public String getXMLTag() {
        return XMLTAG;
    }
}

