/*
 * Decompiled with CFR 0.152.
 */
package hmi.bml.core;

import hmi.bml.core.FaceLexemeBehaviour;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;

public class FaceLexemeBehaviourTest {
    private static final double PARAMETER_PRECISION = 1.0E-4;

    @Test
    public void testReadXML() throws IOException {
        String str = "<faceLexeme id=\"face1\" amount=\"0.25\" start=\"1\" lexeme=\"lex1\"/>";
        FaceLexemeBehaviour beh = new FaceLexemeBehaviour("bml1", new XMLTokenizer(str));
        Assert.assertEquals((Object)"face1", (Object)beh.id);
        Assert.assertEquals((Object)"bml1", (Object)beh.bmlId);
        Assert.assertEquals((Object)"lex1", (Object)beh.getStringParameterValue("lexeme"));
        Assert.assertEquals((double)0.25, (double)beh.getFloatParameterValue("amount"), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)beh.getSyncPoints().get((int)0).getRef().offset, (double)1.0E-4);
    }

    @Test
    public void writeReadXML() throws IOException {
        String str = "<faceLexeme id=\"face1\" type=\"LEXICALIZED\" amount=\"0.25\" start=\"1\" lexeme=\"lex1\"/>";
        FaceLexemeBehaviour behIn = new FaceLexemeBehaviour("bml1", new XMLTokenizer(str));
        StringBuilder buf = new StringBuilder();
        behIn.appendXML(buf);
        FaceLexemeBehaviour behOut = new FaceLexemeBehaviour("bml1", new XMLTokenizer(buf.toString()));
        Assert.assertEquals((Object)"face1", (Object)behOut.id);
        Assert.assertEquals((Object)"bml1", (Object)behOut.bmlId);
        Assert.assertEquals((Object)"lex1", (Object)behOut.getStringParameterValue("lexeme"));
        Assert.assertEquals((double)0.25, (double)behOut.getFloatParameterValue("amount"), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)behOut.getSyncPoints().get((int)0).getRef().offset, (double)1.0E-4);
    }
}

