/*
 * Decompiled with CFR 0.152.
 */
package hmi.bml.core;

import hmi.bml.BMLInfo;
import hmi.bml.core.BMLElement;
import hmi.bml.core.Behaviour;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Description
extends BMLElement {
    public int priority;
    private String bmlId;
    private String type;
    private String content;
    public boolean isParsed;
    public Behaviour behaviour;
    private Logger logger = LoggerFactory.getLogger((String)Description.class.getName());
    private static final String XMLTAG = "description";

    @Override
    public String getBmlId() {
        return this.bmlId;
    }

    public Description(String bmlId) {
        this.bmlId = bmlId;
        this.isParsed = false;
    }

    public Description(String bmlId, XMLTokenizer tokenizer) throws IOException {
        this(bmlId);
        this.isParsed = false;
        this.readXML(tokenizer);
    }

    public StringBuilder appendAttributeString(StringBuilder buf) {
        Description.appendAttribute((StringBuilder)buf, (String)"priority", (int)this.priority);
        Description.appendAttribute((StringBuilder)buf, (String)"type", (String)this.type);
        return buf;
    }

    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        this.priority = this.getRequiredIntAttribute("priority", attrMap, tokenizer);
        this.type = this.getRequiredAttribute("type", attrMap, tokenizer);
    }

    public boolean hasContent() {
        return true;
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        return buf.append(this.content);
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        Class<? extends Behaviour> desc;
        if (tokenizer.atSTag() && (desc = BMLInfo.getDescriptionExtensions().get(this.type)) != null && BMLInfo.supportedExtensions.contains(desc)) {
            this.behaviour = null;
            try {
                Constructor<? extends Behaviour> c = desc.getConstructor(String.class, XMLTokenizer.class);
                this.behaviour = c.newInstance(this.bmlId, tokenizer);
                this.isParsed = true;
            }
            catch (InstantiationException e) {
                this.logger.warn("InstantiationException when trying to initialize Description " + this.type + " description level ignored.", (Throwable)e);
                this.behaviour = null;
            }
            catch (IllegalAccessException e) {
                this.logger.warn("IllegalAccessException when trying to initialize Description " + this.type + " description level ignored.", (Throwable)e);
                this.behaviour = null;
            }
            catch (IllegalArgumentException e) {
                this.logger.warn("IllegalArgumentException when trying to initialize Description " + this.type + " description level ignored.", (Throwable)e);
                this.behaviour = null;
            }
            catch (InvocationTargetException e) {
                this.logger.warn("InvocationTargetException when trying to initialize Description " + this.type + " description level ignored.", (Throwable)e);
                e.printStackTrace();
                this.behaviour = null;
            }
            catch (SecurityException e) {
                this.logger.warn("SecurityException when trying to initialize Description " + this.type + " description level ignored.", (Throwable)e);
                this.behaviour = null;
            }
            catch (NoSuchMethodException e) {
                this.logger.warn("NoSuchMethodException when trying to initialize Description " + this.type + " description level ignored.", (Throwable)e);
                this.behaviour = null;
            }
        }
        if (this.behaviour == null) {
            this.content = tokenizer.getXMLSection();
            this.logger.info("skipped content: {}", (Object)this.content);
        }
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    @Override
    public String getXMLTag() {
        return XMLTAG;
    }
}

