/*
 * Decompiled with CFR 0.152.
 */
package hmi.bml;

import hmi.bml.parser.InvalidSyncRefException;
import hmi.bml.parser.SyncRef;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class SyncRefTest {
    private static final double SYNC_PRECISION = 1.0E-5;

    @Test
    public void testSyncRef1() throws InvalidSyncRefException {
        SyncRef s = new SyncRef("bml1", "0.1");
        Assert.assertEquals((double)0.1, (double)s.offset, (double)1.0E-5);
        Assert.assertEquals((Object)"bml", (Object)s.sourceId);
        Assert.assertEquals((Object)"start", (Object)s.syncId);
    }

    @Test
    public void testSyncRef2() throws InvalidSyncRefException {
        SyncRef s = new SyncRef("bml1", "beh1:tm");
        Assert.assertEquals((double)0.0, (double)s.offset, (double)1.0E-5);
        Assert.assertEquals((Object)"beh1", (Object)s.sourceId);
        Assert.assertEquals((Object)"tm", (Object)s.syncId);
    }

    @Test
    public void testSyncRef3() throws InvalidSyncRefException {
        SyncRef s = new SyncRef("bml1", "beh1:relax+2");
        Assert.assertEquals((double)2.0, (double)s.offset, (double)1.0E-5);
        Assert.assertEquals((Object)"beh1", (Object)s.sourceId);
        Assert.assertEquals((Object)"relax", (Object)s.syncId);
    }

    @Test(expected=InvalidSyncRefException.class)
    public void testSyncRef3b() throws InvalidSyncRefException {
        new SyncRef("bml1", "beh1:relax:2");
    }

    @Test
    public void testSyncRef4() throws InvalidSyncRefException {
        SyncRef s = new SyncRef("bml1", "beh2:stroke:2");
        Assert.assertEquals((double)0.0, (double)s.offset, (double)1.0E-5);
        Assert.assertEquals((Object)"beh2", (Object)s.sourceId);
        Assert.assertEquals((Object)"stroke", (Object)s.syncId);
        Assert.assertEquals((long)2L, (long)s.iteration);
    }

    @Test
    public void testSyncRef5() throws InvalidSyncRefException {
        SyncRef s = new SyncRef("bml1", "beh2:stroke:2-3.1");
        Assert.assertEquals((Object)"beh2", (Object)s.sourceId);
        Assert.assertEquals((Object)"stroke", (Object)s.syncId);
        Assert.assertEquals((long)2L, (long)s.iteration);
        Assert.assertEquals((double)-3.1, (double)s.offset, (double)1.0E-5);
    }

    @Test
    public void testSyncRef6() throws InvalidSyncRefException {
        SyncRef s = new SyncRef("bml1", "beh2  : stroke : 2 - 3.1 ");
        Assert.assertEquals((Object)"beh2", (Object)s.sourceId);
        Assert.assertEquals((Object)"stroke", (Object)s.syncId);
        Assert.assertEquals((long)2L, (long)s.iteration);
        Assert.assertEquals((double)-3.1, (double)s.offset, (double)1.0E-5);
    }

    @Test
    public void testSyncRef7() throws InvalidSyncRefException {
        SyncRef s = new SyncRef("bml1", "beh2:start-2");
        Assert.assertEquals((Object)"beh2", (Object)s.sourceId);
        Assert.assertEquals((Object)"start", (Object)s.syncId);
        Assert.assertEquals((long)-1L, (long)s.iteration);
        Assert.assertEquals((double)-2.0, (double)s.offset, (double)1.0E-5);
    }

    @Test
    public void testSyncRef8() throws InvalidSyncRefException {
        SyncRef s = new SyncRef("bml1", "beat1:strokeStart");
        Assert.assertEquals((Object)"beat1", (Object)s.sourceId);
        Assert.assertEquals((Object)"strokeStart", (Object)s.syncId);
        Assert.assertEquals((long)-1L, (long)s.iteration);
        Assert.assertEquals((double)0.0, (double)s.offset, (double)1.0E-5);
    }

    @Test
    public void testSyncRef9() throws InvalidSyncRefException {
        SyncRef s = new SyncRef("bml1", "beat5:beat3");
        Assert.assertTrue((boolean)s.sourceId.equals("beat5"));
        Assert.assertTrue((boolean)s.syncId.equals("beat3"));
        Assert.assertTrue(((float)s.iteration == -1.0f ? 1 : 0) != 0);
        Assert.assertTrue((s.offset == 0.0 ? 1 : 0) != 0);
    }

    @Test(expected=InvalidSyncRefException.class)
    public void testSyncRef10() throws InvalidSyncRefException {
        new SyncRef("bml1", "beat1:custom-sync1");
    }

    @Test(expected=InvalidSyncRefException.class)
    public void testSyncRef11() throws InvalidSyncRefException {
        new SyncRef("bml1", "beh2:end+x");
    }

    @Test
    public void testSyncRef12() throws InvalidSyncRefException {
        SyncRef s = new SyncRef("bml1", "beh2:end+");
        Assert.assertTrue((boolean)s.sourceId.equals("beh2"));
        Assert.assertTrue((boolean)s.syncId.equals("end+"));
        Assert.assertTrue(((float)s.iteration == -1.0f ? 1 : 0) != 0);
        Assert.assertTrue((s.offset == 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testSyncRefWithBML() throws InvalidSyncRefException {
        SyncRef s = new SyncRef("bmlDef", "bml1:beh1:stroke");
        Assert.assertEquals((Object)"bml1", (Object)s.bbId);
        Assert.assertEquals((Object)"beh1", (Object)s.sourceId);
        Assert.assertEquals((Object)"stroke", (Object)s.syncId);
        Assert.assertEquals((double)-1.0, (double)s.iteration, (double)1.0E-5);
        Assert.assertEquals((double)0.0, (double)s.offset, (double)1.0E-5);
    }

    @Test
    public void testSyncRefWithBMLAndStrokeAndOffset() throws InvalidSyncRefException {
        SyncRef s = new SyncRef("bmlDef", "bml1:beh1:stroke:1-3");
        Assert.assertEquals((Object)"bml1", (Object)s.bbId);
        Assert.assertEquals((Object)"beh1", (Object)s.sourceId);
        Assert.assertEquals((Object)"stroke", (Object)s.syncId);
        Assert.assertEquals((double)1.0, (double)s.iteration, (double)1.0E-5);
        Assert.assertEquals((double)-3.0, (double)s.offset, (double)1.0E-5);
    }

    @Test(expected=InvalidSyncRefException.class)
    public void testSyncRefWithBMLAndInvalidStrokeIteration() throws InvalidSyncRefException {
        new SyncRef("bmlDef", "bml1:beh1:stroke:-1");
    }

    @Test(expected=InvalidSyncRefException.class)
    public void testSyncRefWithBMLAndInvalidStrokeIteration1() throws InvalidSyncRefException {
        new SyncRef("bmlDef", "bml1:beh1:stroke:blah");
    }

    @Test(expected=InvalidSyncRefException.class)
    public void testSyncRefWithInvalidStart() throws InvalidSyncRefException {
        new SyncRef("bmlDef", ":beh1:sync1");
    }

    @Test(expected=InvalidSyncRefException.class)
    public void testSyncRefWithBMLInvalid() throws InvalidSyncRefException {
        new SyncRef("bmlDef", "bml1:blah:beh1:stroke:2");
    }

    @Test(expected=InvalidSyncRefException.class)
    public void testIncomplete1() throws InvalidSyncRefException {
        new SyncRef("bmlDef", "beh1");
    }

    @Test
    public void testEquals() throws InvalidSyncRefException {
        SyncRef s1 = new SyncRef("bml1", "0.1");
        SyncRef s2 = new SyncRef("bml1", "0.1");
        Assert.assertEquals((Object)s1, (Object)s2);
    }

    @Test
    public void testEquals1() throws InvalidSyncRefException {
        SyncRef s1 = new SyncRef("bml1", "bml:start+0.1");
        SyncRef s2 = new SyncRef("bml1", "0.1");
        Assert.assertEquals((Object)s1, (Object)s2);
    }

    @Test
    public void testEquals2() throws InvalidSyncRefException {
        SyncRef s1 = new SyncRef("bml1", "beh2:stroke:2-3.1");
        SyncRef s2 = new SyncRef("bml1", "beh2:stroke:2-3.1");
        Assert.assertEquals((Object)s1, (Object)s2);
    }

    @Test
    public void testEquals3() throws InvalidSyncRefException {
        SyncRef s1 = new SyncRef("bml1", "beh2:relax");
        SyncRef s2 = new SyncRef("bml1", "beh2:relax");
        Assert.assertEquals((Object)s1, (Object)s2);
    }

    @Test
    public void testNotEquals1() throws InvalidSyncRefException {
        SyncRef s1 = new SyncRef("bml1", "beh2:stroke:2-3.1");
        SyncRef s2 = new SyncRef("bml1", "beh2:stroke:2-3.0");
        Assert.assertThat((Object)s1, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)s2)));
    }

    @Test
    public void testNotEquals2() throws InvalidSyncRefException {
        SyncRef s1 = new SyncRef("bml1", "bml:start+0.1");
        SyncRef s2 = new SyncRef("bml1", "bml:start");
        Assert.assertThat((Object)s1, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)s2)));
    }

    @Test
    public void testNotEquals3() throws InvalidSyncRefException {
        SyncRef s1 = new SyncRef("bml1", "beh2:stroke:2-3.1");
        SyncRef s2 = new SyncRef("bml1", "beh2:stroke:1-3.1");
        Assert.assertThat((Object)s1, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)s2)));
    }

    @Test
    public void testNotEquals4() throws InvalidSyncRefException {
        SyncRef s1 = new SyncRef("bml1", "beh2:stroke");
        SyncRef s2 = new SyncRef("bml1", "beh2:relax");
        Assert.assertThat((Object)s1, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)s2)));
    }

    @Test
    public void testGetRefString1() throws InvalidSyncRefException {
        SyncRef s1 = new SyncRef("bml1", "0.1");
        Assert.assertEquals((Object)"bml1:bml:start+0.1", (Object)s1.toString());
    }

    @Test
    public void testGetRefString2() throws InvalidSyncRefException {
        SyncRef s1 = new SyncRef("bml1", "beh2:stroke:2-3.1");
        Assert.assertEquals((Object)s1.toString(), (Object)"bml1:beh2:stroke:2-3.1");
    }

    @Test
    public void testToRelativeString() throws InvalidSyncRefException {
        SyncRef s1 = new SyncRef("bml1", "2");
        Assert.assertEquals((Object)"2.0", (Object)s1.toString("bml1"));
    }
}

