/*
 * Decompiled with CFR 0.152.
 */
package hmi.bml;

import com.google.common.collect.ImmutableMap;
import hmi.bml.core.Behaviour;
import hmi.bml.core.FaceLexemeBehaviour;
import hmi.bml.core.GazeBehaviour;
import hmi.bml.core.GestureBehaviour;
import hmi.bml.core.HeadBehaviour;
import hmi.bml.core.LocomotionBehaviour;
import hmi.bml.core.PostureBehaviour;
import hmi.bml.core.SpeechBehaviour;
import hmi.bml.core.WaitBehaviour;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class BMLInfo {
    public static final String ANTICIPATORBLOCKID = "anticipators";
    private static final ImmutableMap<String, Class<? extends Behaviour>> BEHAVIOR_TYPES = new ImmutableMap.Builder().put((Object)HeadBehaviour.xmlTag(), HeadBehaviour.class).put((Object)LocomotionBehaviour.xmlTag(), LocomotionBehaviour.class).put((Object)FaceLexemeBehaviour.xmlTag(), FaceLexemeBehaviour.class).put((Object)GazeBehaviour.xmlTag(), GazeBehaviour.class).put((Object)PostureBehaviour.xmlTag(), PostureBehaviour.class).put((Object)GestureBehaviour.xmlTag(), GestureBehaviour.class).put((Object)SpeechBehaviour.xmlTag(), SpeechBehaviour.class).put((Object)WaitBehaviour.xmlTag(), WaitBehaviour.class).build();
    private static final ImmutableMap<String, Class<? extends Behaviour>> DESCRIPTION_EXTENSIONS = new ImmutableMap.Builder().build();
    public static final List<Class<? extends Behaviour>> supportedExtensions = new ArrayList<Class<? extends Behaviour>>();
    private static Map<String, Class<? extends Behaviour>> behaviourTypes = new HashMap<String, Class<? extends Behaviour>>();
    private static Map<String, Class<? extends Behaviour>> descriptionExtensions = new HashMap<String, Class<? extends Behaviour>>();

    public static void addBehaviourTypes(ImmutableMap<String, Class<? extends Behaviour>> behs) {
        behaviourTypes.putAll((Map<String, Class<? extends Behaviour>>)behs);
    }

    public static void addDescriptionExtensions(ImmutableMap<String, Class<? extends Behaviour>> descs) {
        descriptionExtensions.putAll((Map<String, Class<? extends Behaviour>>)descs);
    }

    public static void addBehaviourType(String name, Class<? extends Behaviour> beh) {
        behaviourTypes.put(name, beh);
    }

    public static void addDescriptionExtension(String name, Class<? extends Behaviour> beh) {
        descriptionExtensions.put(name, beh);
    }

    public static Map<String, Class<? extends Behaviour>> getBehaviourTypes() {
        return behaviourTypes;
    }

    public static Map<String, Class<? extends Behaviour>> getDescriptionExtensions() {
        return descriptionExtensions;
    }

    private BMLInfo() {
    }

    static {
        behaviourTypes.putAll((Map<String, Class<? extends Behaviour>>)BEHAVIOR_TYPES);
        descriptionExtensions.putAll((Map<String, Class<? extends Behaviour>>)DESCRIPTION_EXTENSIONS);
    }
}

