/*
 * Decompiled with CFR 0.152.
 */
package saiba.bml.core;

import com.google.common.collect.ImmutableList;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLScanException;
import hmi.xml.XMLStructureAdapter;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import saiba.bml.core.Behaviour;
import saiba.bml.core.Sync;
import saiba.bml.parser.InvalidSyncRefException;
import saiba.bml.parser.SyncPoint;

public class SpeechBehaviour
extends Behaviour {
    protected String content;
    private ArrayList<Sync> syncs = new ArrayList();
    private static final String XMLTAG = "speech";
    private static final List<String> DEFAULT_SYNCS = ImmutableList.of((Object)"start", (Object)"end");

    public static String xmlTag() {
        return XMLTAG;
    }

    @Override
    public void addDefaultSyncPoints() {
        for (String s : SpeechBehaviour.getDefaultSyncPoints()) {
            this.addSyncPoint(new SyncPoint(this.bmlId, this.id, s));
        }
    }

    public static List<String> getDefaultSyncPoints() {
        return DEFAULT_SYNCS;
    }

    @Override
    public String getStringParameterValue(String name) {
        return super.getStringParameterValue(name);
    }

    @Override
    public float getFloatParameterValue(String name) {
        return super.getFloatParameterValue(name);
    }

    @Override
    public boolean specifiesParameter(String name) {
        return super.specifiesParameter(name);
    }

    public SpeechBehaviour(String bmlId, XMLTokenizer tokenizer) throws IOException {
        super(bmlId);
        this.readXML(tokenizer);
    }

    public StringBuilder appendAttributeString(StringBuilder buf) {
        return super.appendAttributeString(buf);
    }

    @Override
    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        super.decodeAttributes(attrMap, tokenizer);
    }

    @Override
    public boolean hasContent() {
        return true;
    }

    @Override
    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        if (this.content != null) {
            buf.append("<text>" + this.content + "</text>");
        }
        return super.appendContent(buf, fmt);
    }

    @Override
    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (!tokenizer.atETag()) {
            if (tokenizer.atSTag("text")) {
                SpeechText text = new SpeechText();
                text.readXML(tokenizer);
                this.content = text.content;
                this.syncs = text.syncs;
                for (Sync sync : this.syncs) {
                    SyncPoint s = new SyncPoint(this.bmlId, this.id, sync.id);
                    if (sync.ref != null) {
                        try {
                            s.setRefString(sync.ref.toString(this.bmlId));
                        }
                        catch (InvalidSyncRefException e) {
                            throw new XMLScanException("", (Throwable)e);
                        }
                    }
                    this.addSyncPoint(s);
                }
            } else {
                super.decodeContent(tokenizer);
            }
            this.ensureDecodeProgress(tokenizer);
        }
    }

    @Override
    public String getXMLTag() {
        return XMLTAG;
    }

    public String getContent() {
        return this.content;
    }

    class SpeechText
    extends XMLStructureAdapter {
        public String content = "";
        public ArrayList<Sync> syncs = new ArrayList();
        public static final String BMLNAMESPACE = "http://www.bml-initiative.org/bml/bml-1.0";

        SpeechText() {
        }

        public void decodeContent(XMLTokenizer tokenizer) throws IOException {
            while (!tokenizer.atETag()) {
                if (tokenizer.atSTag("sync")) {
                    Sync s = new Sync(SpeechBehaviour.this.bmlId);
                    s.readXML(tokenizer);
                    this.content = this.content + s.toString();
                    this.syncs.add(s);
                } else if (tokenizer.atCDSect()) {
                    this.content = this.content + tokenizer.takeCDSect();
                } else if (tokenizer.atCharData()) {
                    this.content = this.content + tokenizer.takeCharData();
                }
                SpeechBehaviour.this.ensureDecodeProgress(tokenizer);
            }
        }

        public String getXMLTag() {
            return "text";
        }

        public String getNamespace() {
            return BMLNAMESPACE;
        }
    }
}

