/*
 * Decompiled with CFR 0.152.
 */
package saiba.bml.core;

import com.google.common.collect.ImmutableList;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import saiba.bml.core.Behaviour;
import saiba.bml.parser.SyncPoint;

public class HeadBehaviour
extends Behaviour {
    private int repeats;
    private String lexeme;
    private float amount;
    private static final List<String> DEFAULT_SYNCS = ImmutableList.of((Object)"start", (Object)"ready", (Object)"strokeStart", (Object)"stroke", (Object)"strokeEnd", (Object)"relax", (Object)"end");
    private static final String XMLTAG = "head";

    public static List<String> getDefaultSyncPoints() {
        return DEFAULT_SYNCS;
    }

    @Override
    public void addDefaultSyncPoints() {
        for (String s : HeadBehaviour.getDefaultSyncPoints()) {
            this.addSyncPoint(new SyncPoint(this.bmlId, this.id, s));
        }
    }

    @Override
    public String getStringParameterValue(String name) {
        if (name.equals("repetition")) {
            return "" + this.repeats;
        }
        if (name.equals("amount")) {
            return "" + this.amount;
        }
        if (name.equals("lexeme")) {
            return this.lexeme;
        }
        return super.getStringParameterValue(name);
    }

    @Override
    public boolean satisfiesConstraint(String name, String value) {
        if (name.equals("repetition")) {
            return Integer.parseInt(value) == this.repeats;
        }
        if (name.equals("lexeme")) {
            return this.lexeme.equals(value);
        }
        return super.satisfiesConstraint(name, value);
    }

    public HeadBehaviour(String bmlId, XMLTokenizer tokenizer) throws IOException {
        super(bmlId);
        this.readXML(tokenizer);
    }

    @Override
    public StringBuilder appendAttributeString(StringBuilder buf, XMLFormatting fmt) {
        HeadBehaviour.appendAttribute((StringBuilder)buf, (String)"lexeme", (String)this.lexeme);
        HeadBehaviour.appendAttribute((StringBuilder)buf, (String)"repetition", (int)this.repeats);
        HeadBehaviour.appendAttribute((StringBuilder)buf, (String)"amount", (float)this.amount);
        return super.appendAttributeString(buf, fmt);
    }

    @Override
    public float getFloatParameterValue(String name) {
        if (name.equals("repetition")) {
            return this.repeats;
        }
        if (name.equals("amount")) {
            return this.amount;
        }
        return super.getFloatParameterValue(name);
    }

    @Override
    public boolean specifiesParameter(String name) {
        if (name.equals("repetition") || name.equals("amount") || name.equals("lexeme")) {
            return true;
        }
        return super.specifiesParameter(name);
    }

    @Override
    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        this.repeats = this.getOptionalIntAttribute("repetition", attrMap, 1);
        if (this.repeats > 1) {
            for (int i = 1; i < this.repeats; ++i) {
                this.addSyncPoint(new SyncPoint(this.bmlId, this.id, "stroke", i));
            }
        }
        this.amount = this.getOptionalFloatAttribute("amount", attrMap, 0.5f);
        this.lexeme = this.getRequiredAttribute("lexeme", attrMap, tokenizer);
        super.decodeAttributes(attrMap, tokenizer);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    @Override
    public String getXMLTag() {
        return XMLTAG;
    }
}

