/*
 * Decompiled with CFR 0.152.
 */
package saiba.bml.core;

import com.google.common.collect.ImmutableList;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import saiba.bml.core.Behaviour;
import saiba.bml.core.Mode;
import saiba.bml.parser.SyncPoint;

public class GestureBehaviour
extends Behaviour {
    private Mode mode;
    private String target;
    private String lexeme = "";
    private static final List<String> DEFAULT_SYNCS = ImmutableList.of((Object)"start", (Object)"ready", (Object)"strokeStart", (Object)"stroke", (Object)"strokeEnd", (Object)"relax", (Object)"end");
    private static final String XMLTAG = "gesture";

    @Override
    public void addDefaultSyncPoints() {
        for (String s : GestureBehaviour.getDefaultSyncPoints()) {
            this.addSyncPoint(new SyncPoint(this.bmlId, this.id, s));
        }
    }

    public static List<String> getDefaultSyncPoints() {
        return DEFAULT_SYNCS;
    }

    public GestureBehaviour(String bmlId, XMLTokenizer tokenizer) throws IOException {
        super(bmlId);
        this.readXML(tokenizer);
    }

    @Override
    public boolean satisfiesConstraint(String name, String value) {
        if (name.equals("mode")) {
            return this.mode.toString().equals(value);
        }
        if (name.equals("lexeme")) {
            return this.lexeme.equals(value);
        }
        return super.satisfiesConstraint(name, value);
    }

    @Override
    public String getStringParameterValue(String name) {
        if (name.equals("mode")) {
            return this.mode.toString();
        }
        if (name.equals("lexeme")) {
            return this.lexeme;
        }
        return super.getStringParameterValue(name);
    }

    @Override
    public float getFloatParameterValue(String name) {
        return super.getFloatParameterValue(name);
    }

    @Override
    public boolean specifiesParameter(String name) {
        if (name.equals("mode")) {
            return true;
        }
        if (name.equals("lexeme")) {
            return true;
        }
        return super.specifiesParameter(name);
    }

    @Override
    public StringBuilder appendAttributeString(StringBuilder buf, XMLFormatting fmt) {
        if (!this.mode.equals((Object)Mode.UNSPECIFIED)) {
            GestureBehaviour.appendAttribute((StringBuilder)buf, (String)"mode", (String)this.mode.toString());
        }
        GestureBehaviour.appendAttribute((StringBuilder)buf, (String)"target", (String)this.target);
        GestureBehaviour.appendAttribute((StringBuilder)buf, (String)"lexeme", (String)this.lexeme);
        return super.appendAttributeString(buf, fmt);
    }

    @Override
    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        this.mode = Mode.valueOf(this.getOptionalAttribute("mode", attrMap, Mode.UNSPECIFIED.toString()));
        this.lexeme = this.getRequiredAttribute("lexeme", attrMap, tokenizer);
        super.decodeAttributes(attrMap, tokenizer);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    @Override
    public String getXMLTag() {
        return XMLTAG;
    }
}

