/*
 * Decompiled with CFR 0.152.
 */
package saiba.bml.core;

import hmi.xml.XMLFormatting;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import saiba.bml.core.After;
import saiba.bml.core.BMLElement;
import saiba.bml.core.Before;
import saiba.bml.core.Synchronize;
import saiba.bml.parser.BMLParser;

public class ConstraintBlock
extends BMLElement {
    public ArrayList<Synchronize> synchronizes;
    public ArrayList<Before> before;
    public ArrayList<After> after;
    public final String bmlId;
    private static final String XMLTAG = "constraint";

    public void setRequired(boolean req) {
        for (Synchronize s : this.synchronizes) {
            s.setRequired(req);
        }
        for (Before b : this.before) {
            b.setRequired(req);
        }
        for (After a : this.after) {
            a.setRequired(req);
        }
    }

    public ConstraintBlock(String bmlId) {
        this.bmlId = bmlId;
        this.synchronizes = new ArrayList();
        this.before = new ArrayList();
        this.after = new ArrayList();
    }

    @Override
    public String getBmlId() {
        return this.bmlId;
    }

    public ConstraintBlock(String bmlId, XMLTokenizer tokenizer) throws IOException {
        this(bmlId);
        this.readXML(tokenizer);
    }

    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        super.decodeAttributes(attrMap, tokenizer);
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (tag.equals(Synchronize.xmlTag())) {
                this.synchronizes.add(new Synchronize(this.bmlId, tokenizer));
            } else if (tag.equals(After.xmlTag())) {
                this.after.add(new After(this.bmlId, tokenizer));
            } else if (tag.equals(Before.xmlTag())) {
                this.before.add(new Before(this.bmlId, tokenizer));
            }
            this.ensureDecodeProgress(tokenizer);
        }
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        ConstraintBlock.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.synchronizes);
        ConstraintBlock.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.after);
        ConstraintBlock.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.before);
        return buf;
    }

    public StringBuilder appendAttributeString(StringBuilder buf) {
        return super.appendAttributeString(buf);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    @Override
    public String getXMLTag() {
        return XMLTAG;
    }

    public void constructConstraints(BMLParser scheduler) {
        for (Synchronize sync : this.synchronizes) {
            sync.constructConstraints(scheduler);
        }
        for (After aft : this.after) {
            aft.constructConstraints(scheduler);
        }
        for (Before bef : this.before) {
            bef.constructConstraints(scheduler);
        }
    }
}

