/*
 * Decompiled with CFR 0.152.
 */
package saiba.bml.core;

import hmi.xml.XMLFormatting;
import hmi.xml.XMLScanException;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import saiba.bml.BMLInfo;
import saiba.bml.core.BMLElement;
import saiba.bml.core.Description;
import saiba.bml.parser.BMLParser;
import saiba.bml.parser.InvalidSyncRefException;
import saiba.bml.parser.SyncPoint;

public abstract class Behaviour
extends BMLElement {
    private ArrayList<SyncPoint> syncPoints;
    private ArrayList<Description> descriptions;
    public Behaviour descBehaviour = null;
    protected String bmlId;
    private Map<String, String> customStringAttributes = new HashMap<String, String>();
    private Map<String, Float> customFloatAttributes = new HashMap<String, Float>();
    private boolean required = false;

    public void setRequired(boolean required) {
        this.required = required;
    }

    public boolean isRequired() {
        return this.required;
    }

    @Override
    public String getBmlId() {
        return this.bmlId;
    }

    public Behaviour(String bmlId) {
        this.syncPoints = new ArrayList();
        this.descriptions = new ArrayList();
        this.bmlId = bmlId;
        this.addDefaultSyncPoints();
    }

    public float getFloatParameterValue(String name) {
        if (this.customFloatAttributes.containsKey(name)) {
            return this.customFloatAttributes.get(name).floatValue();
        }
        throw new IllegalArgumentException("Parameter " + name + " not found/not a float.");
    }

    public String getStringParameterValue(String name) {
        if (this.customFloatAttributes.containsKey(name)) {
            return "" + this.customFloatAttributes.get(name);
        }
        return this.customStringAttributes.get(name);
    }

    public boolean specifiesParameter(String name) {
        if (this.customFloatAttributes.containsKey(name)) {
            return true;
        }
        return this.customStringAttributes.containsKey(name);
    }

    public boolean satisfiesConstraint(String name, String value) {
        if (this.customStringAttributes.containsKey(name)) {
            return this.customStringAttributes.get(name).equals(value);
        }
        return false;
    }

    public abstract void addDefaultSyncPoints();

    public void addSyncPoint(SyncPoint syncPoint) {
        this.syncPoints.add(syncPoint);
    }

    public void removeSyncPoints(List<SyncPoint> points) {
        this.syncPoints.removeAll(points);
    }

    public void addSyncPoints(List<SyncPoint> points) {
        this.syncPoints.addAll(points);
    }

    public ArrayList<SyncPoint> getSyncPoints() {
        return this.syncPoints;
    }

    public StringBuilder appendAttributeString(StringBuilder buf, XMLFormatting fmt) {
        String[] key;
        Behaviour.appendAttribute((StringBuilder)buf, (String)"id", (String)this.id);
        for (SyncPoint s : this.syncPoints) {
            String string;
            if (s.getIteration() != -1 || (string = s.getRefString()).equals("")) continue;
            Behaviour.appendAttribute((StringBuilder)buf, (String)s.getName(), (String)string);
        }
        for (Map.Entry<String, String> entry : this.customStringAttributes.entrySet()) {
            key = entry.getKey().split(":");
            Behaviour.appendNamespacedAttribute((StringBuilder)buf, (XMLFormatting)fmt, (String)key[0], (String)key[1], (String)entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.customFloatAttributes.entrySet()) {
            key = entry.getKey().split(":");
            Behaviour.appendNamespacedAttribute((StringBuilder)buf, (XMLFormatting)fmt, (String)key[0], (String)key[1], (String)("" + entry.getValue()));
        }
        return super.appendAttributeString(buf, fmt);
    }

    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        String value;
        for (String attr : BMLInfo.getCustomFloatAttributes(((Object)((Object)this)).getClass())) {
            value = this.getOptionalAttribute(attr, attrMap);
            if (value == null) continue;
            this.customFloatAttributes.put(attr, Float.valueOf(Float.parseFloat(value)));
        }
        for (String attr : BMLInfo.getCustomStringAttributes(((Object)((Object)this)).getClass())) {
            value = this.getOptionalAttribute(attr, attrMap);
            if (value == null) continue;
            this.customStringAttributes.put(attr, value);
        }
        for (SyncPoint s : this.syncPoints) {
            String ref = this.getOptionalAttribute(s.getName(), attrMap);
            if (ref == null) continue;
            try {
                s.setRefString(ref);
            }
            catch (InvalidSyncRefException e) {
                throw new XMLScanException("Invalid sync ref", (Throwable)e);
            }
        }
        this.id = this.getRequiredAttribute("id", attrMap, tokenizer);
        String[] idSplit = this.id.split(":");
        if (idSplit.length == 2) {
            this.id = idSplit[1];
            this.bmlId = idSplit[0];
        }
        for (SyncPoint s : this.syncPoints) {
            s.setBehaviourId(this.id);
            s.setBMLId(this.bmlId);
        }
        super.decodeAttributes(attrMap, tokenizer);
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        Behaviour.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.descriptions);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        int descPriority = 0;
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (tag.equals(Description.xmlTag())) {
                Description d = new Description(this.bmlId);
                d.id = this.id;
                d.readXML(tokenizer);
                if (d.isParsed && d.priority > descPriority) {
                    descPriority = d.priority;
                    this.descBehaviour = d.behaviour;
                    this.descBehaviour.id = this.id;
                    this.descBehaviour.bmlId = this.bmlId;
                }
                this.descriptions.add(d);
            }
            this.ensureDecodeProgress(tokenizer);
        }
    }

    public boolean hasContent() {
        return this.descriptions.size() > 0;
    }

    public void constructConstraints(BMLParser scheduler) {
        scheduler.constructConstraints(this);
    }
}

