/*
 * Decompiled with CFR 0.152.
 */
package saiba.bml;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import saiba.bml.core.Behaviour;
import saiba.bml.core.FaceLexemeBehaviour;
import saiba.bml.core.GazeBehaviour;
import saiba.bml.core.GestureBehaviour;
import saiba.bml.core.HeadBehaviour;
import saiba.bml.core.LocomotionBehaviour;
import saiba.bml.core.PointingBehaviour;
import saiba.bml.core.PostureBehaviour;
import saiba.bml.core.PostureShiftBehaviour;
import saiba.bml.core.SpeechBehaviour;
import saiba.bml.core.WaitBehaviour;
import saiba.bml.core.ext.FaceFacsBehaviour;

public final class BMLInfo {
    private static Set<String> externalBlockIds = new HashSet<String>();
    public static final String BMLNAMESPACE = "http://www.bml-initiative.org/bml/bml-1.0";
    private static final ImmutableMap<String, Class<? extends Behaviour>> BEHAVIOR_TYPES = new ImmutableMap.Builder().put((Object)HeadBehaviour.xmlTag(), HeadBehaviour.class).put((Object)LocomotionBehaviour.xmlTag(), LocomotionBehaviour.class).put((Object)FaceLexemeBehaviour.xmlTag(), FaceLexemeBehaviour.class).put((Object)GazeBehaviour.xmlTag(), GazeBehaviour.class).put((Object)PostureBehaviour.xmlTag(), PostureBehaviour.class).put((Object)GestureBehaviour.xmlTag(), GestureBehaviour.class).put((Object)SpeechBehaviour.xmlTag(), SpeechBehaviour.class).put((Object)WaitBehaviour.xmlTag(), WaitBehaviour.class).put((Object)PointingBehaviour.xmlTag(), PointingBehaviour.class).put((Object)FaceFacsBehaviour.xmlTag(), FaceFacsBehaviour.class).put((Object)PostureShiftBehaviour.xmlTag(), PostureShiftBehaviour.class).build();
    private static final ImmutableMap<String, Class<? extends Behaviour>> DESCRIPTION_EXTENSIONS = new ImmutableMap.Builder().build();
    public static final List<Class<? extends Behaviour>> supportedExtensions = new ArrayList<Class<? extends Behaviour>>();
    private static Map<String, Class<? extends Behaviour>> behaviourTypes = new HashMap<String, Class<? extends Behaviour>>();
    private static Map<String, Class<? extends Behaviour>> descriptionExtensions = new HashMap<String, Class<? extends Behaviour>>();
    private static SetMultimap<Class<? extends Behaviour>, String> customStringAttributes = HashMultimap.create();
    private static SetMultimap<Class<? extends Behaviour>, String> customFloatAttributes = HashMultimap.create();

    public static void addExternalBlockId(String id) {
        externalBlockIds.add(id);
    }

    public static boolean isExternalBlockId(String id) {
        return externalBlockIds.contains(id);
    }

    public static void addCustomStringAttribute(Class<? extends Behaviour> beh, String namespace, String attributeName) {
        customStringAttributes.put(beh, (Object)(namespace + ":" + attributeName));
    }

    public static void addCustomStringAttribute(Class<? extends Behaviour> beh, String namespace, List<String> attributeNames) {
        for (String att : attributeNames) {
            BMLInfo.addCustomStringAttribute(beh, namespace, att);
        }
    }

    public static void addCustomFloatAttribute(Class<? extends Behaviour> beh, String namespace, String attributeName) {
        customFloatAttributes.put(beh, (Object)(namespace + ":" + attributeName));
    }

    public static void addCustomFloatAttribute(Class<? extends Behaviour> beh, String namespace, List<String> attributeNames) {
        for (String att : attributeNames) {
            BMLInfo.addCustomFloatAttribute(beh, namespace, att);
        }
    }

    public static Set<String> getCustomFloatAttributes(Class<? extends Behaviour> beh) {
        return customFloatAttributes.get(beh);
    }

    public static Set<String> getCustomStringAttributes(Class<? extends Behaviour> beh) {
        return customStringAttributes.get(beh);
    }

    public static void addBehaviourTypes(ImmutableMap<String, Class<? extends Behaviour>> behs) {
        behaviourTypes.putAll((Map<String, Class<? extends Behaviour>>)behs);
    }

    public static void addDescriptionExtensions(ImmutableMap<String, Class<? extends Behaviour>> descs) {
        descriptionExtensions.putAll((Map<String, Class<? extends Behaviour>>)descs);
    }

    public static void addBehaviourType(String name, Class<? extends Behaviour> beh) {
        behaviourTypes.put(name, beh);
    }

    public static void addDescriptionExtension(String name, Class<? extends Behaviour> beh) {
        descriptionExtensions.put(name, beh);
    }

    public static Map<String, Class<? extends Behaviour>> getBehaviourTypes() {
        return behaviourTypes;
    }

    public static Map<String, Class<? extends Behaviour>> getDescriptionExtensions() {
        return descriptionExtensions;
    }

    private BMLInfo() {
    }

    static {
        behaviourTypes.putAll((Map<String, Class<? extends Behaviour>>)BEHAVIOR_TYPES);
        descriptionExtensions.putAll((Map<String, Class<? extends Behaviour>>)DESCRIPTION_EXTENSIONS);
    }
}

