/*
 * Decompiled with CFR 0.152.
 */
package saiba.bml.parser;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import saiba.bml.core.BMLBehaviorAttributeExtension;
import saiba.bml.core.BMLElement;
import saiba.bml.core.Behaviour;
import saiba.bml.core.BehaviourBlock;
import saiba.bml.core.Sync;
import saiba.bml.core.Synchronize;
import saiba.bml.parser.Constraint;
import saiba.bml.parser.MissingSyncPointException;
import saiba.bml.parser.SyncPoint;

public class BMLParser {
    private ArrayList<BehaviourBlock> bbs;
    private HashMap<String, BMLElement> BMLElementsById;
    private ArrayList<Constraint> constraints;
    private static Logger logger = LoggerFactory.getLogger((String)BMLParser.class.getName());
    private final ImmutableSet<Class<? extends BMLBehaviorAttributeExtension>> behaviorAttributeExtensions;

    public BMLParser(ImmutableSet<Class<? extends BMLBehaviorAttributeExtension>> behaviorAttributeExtensions) {
        this.behaviorAttributeExtensions = behaviorAttributeExtensions;
        this.bbs = new ArrayList();
        this.BMLElementsById = new HashMap();
        this.constraints = new ArrayList();
    }

    public BMLParser() {
        this((ImmutableSet<Class<? extends BMLBehaviorAttributeExtension>>)new ImmutableSet.Builder().build());
    }

    public BehaviourBlock createBehaviourBlock() throws InstantiationException, IllegalAccessException {
        ArrayList attrList = new ArrayList();
        for (Class bbClass : this.behaviorAttributeExtensions) {
            attrList.add(bbClass.newInstance());
        }
        return new BehaviourBlock(attrList.toArray(new BMLBehaviorAttributeExtension[attrList.size()]));
    }

    public void clear() {
        this.bbs.clear();
        this.BMLElementsById.clear();
        this.constraints.clear();
    }

    private BehaviourBlock getBehaviourBlock(String bmlId) {
        for (BehaviourBlock bb : this.getBehaviourBlocks()) {
            if (!bb.getBmlId().equals(bmlId)) continue;
            return bb;
        }
        return null;
    }

    public Behaviour getBehaviour(String bmlId, String behId) {
        BehaviourBlock bb = this.getBehaviourBlock(bmlId);
        if (bb == null) {
            return null;
        }
        for (Behaviour b : bb.behaviours) {
            if (b.id == null || !b.id.equals(behId)) continue;
            return b;
        }
        return null;
    }

    private List<Constraint> getSoftConstraints(String bmlId, String behId) {
        ArrayList<Constraint> constr = new ArrayList<Constraint>();
        for (Constraint c : this.getConstraints(bmlId, behId)) {
            if (c.isHard()) continue;
            constr.add(c);
        }
        return constr;
    }

    public List<Constraint> getConstraints(String bmlId, String behId) {
        ArrayList<Constraint> constr = new ArrayList<Constraint>();
        for (Constraint c : this.getConstraints()) {
            if (!c.containsBehaviour(bmlId, behId)) continue;
            constr.add(c);
        }
        return constr;
    }

    private List<Behaviour> getBehaviours(Constraint c) {
        ArrayList<Behaviour> behs = new ArrayList<Behaviour>();
        for (SyncPoint s : c.getTargets()) {
            if (s.getBehaviourId() == null) continue;
            behs.add(this.getBehaviour(s.getBmlId(), s.getBehaviourId()));
        }
        return behs;
    }

    public List<List<Behaviour>> getUngroundedLoops(String bmlId, String behId) {
        ArrayList<List<Behaviour>> list = new ArrayList<List<Behaviour>>();
        Behaviour currentBeh = this.getBehaviour(bmlId, behId);
        List<Constraint> constraints = this.getSoftConstraints(bmlId, behId);
        for (Constraint c : constraints) {
            List<Behaviour> list2 = this.getBehaviours(c);
            list2.remove((Object)currentBeh);
            for (Behaviour beh : list2) {
                if (this.directGround(beh.getBmlId(), beh.id)) continue;
                ArrayList<Constraint> checkedC = new ArrayList<Constraint>();
                checkedC.add(c);
                this.getUngroundedLoops(currentBeh, beh, new ArrayList<Behaviour>(), checkedC, list);
            }
        }
        ArrayList<List<Behaviour>> listNoDuplicates = new ArrayList<List<Behaviour>>();
        for (List list3 : list) {
            if (listNoDuplicates.contains(list3)) continue;
            Collections.reverse(list3);
            listNoDuplicates.add(list3);
        }
        return listNoDuplicates;
    }

    private void getUngroundedLoops(Behaviour loopBeh, Behaviour currentBeh, List<Behaviour> checkedBehaviours, List<Constraint> checkedConstraints, List<List<Behaviour>> pathList) {
        List<Constraint> constraints = this.getSoftConstraints(currentBeh.getBmlId(), currentBeh.id);
        ArrayList<Behaviour> checkedBeh = new ArrayList<Behaviour>(checkedBehaviours);
        checkedBeh.add(currentBeh);
        constraints.removeAll(checkedConstraints);
        for (Constraint c : constraints) {
            List<Behaviour> behs = this.getBehaviours(c);
            behs.removeAll(checkedBeh);
            for (Behaviour beh : behs) {
                if (beh == loopBeh) {
                    pathList.add(checkedBeh);
                    continue;
                }
                if (this.directGround(beh.getBmlId(), beh.id)) continue;
                ArrayList<Constraint> checkedC = new ArrayList<Constraint>(checkedConstraints);
                checkedC.add(c);
                this.getUngroundedLoops(loopBeh, beh, checkedBeh, checkedC, pathList);
            }
        }
    }

    public boolean directLink(String bmlId1, String behId1, String bmlId2, String behId2) {
        for (Constraint c : this.getConstraints()) {
            boolean containsB1 = false;
            boolean containsB2 = false;
            for (SyncPoint s : c.getTargets()) {
                if (s.getBehaviourId() == null) continue;
                if (s.getBehaviourId().equals(behId1) && s.getBmlId().equals(bmlId1)) {
                    containsB1 = true;
                }
                if (!s.getBehaviourId().equals(behId2) || !s.getBmlId().equals(bmlId2)) continue;
                containsB2 = true;
            }
            if (!containsB1 || !containsB2) continue;
            return true;
        }
        return false;
    }

    public boolean directGround(String bmlId1, String behId1) {
        for (Constraint c : this.getConstraints()) {
            boolean isGrounded = false;
            boolean containsB1 = false;
            for (SyncPoint s : c.getTargets()) {
                if (s.getBehaviourId() == null) {
                    isGrounded = true;
                    continue;
                }
                if (!s.getBehaviourId().equals(behId1) || !s.getBmlId().equals(bmlId1)) continue;
                containsB1 = true;
            }
            if (!containsB1 || !isGrounded) continue;
            return true;
        }
        return false;
    }

    public void addBehaviourBlock(BehaviourBlock bb) {
        bb.registerElementsById(this);
        this.constructConstraints(bb);
        this.bbs.add(bb);
        logger.debug("List of constraints: ");
        for (Constraint constraint : this.constraints) {
            logger.debug("\t {}", (Object)constraint);
        }
    }

    private void constructConstraints(BehaviourBlock bb) {
        bb.constructConstraints(this);
        ArrayList<Constraint> cNewList = new ArrayList<Constraint>();
        double relOffset = 0.0;
        for (Constraint cOld : this.constraints) {
            boolean merged = false;
            Constraint cMerge = null;
            SyncPoint cSyncOld = null;
            block1: for (SyncPoint syncOld : cOld.getTargets()) {
                for (Constraint cNew : cNewList) {
                    for (SyncPoint syncNew : cNew.getTargets()) {
                        if (!syncOld.equalsPoint(syncNew)) continue;
                        relOffset = syncNew.getOffset() - syncOld.getOffset();
                        merged = true;
                        cMerge = cNew;
                        cSyncOld = syncOld;
                        break;
                    }
                    if (!merged) continue;
                    continue block1;
                }
            }
            if (merged) {
                for (SyncPoint syncOld : cOld.getTargets()) {
                    if (syncOld == cSyncOld) continue;
                    SyncPoint sNew = new SyncPoint(syncOld);
                    sNew.offset += relOffset;
                    cMerge.addTarget(sNew);
                    sNew.setConstraint(cMerge);
                }
            }
            if (merged) continue;
            cNewList.add(cOld);
        }
        this.constraints = cNewList;
    }

    public void constructConstraints(Behaviour behaviour) {
        ImmutableList syncPoints = ImmutableList.copyOf(behaviour.getSyncPoints());
        for (SyncPoint syncPoint : syncPoints) {
            String ref = syncPoint.getRefString();
            if (ref == null || ref.isEmpty()) continue;
            try {
                SyncPoint foreignSyncPoint = syncPoint.getForeignSyncPoint(this);
                this.constructConstraint(syncPoint, foreignSyncPoint);
            }
            catch (MissingSyncPointException e) {
                System.err.println(e.getMessage());
            }
        }
    }

    public void constructConstraints(Synchronize synchronize) {
        SyncPoint synchronizeRef = new SyncPoint(synchronize.bmlId, synchronize.getRef());
        SyncPoint left = synchronizeRef.getForeignSyncPoint(this);
        ArrayList<Sync> syncs = synchronize.getSyncs();
        for (Sync sync : syncs) {
            SyncPoint syncRef = new SyncPoint(synchronize.bmlId, sync.ref);
            SyncPoint right = syncRef.getForeignSyncPoint(this);
            this.constructConstraint(left, right);
        }
    }

    public void constructConstraint(SyncPoint left, SyncPoint right) {
        if (right.inConstraint() && left.inConstraint()) {
            Constraint masterConstraint = left.getConstraint();
            Constraint slaveConstraint = right.getConstraint();
            ArrayList<SyncPoint> targets = slaveConstraint.getTargets();
            for (SyncPoint target : targets) {
                target.setConstraint(masterConstraint);
                masterConstraint.addTarget(target);
            }
            this.constraints.remove(slaveConstraint);
        } else if (right.inConstraint()) {
            Constraint constraint = right.getConstraint();
            constraint.addTarget(left);
            left.setConstraint(constraint);
        } else if (left.inConstraint()) {
            Constraint constraint = left.getConstraint();
            constraint.addTarget(right);
            right.setConstraint(constraint);
        } else {
            Constraint constraint = new Constraint(left, right);
            left.setConstraint(constraint);
            right.setConstraint(constraint);
            this.constraints.add(constraint);
        }
    }

    public void registerBMLElement(BMLElement element) {
        if (element.id == null) {
            return;
        }
        String fullId = element.getBmlId() + ":" + element.id;
        logger.debug("Registering {} ({}) ", (Object)((Object)((Object)element)).getClass().toString(), (Object)fullId);
        if (this.BMLElementsById.containsKey(fullId)) {
            logger.warn("fullId {}  not unique", (Object)fullId);
        } else {
            this.BMLElementsById.put(fullId, element);
        }
    }

    public BMLElement getBMLElementById(String id) {
        return this.BMLElementsById.get(id);
    }

    public ArrayList<Constraint> getConstraints() {
        return this.constraints;
    }

    public List<Behaviour> getBehaviours() {
        ArrayList<Behaviour> behs = new ArrayList<Behaviour>();
        for (BehaviourBlock bb : this.bbs) {
            behs.addAll(bb.behaviours);
        }
        return behs;
    }

    public List<BehaviourBlock> getBehaviourBlocks() {
        return this.bbs;
    }
}

