/*
 * Decompiled with CFR 0.152.
 */
package saiba.bml.feedback;

import hmi.xml.XMLFormatting;
import hmi.xml.XMLStructureAdapter;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import saiba.bml.core.Behaviour;
import saiba.bml.core.BehaviourParser;
import saiba.bml.feedback.BMLBlockPredictionFeedback;
import saiba.bml.feedback.BMLFeedback;

public final class BMLPredictionFeedback
extends XMLStructureAdapter
implements BMLFeedback {
    private List<BMLBlockPredictionFeedback> bmlBlockPredictions = new ArrayList<BMLBlockPredictionFeedback>();
    private List<Behaviour> bmlBehaviorPredictions = new ArrayList<Behaviour>();
    private String characterId;
    private static final String XMLTAG = "predictionFeedback";
    public static final String BMLNAMESPACE = "http://www.bml-initiative.org/bml/bml-1.0";

    public void setCharacterId(String characterId) {
        this.characterId = characterId;
    }

    public void addBMLBlockPrediction(BMLBlockPredictionFeedback bfp) {
        this.bmlBlockPredictions.add(bfp);
    }

    public void addBehaviorPrediction(Behaviour b) {
        this.bmlBehaviorPredictions.add(b);
    }

    public StringBuilder appendAttributeString(StringBuilder buf) {
        if (this.characterId != null) {
            BMLPredictionFeedback.appendAttribute((StringBuilder)buf, (String)"characterId", (String)this.characterId);
        }
        return super.appendAttributeString(buf);
    }

    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        this.characterId = this.getOptionalAttribute("characterId", attrMap, null);
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        BMLPredictionFeedback.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.bmlBlockPredictions);
        BMLPredictionFeedback.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.bmlBehaviorPredictions);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            if (tokenizer.getTagName().equals(BMLBlockPredictionFeedback.xmlTag())) {
                BMLBlockPredictionFeedback pred = new BMLBlockPredictionFeedback();
                pred.readXML(tokenizer);
                this.bmlBlockPredictions.add(pred);
                continue;
            }
            Behaviour b = BehaviourParser.parseBehaviour(null, tokenizer);
            if (b == null) continue;
            this.bmlBehaviorPredictions.add(b);
        }
    }

    public List<BMLBlockPredictionFeedback> getBmlBlockPredictions() {
        return this.bmlBlockPredictions;
    }

    public List<Behaviour> getBmlBehaviorPredictions() {
        return this.bmlBehaviorPredictions;
    }

    public String getCharacterId() {
        return this.characterId;
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }

    public String getNamespace() {
        return BMLNAMESPACE;
    }
}

