/*
 * Decompiled with CFR 0.152.
 */
package saiba.bml.core;

import hmi.xml.XMLFormatting;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import saiba.bml.core.BMLElement;
import saiba.bml.core.Behaviour;
import saiba.bml.core.BehaviourParser;
import saiba.bml.core.ConstraintBlock;
import saiba.bml.parser.BMLParser;

public class RequiredBlock
extends BMLElement {
    public List<ConstraintBlock> constraintBlocks;
    public List<Behaviour> behaviours;
    public final String bmlId;
    private static final String XMLTAG = "required";

    public RequiredBlock(String bmlId) {
        this.bmlId = bmlId;
        this.behaviours = new ArrayList<Behaviour>();
        this.constraintBlocks = new ArrayList<ConstraintBlock>();
    }

    @Override
    public String getBmlId() {
        return this.bmlId;
    }

    public RequiredBlock(String bmlId, XMLTokenizer tokenizer) throws IOException {
        this(bmlId);
        this.readXML(tokenizer);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    @Override
    public String getXMLTag() {
        return XMLTAG;
    }

    public StringBuilder appendAttributeString(StringBuilder buf) {
        return buf;
    }

    public boolean decodeAttribute(String attrName, String valCode, XMLTokenizer tokenizer) {
        return super.decodeAttribute(attrName, valCode, tokenizer);
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        RequiredBlock.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.behaviours);
        RequiredBlock.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.constraintBlocks);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (tag.equals(ConstraintBlock.xmlTag())) {
                this.constraintBlocks.add(new ConstraintBlock(this.bmlId, tokenizer));
            } else {
                Behaviour b = BehaviourParser.parseBehaviour(this.id, tokenizer);
                if (b != null) {
                    if (b.descBehaviour != null) {
                        this.behaviours.add(b.descBehaviour);
                    } else {
                        this.behaviours.add(b);
                    }
                }
            }
            this.ensureDecodeProgress(tokenizer);
        }
    }

    public void constructConstraints(BMLParser scheduler) {
        Iterator<Behaviour> bi = this.behaviours.iterator();
        while (bi.hasNext()) {
            bi.next().constructConstraints(scheduler);
        }
    }
}

