/*
 * Decompiled with CFR 0.152.
 */
package saiba.bml.core;

import com.google.common.collect.ImmutableList;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import saiba.bml.core.Behaviour;
import saiba.bml.core.Mode;
import saiba.bml.parser.SyncPoint;

public class PointingBehaviour
extends Behaviour {
    private Mode mode;
    private String target;
    private static final List<String> DEFAULT_SYNCS = ImmutableList.of((Object)"start", (Object)"ready", (Object)"strokeStart", (Object)"stroke", (Object)"strokeEnd", (Object)"relax", (Object)"end");
    private static final String XMLTAG = "pointing";

    public PointingBehaviour(String bmlId, XMLTokenizer tokenizer) throws IOException {
        super(bmlId);
        this.readXML(tokenizer);
    }

    @Override
    public float getFloatParameterValue(String name) {
        return super.getFloatParameterValue(name);
    }

    @Override
    public String getStringParameterValue(String name) {
        if (name.equals("target")) {
            return this.target;
        }
        if (name.equals("mode")) {
            return this.mode.toString();
        }
        return super.getStringParameterValue(name);
    }

    @Override
    public boolean specifiesParameter(String name) {
        if (name.equals("target")) {
            return true;
        }
        if (name.equals("mode")) {
            return true;
        }
        return super.specifiesParameter(name);
    }

    @Override
    public void addDefaultSyncPoints() {
        for (String s : PointingBehaviour.getDefaultSyncPoints()) {
            this.addSyncPoint(new SyncPoint(this.bmlId, this.id, s));
        }
    }

    @Override
    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        this.target = this.getRequiredAttribute("target", attrMap, tokenizer);
        this.mode = Mode.valueOf(this.getOptionalAttribute("mode", attrMap, Mode.UNSPECIFIED.toString()));
        super.decodeAttributes(attrMap, tokenizer);
    }

    @Override
    public StringBuilder appendAttributeString(StringBuilder buf, XMLFormatting fmt) {
        PointingBehaviour.appendAttribute((StringBuilder)buf, (String)"target", (String)this.target);
        if (this.mode != Mode.UNSPECIFIED) {
            PointingBehaviour.appendAttribute((StringBuilder)buf, (String)"mode", (String)this.mode.toString());
        }
        return super.appendAttributeString(buf, fmt);
    }

    public static List<String> getDefaultSyncPoints() {
        return DEFAULT_SYNCS;
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    @Override
    public String getXMLTag() {
        return XMLTAG;
    }
}

