/*
 * Decompiled with CFR 0.152.
 */
package saiba.bml.core;

import com.google.common.collect.ImmutableList;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import saiba.bml.core.Behaviour;
import saiba.bml.core.OffsetDirection;
import saiba.bml.parser.SyncPoint;

public class GazeShiftBehaviour
extends Behaviour {
    private String target;
    private float offsetAngle;
    private OffsetDirection offsetDirection = OffsetDirection.NONE;
    private String influence = "";
    private static final List<String> DEFAULT_SYNCS = ImmutableList.of((Object)"start", (Object)"end");
    private static final String XMLTAG = "gazeShift";

    @Override
    public void addDefaultSyncPoints() {
        for (String s : GazeShiftBehaviour.getDefaultSyncPoints()) {
            this.addSyncPoint(new SyncPoint(this.bmlId, this.id, s));
        }
    }

    public static List<String> getDefaultSyncPoints() {
        return DEFAULT_SYNCS;
    }

    public GazeShiftBehaviour(String bmlId, XMLTokenizer tokenizer) throws IOException {
        super(bmlId);
        this.readXML(tokenizer);
    }

    @Override
    public boolean satisfiesConstraint(String name, String value) {
        if (name.equals("influence")) {
            return this.influence.equals(value);
        }
        if (name.equals("target")) {
            return this.target.equals(value);
        }
        if (name.equals("offsetDirection")) {
            return this.offsetDirection.equals(value);
        }
        return super.satisfiesConstraint(name, value);
    }

    @Override
    public float getFloatParameterValue(String name) {
        if (name.equals("offsetAngle")) {
            return this.offsetAngle;
        }
        return super.getFloatParameterValue(name);
    }

    @Override
    public String getStringParameterValue(String name) {
        if (name.equals("target")) {
            return this.target;
        }
        if (name.equals("offsetAngle")) {
            return "" + this.offsetAngle;
        }
        if (name.equals("offsetDirection")) {
            return this.offsetDirection.toString();
        }
        if (name.equals("influence")) {
            return this.influence;
        }
        return super.getStringParameterValue(name);
    }

    @Override
    public boolean specifiesParameter(String name) {
        if (name.equals("target")) {
            return true;
        }
        if (name.equals("offsetAngle")) {
            return true;
        }
        if (name.equals("offsetDirection")) {
            return true;
        }
        if (name.equals("influence")) {
            return true;
        }
        return super.specifiesParameter(name);
    }

    @Override
    public StringBuilder appendAttributeString(StringBuilder buf, XMLFormatting fmt) {
        GazeShiftBehaviour.appendAttribute((StringBuilder)buf, (String)"target", (String)this.target);
        GazeShiftBehaviour.appendAttribute((StringBuilder)buf, (String)"offsetAngle", (float)this.offsetAngle);
        GazeShiftBehaviour.appendAttribute((StringBuilder)buf, (String)"offsetDirection", (String)this.offsetDirection.toString());
        GazeShiftBehaviour.appendAttribute((StringBuilder)buf, (String)"influence", (String)this.influence);
        return super.appendAttributeString(buf, fmt);
    }

    @Override
    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        this.target = this.getOptionalAttribute("target", attrMap);
        this.offsetAngle = this.getOptionalFloatAttribute("offsetAngle", attrMap, 0.0f);
        this.offsetDirection = OffsetDirection.valueOf(this.getOptionalAttribute("offsetDirection", attrMap, OffsetDirection.NONE.toString()));
        this.influence = this.getOptionalAttribute("influence", attrMap, "");
        super.decodeAttributes(attrMap, tokenizer);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    @Override
    public String getXMLTag() {
        return XMLTAG;
    }
}

