/*
 * Decompiled with CFR 0.152.
 */
package saiba.bml.core;

import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.MutableClassToInstanceMap;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import saiba.bml.core.BMLBehaviorAttributeExtension;
import saiba.bml.core.BMLBlockComposition;
import saiba.bml.core.BMLElement;
import saiba.bml.core.Behaviour;
import saiba.bml.core.BehaviourParser;
import saiba.bml.core.ConstraintBlock;
import saiba.bml.core.CoreComposition;
import saiba.bml.core.RequiredBlock;
import saiba.bml.parser.BMLParser;

public class BehaviourBlock
extends BMLElement {
    public ArrayList<RequiredBlock> requiredBlocks;
    public ArrayList<ConstraintBlock> constraintBlocks;
    public ArrayList<Behaviour> behaviours;
    ClassToInstanceMap<BMLBehaviorAttributeExtension> bmlBehaviorAttributeExtensions;
    private BMLBlockComposition composition = CoreComposition.UNKNOWN;
    private static final String XMLTAG = "bml";

    public BehaviourBlock(BMLBehaviorAttributeExtension ... bmlBehaviorAttributeExtensions) {
        this.bmlBehaviorAttributeExtensions = MutableClassToInstanceMap.create();
        for (BMLBehaviorAttributeExtension ext : bmlBehaviorAttributeExtensions) {
            this.bmlBehaviorAttributeExtensions.put(ext.getClass(), (Object)ext);
        }
        this.requiredBlocks = new ArrayList();
        this.constraintBlocks = new ArrayList();
        this.behaviours = new ArrayList();
    }

    protected void addBMLBehaviorAttributeExtension(BMLBehaviorAttributeExtension ext) {
        this.bmlBehaviorAttributeExtensions.put(ext.getClass(), (Object)ext);
    }

    @Override
    public String getBmlId() {
        return this.id;
    }

    public BMLBlockComposition getSchedulingMechanism() {
        return this.composition;
    }

    public BehaviourBlock(XMLTokenizer tokenizer) throws IOException {
        this(new BMLBehaviorAttributeExtension[0]);
        this.readXML(tokenizer);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    @Override
    public String getXMLTag() {
        return XMLTAG;
    }

    public StringBuilder appendAttributeString(StringBuilder buf) {
        BehaviourBlock.appendAttribute((StringBuilder)buf, (String)"id", (String)this.id);
        BehaviourBlock.appendAttribute((StringBuilder)buf, (String)"composition", (String)this.composition.toString().toLowerCase(Locale.US));
        return super.appendAttributes(buf);
    }

    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        this.id = this.getRequiredAttribute("id", attrMap, tokenizer);
        String sm = this.getOptionalAttribute("composition", attrMap, "MERGE");
        this.composition = CoreComposition.parse(sm);
        for (BMLBehaviorAttributeExtension ext : this.bmlBehaviorAttributeExtensions.values()) {
            ext.decodeAttributes(this, attrMap, tokenizer);
            if (this.composition != CoreComposition.UNKNOWN) continue;
            this.composition = ext.handleComposition(sm);
        }
        super.decodeAttributes(attrMap, tokenizer);
    }

    public <E extends BMLBehaviorAttributeExtension> E getBMLBehaviorAttributeExtension(Class<E> c) {
        return (E)((BMLBehaviorAttributeExtension)this.bmlBehaviorAttributeExtensions.getInstance(c));
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        BehaviourBlock.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.requiredBlocks);
        BehaviourBlock.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.constraintBlocks);
        BehaviourBlock.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.behaviours);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            Behaviour b;
            String tag = tokenizer.getTagName();
            if (tag.equals(RequiredBlock.xmlTag())) {
                this.requiredBlocks.add(new RequiredBlock(this.id, tokenizer));
            }
            if (tag.equals(ConstraintBlock.xmlTag())) {
                this.constraintBlocks.add(new ConstraintBlock(this.id, tokenizer));
            }
            if ((b = BehaviourParser.parseBehaviour(this.id, tokenizer)) != null) {
                if (b.descBehaviour != null) {
                    this.behaviours.add(b.descBehaviour);
                } else {
                    this.behaviours.add(b);
                }
            }
            this.ensureDecodeProgress(tokenizer);
        }
    }

    @Override
    public void registerElementsById(BMLParser scheduler) {
        scheduler.registerBMLElement(this);
        for (Behaviour b : this.behaviours) {
            b.registerElementsById(scheduler);
        }
        for (RequiredBlock ri : this.requiredBlocks) {
            ri.registerElementsById(scheduler);
        }
    }

    public void constructConstraints(BMLParser scheduler) {
        for (Behaviour b : this.behaviours) {
            b.constructConstraints(scheduler);
        }
        Iterator<RequiredBlock> ri = this.requiredBlocks.iterator();
        while (ri.hasNext()) {
            ri.next().constructConstraints(scheduler);
        }
        Iterator<ConstraintBlock> ci = this.constraintBlocks.iterator();
        while (ci.hasNext()) {
            ci.next().constructConstraints(scheduler);
        }
    }
}

