/*
 * Decompiled with CFR 0.152.
 */
package hmi.bml.feedback;

import hmi.bml.core.Behaviour;
import hmi.bml.feedback.BMLBlockPredictionFeedbackElement;
import hmi.bml.feedback.BMLPredictionFeedback;
import hmi.bml.feedback.XMLBMLPredictionFeedback;
import hmi.bml.parser.SyncPoint;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class XMLBMLPredictionFeedbackTest {
    private static final double PREDICTION_PRECISION = 1.0E-4;

    private void assertEqualBlockFeedbackElement(BMLBlockPredictionFeedbackElement fb1, BMLBlockPredictionFeedbackElement fb2) {
        Assert.assertEquals((Object)fb1.getBmlId(), (Object)fb2.getBmlId());
        Assert.assertEquals((double)fb1.getGlobalStart(), (double)fb2.getGlobalStart(), (double)1.0E-4);
        Assert.assertEquals((double)fb1.getGlobalEnd(), (double)fb2.getGlobalEnd(), (double)1.0E-4);
    }

    private void assertSyncsWithBMLOffset(List<SyncPoint> syncs, String bmlId, String behaviourId) {
        for (SyncPoint s : syncs) {
            Assert.assertEquals((Object)behaviourId, (Object)s.getBehaviourId());
            Assert.assertEquals((Object)bmlId, (Object)s.getBmlId());
            Assert.assertNotNull((String)("Null syncref for " + s), (Object)s.getRef());
            Assert.assertEquals((Object)"bml", (Object)s.getRef().sourceId);
            Assert.assertEquals((Object)"start", (Object)s.getRef().syncId);
        }
    }

    private void assertSyncsIds(List<SyncPoint> syncs, String ... names) {
        int i = 0;
        for (SyncPoint s : syncs) {
            Assert.assertEquals((Object)names[i], (Object)s.getName());
            ++i;
        }
    }

    private void assertSyncsTimes(List<SyncPoint> syncs, int ... times) {
        int i = 0;
        for (SyncPoint s : syncs) {
            Assert.assertEquals((double)s.getRef().offset, (double)times[i], (double)1.0E-4);
            ++i;
        }
    }

    @Test
    public void testReadXML() {
        String feedback = "<predictionFeedback><bml id=\"bml1\" globalStart=\"1\" globalEnd=\"7\"/><gesture id=\"bml1:gesture1\" type=\"BEAT\" start=\"0\" ready=\"1\" strokeStart=\"3\" stroke=\"4\" strokeEnd=\"5\" relax=\"6\" end=\"7\"/><head id=\"bml1:head1\" action=\"ROTATION\" rotation=\"NOD\" start=\"0\" ready=\"1\" strokeStart=\"3\" stroke=\"4\" strokeEnd=\"5\" relax=\"6\" end=\"7\"/></predictionFeedback>";
        XMLBMLPredictionFeedback fbXML = new XMLBMLPredictionFeedback();
        fbXML.readXML(feedback);
        BMLPredictionFeedback fb = fbXML.getPredictionFeedback();
        Assert.assertEquals((long)1L, (long)fb.getBlockFeedbackElements().size());
        Assert.assertEquals((long)2L, (long)fb.getBehaviorFeedbackElements().size());
        this.assertEqualBlockFeedbackElement(new BMLBlockPredictionFeedbackElement("bml1", 1.0, 7.0), (BMLBlockPredictionFeedbackElement)fb.getBlockFeedbackElements().get(0));
        Behaviour b1 = (Behaviour)((Object)fb.getBehaviorFeedbackElements().get(0));
        Assert.assertEquals((Object)"gesture1", (Object)b1.id);
        Assert.assertEquals((Object)"bml1", (Object)b1.getBmlId());
        this.assertSyncsWithBMLOffset(b1.getSyncPoints(), "bml1", "gesture1");
        this.assertSyncsIds(b1.getSyncPoints(), new String[]{"start", "ready", "strokeStart", "stroke", "strokeEnd", "relax", "end"});
        this.assertSyncsTimes(b1.getSyncPoints(), new int[]{0, 1, 3, 4, 5, 6, 7});
        Behaviour b2 = (Behaviour)((Object)fb.getBehaviorFeedbackElements().get(1));
        Assert.assertEquals((Object)"head1", (Object)b2.id);
        Assert.assertEquals((Object)"bml1", (Object)b2.getBmlId());
        this.assertSyncsWithBMLOffset(b2.getSyncPoints(), "bml1", "head1");
        this.assertSyncsIds(b2.getSyncPoints(), new String[]{"start", "ready", "strokeStart", "stroke", "strokeEnd", "relax", "end"});
        this.assertSyncsTimes(b2.getSyncPoints(), new int[]{0, 1, 3, 4, 5, 6, 7});
    }

    @Test
    public void testReadXMLWithSpeechSync() {
        String feedback = "<predictionFeedback><speech id=\"bml1:s1\" start=\"1\" end=\"10\"><text>Hello <sync id=\"sync1\" ref=\"2\"/> world</text></speech></predictionFeedback>";
        XMLBMLPredictionFeedback fbXML = new XMLBMLPredictionFeedback();
        fbXML.readXML(feedback);
        BMLPredictionFeedback fb = fbXML.getPredictionFeedback();
        Assert.assertEquals((long)0L, (long)fb.getBlockFeedbackElements().size());
        Assert.assertEquals((long)1L, (long)fb.getBehaviorFeedbackElements().size());
        Behaviour b1 = (Behaviour)((Object)fb.getBehaviorFeedbackElements().get(0));
        Assert.assertEquals((Object)"s1", (Object)b1.id);
        Assert.assertEquals((Object)"bml1", (Object)b1.getBmlId());
        Assert.assertEquals((long)3L, (long)b1.getSyncPoints().size());
        this.assertSyncsWithBMLOffset(b1.getSyncPoints(), "bml1", "s1");
        this.assertSyncsIds(b1.getSyncPoints(), new String[]{"start", "end", "sync1"});
        this.assertSyncsTimes(b1.getSyncPoints(), new int[]{1, 10, 2});
    }
}

