/*
 * Decompiled with CFR 0.152.
 */
package hmi.bml.feedback;

import hmi.bml.feedback.BMLBlockPredictionFeedbackElement;
import hmi.bml.feedback.XMLBMLBlockPredictionFeedbackElement;
import hmi.xml.XMLScanException;
import java.io.IOException;
import org.custommonkey.xmlunit.XMLAssert;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.SAXException;

public class XMLBMLBlockPredictionFeedbackElementTest {
    private static final double TIME_PRECISION = 1.0E-4;

    @Test
    public void testReadXML() {
        XMLBMLBlockPredictionFeedbackElement fb = new XMLBMLBlockPredictionFeedbackElement();
        String str = "<bml id=\"bml1\" globalStart=\"1\" globalEnd=\"2\"/>";
        fb.readXML(str);
        BMLBlockPredictionFeedbackElement elem = fb.getBMLBlockPredictionFeedbackElement();
        Assert.assertEquals((Object)"bml1", (Object)elem.getBmlId());
        Assert.assertEquals((double)1.0, (double)elem.getGlobalStart(), (double)1.0E-4);
        Assert.assertEquals((double)2.0, (double)elem.getGlobalEnd(), (double)1.0E-4);
    }

    @Test(expected=XMLScanException.class)
    public void testEndOrStartRequired() {
        XMLBMLBlockPredictionFeedbackElement fb = new XMLBMLBlockPredictionFeedbackElement();
        String str = "<bml id=\"bml1\"/>";
        fb.readXML(str);
    }

    @Test
    public void testWriteXML() throws SAXException, IOException {
        XMLBMLBlockPredictionFeedbackElement fb = new XMLBMLBlockPredictionFeedbackElement(new BMLBlockPredictionFeedbackElement("bml1", 1.0, 2.0));
        StringBuilder buf = new StringBuilder();
        fb.appendXML(buf);
        System.out.println(buf.toString());
        XMLAssert.assertXMLEqual((String)"<bml id=\"bml1\" globalStart=\"1.0\" globalEnd=\"2.0\"/>", (String)buf.toString());
    }
}

