/*
 * Decompiled with CFR 0.152.
 */
package hmi.bml.feedback;

import hmi.bml.feedback.BMLFeedbackListener;
import hmi.bml.feedback.BMLPerformanceStartFeedback;
import hmi.bml.feedback.BMLPerformanceStopFeedback;
import hmi.bml.feedback.BMLSyncPointProgressFeedback;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ListFeedbackListener
implements BMLFeedbackListener {
    private final List<BMLSyncPointProgressFeedback> feedBackList;
    private final List<BMLPerformanceStartFeedback> startFeedbackList;
    private final List<BMLPerformanceStopFeedback> endFeedbackList;
    private final HashMap<Object, Integer> indexMap = new HashMap();
    private int index = 0;

    public ListFeedbackListener(List<BMLSyncPointProgressFeedback> fbList) {
        this.feedBackList = fbList;
        this.startFeedbackList = new ArrayList<BMLPerformanceStartFeedback>();
        this.endFeedbackList = new ArrayList<BMLPerformanceStopFeedback>();
    }

    public ListFeedbackListener(List<BMLSyncPointProgressFeedback> fbList, List<BMLPerformanceStartFeedback> fbStartList, List<BMLPerformanceStopFeedback> fbEndList) {
        this.feedBackList = fbList;
        this.startFeedbackList = fbStartList;
        this.endFeedbackList = fbEndList;
    }

    @Override
    public void performanceStart(BMLPerformanceStartFeedback psf) {
        this.startFeedbackList.add(psf);
        this.indexMap.put(psf, this.index);
        ++this.index;
    }

    @Override
    public void performanceStop(BMLPerformanceStopFeedback psf) {
        this.endFeedbackList.add(psf);
        this.indexMap.put(psf, this.index);
        ++this.index;
    }

    @Override
    public void syncProgress(BMLSyncPointProgressFeedback spp) {
        this.feedBackList.add(spp);
        this.indexMap.put(spp, this.index);
        ++this.index;
    }

    public int getIndex(Object feedback) {
        return this.indexMap.get(feedback);
    }

    public List<BMLSyncPointProgressFeedback> getFeedback(String bmlId, String behaviorId) {
        ArrayList<BMLSyncPointProgressFeedback> syncs = new ArrayList<BMLSyncPointProgressFeedback>();
        for (BMLSyncPointProgressFeedback fb : this.feedBackList) {
            if (!fb.bmlId.equals(bmlId) || !fb.behaviorId.equals(behaviorId)) continue;
            syncs.add(fb);
        }
        return syncs;
    }

    public List<String> getFeedbackSyncIds(String bmlId, String behaviorId) {
        ArrayList<String> syncs = new ArrayList<String>();
        for (BMLSyncPointProgressFeedback fb : this.feedBackList) {
            if (!fb.bmlId.equals(bmlId) || !fb.behaviorId.equals(behaviorId)) continue;
            syncs.add(fb.syncId);
        }
        return syncs;
    }
}

