/*
 * Decompiled with CFR 0.152.
 */
package hmi.bml.core.ext;

import com.google.common.collect.ImmutableList;
import hmi.bml.core.Behaviour;
import hmi.bml.parser.SyncPoint;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;

public class FaceFacsBehaviour
extends Behaviour {
    private float amount;
    private Side side;
    private int au;
    private static final String XMLTAG = "faceFacs";
    private static final List<String> DEFAULT_SYNCS = ImmutableList.of((Object)"start", (Object)"attackPeak", (Object)"relax", (Object)"end");
    static final String BMLTNAMESPACE = "http://www.bml-initiative.org/bml/coreextensions-1.0";

    public FaceFacsBehaviour(String bmlId, XMLTokenizer tokenizer) throws IOException {
        super(bmlId);
        this.readXML(tokenizer);
    }

    @Override
    public float getFloatParameterValue(String name) {
        if (name.equals("amount")) {
            return this.amount;
        }
        if (name.equals("au")) {
            return this.au;
        }
        throw new IllegalArgumentException("Parameter " + name + " not found/not a float.");
    }

    @Override
    public StringBuilder appendAttributeString(StringBuilder buf) {
        FaceFacsBehaviour.appendAttribute((StringBuilder)buf, (String)"amount", (float)this.amount);
        FaceFacsBehaviour.appendAttribute((StringBuilder)buf, (String)"side", (String)this.side.toString());
        FaceFacsBehaviour.appendAttribute((StringBuilder)buf, (String)"au", (int)this.au);
        return super.appendAttributeString(buf);
    }

    @Override
    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        this.amount = this.getOptionalFloatAttribute("amount", attrMap, 0.5f);
        this.side = Side.valueOf(this.getOptionalAttribute("side", attrMap, "BOTH"));
        this.au = this.getRequiredIntAttribute("au", attrMap, tokenizer);
        super.decodeAttributes(attrMap, tokenizer);
    }

    @Override
    public String getStringParameterValue(String name) {
        if (name.equals("amount")) {
            return "" + this.amount;
        }
        if (name.equals("au")) {
            return "" + this.au;
        }
        if (name.equals("side")) {
            return this.side.toString();
        }
        return null;
    }

    @Override
    public boolean specifiesParameter(String name) {
        return name.equals("amount") || name.equals("side");
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    @Override
    public String getXMLTag() {
        return XMLTAG;
    }

    public static List<String> getDefaultSyncPoints() {
        return DEFAULT_SYNCS;
    }

    @Override
    public void addDefaultSyncPoints() {
        for (String s : FaceFacsBehaviour.getDefaultSyncPoints()) {
            this.addSyncPoint(new SyncPoint(this.bmlId, this.id, s));
        }
    }

    public String getNamespace() {
        return BMLTNAMESPACE;
    }

    private static enum Side {
        LEFT,
        RIGHT,
        BOTH;

    }
}

