/*
 * Decompiled with CFR 0.152.
 */
package hmi.bml.core;

import com.google.common.collect.ImmutableList;
import hmi.bml.core.Behaviour;
import hmi.bml.parser.SyncPoint;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;

public class HeadBehaviour
extends Behaviour {
    private Action action;
    private static final List<String> DEFAULT_SYNCS = ImmutableList.of((Object)"start", (Object)"ready", (Object)"strokeStart", (Object)"stroke", (Object)"strokeEnd", (Object)"relax", (Object)"end");
    private Rotation rotation;
    private int repeats;
    private float amount;
    private Orientation orientation;
    private String offset;
    private static final String XMLTAG = "head";

    public static List<String> getDefaultSyncPoints() {
        return DEFAULT_SYNCS;
    }

    @Override
    public void addDefaultSyncPoints() {
        for (String s : HeadBehaviour.getDefaultSyncPoints()) {
            this.addSyncPoint(new SyncPoint(this.bmlId, this.id, s));
        }
    }

    @Override
    public String getStringParameterValue(String name) {
        if (name.equals("action")) {
            return this.action.toString();
        }
        if (name.equals("rotation")) {
            return this.rotation.toString();
        }
        if (name.equals("repeats")) {
            return "" + this.repeats;
        }
        if (name.equals("amount")) {
            return "" + this.amount;
        }
        if (name.equals("orientation")) {
            return this.orientation.toString();
        }
        if (name.equals("offset")) {
            return this.offset;
        }
        return null;
    }

    @Override
    public boolean satisfiesConstraint(String name, String value) {
        if (name.equals("action")) {
            if (this.action == Action.ROTATION) {
                return value.equals("ROTATION");
            }
            if (this.action == Action.ORIENTATION) {
                return value.equals("ORIENTATION");
            }
        } else if (name.equals("rotation")) {
            switch (this.rotation) {
                case NOD: 
                case X: {
                    return value.equals("NOD") || value.equals("X");
                }
                case SHAKE: 
                case Y: {
                    return value.equals("SHAKE") || value.equals("Y");
                }
                case TILT: 
                case Z: {
                    return value.equals("TILT") || value.equals("Z");
                }
            }
        } else {
            if (name.equals("repeats")) {
                return Integer.parseInt(value) == this.repeats;
            }
            if (name.equals("orientation")) {
                switch (this.orientation) {
                    case FRONT: {
                        return value.equals("FRONT");
                    }
                    case RIGHT: {
                        return value.equals("RIGHT");
                    }
                    case LEFT: {
                        return value.equals("LEFT");
                    }
                    case UP: {
                        return value.equals("UP");
                    }
                    case DOWN: {
                        return value.equals("DOWN");
                    }
                    case UP_RIGHT: {
                        return value.equals("UP_RIGHT");
                    }
                    case UP_LEFT: {
                        return value.equals("UP_LEFT");
                    }
                    case DOWN_RIGHT: {
                        return value.equals("DOWN_RIGHT");
                    }
                    case DOWN_LEFT: {
                        return value.equals("DOWN_LEFT");
                    }
                    case POLAR_ANGLE: {
                        return value.equals("POLAR_ANGLE");
                    }
                }
            }
        }
        return false;
    }

    public HeadBehaviour(String bmlId, XMLTokenizer tokenizer) throws IOException {
        super(bmlId);
        this.readXML(tokenizer);
    }

    @Override
    public StringBuilder appendAttributeString(StringBuilder buf) {
        HeadBehaviour.appendAttribute((StringBuilder)buf, (String)"action", (String)this.action.toString());
        if (this.action == Action.ROTATION) {
            HeadBehaviour.appendAttribute((StringBuilder)buf, (String)"rotation", (String)this.rotation.toString());
        }
        HeadBehaviour.appendAttribute((StringBuilder)buf, (String)"repeats", (int)this.repeats);
        HeadBehaviour.appendAttribute((StringBuilder)buf, (String)"amount", (float)this.amount);
        if (this.action == Action.ORIENTATION) {
            HeadBehaviour.appendAttribute((StringBuilder)buf, (String)"orientation", (String)this.orientation.toString());
        }
        HeadBehaviour.appendAttribute((StringBuilder)buf, (String)"offset", (String)this.offset);
        return super.appendAttributeString(buf);
    }

    @Override
    public float getFloatParameterValue(String name) {
        if (name.equals("repeats")) {
            return this.repeats;
        }
        if (name.equals("amount")) {
            return this.amount;
        }
        throw new IllegalArgumentException("Parameter " + name + " not found/not a float.");
    }

    @Override
    public boolean specifiesParameter(String name) {
        return name.equals("repeats") || name.equals("amount");
    }

    @Override
    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        this.action = Action.valueOf(this.getRequiredAttribute("action", attrMap, tokenizer));
        if (this.action == Action.ROTATION) {
            this.rotation = Rotation.valueOf(this.getRequiredAttribute("rotation", attrMap, tokenizer));
        }
        this.repeats = this.getOptionalIntAttribute("repeats", attrMap, 1);
        if (this.repeats > 1) {
            for (int i = 1; i < this.repeats; ++i) {
                this.addSyncPoint(new SyncPoint(this.bmlId, this.id, "stroke", i));
            }
        }
        this.amount = this.getOptionalFloatAttribute("amount", attrMap, 0.5f);
        if (this.action == Action.ORIENTATION) {
            this.orientation = Orientation.valueOf(this.getRequiredAttribute("orientation", attrMap, tokenizer));
        }
        this.offset = this.getOptionalAttribute("offset", attrMap);
        super.decodeAttributes(attrMap, tokenizer);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    @Override
    public String getXMLTag() {
        return XMLTAG;
    }

    private static enum Orientation {
        FRONT,
        RIGHT,
        LEFT,
        UP,
        DOWN,
        UP_RIGHT,
        UP_LEFT,
        DOWN_RIGHT,
        DOWN_LEFT,
        POLAR_ANGLE;

    }

    private static enum Rotation {
        X,
        NOD,
        Y,
        SHAKE,
        Z,
        TILT;

    }

    private static enum Action {
        ROTATION,
        ORIENTATION;

    }
}

