/*
 * Decompiled with CFR 0.152.
 */
package hmi.bml.core;

import hmi.bml.core.GazeBehaviour;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;

public class GazeBehaviourTest {
    private static final double PARAMETER_PRECISION = 1.0E-4;

    @Test
    public void testReadXML() throws IOException {
        String str = "<gaze id=\"gaze1\" target=\"bluebox\" start=\"1\" type=\"AT\"/>";
        GazeBehaviour beh = new GazeBehaviour("bml1", new XMLTokenizer(str));
        Assert.assertEquals((Object)"gaze1", (Object)beh.id);
        Assert.assertEquals((Object)"bml1", (Object)beh.bmlId);
        Assert.assertEquals((Object)"bluebox", (Object)beh.getStringParameterValue("target"));
        Assert.assertEquals((Object)"AT", (Object)beh.getStringParameterValue("type"));
        Assert.assertEquals((double)1.0, (double)beh.getSyncPoints().get((int)0).getRef().offset, (double)1.0E-4);
    }

    @Test
    public void writeReadXML() throws IOException {
        String str = "<gaze id=\"gaze1\" target=\"bluebox\" start=\"1\" type=\"AT\"/>";
        GazeBehaviour behIn = new GazeBehaviour("bml1", new XMLTokenizer(str));
        StringBuilder buf = new StringBuilder();
        behIn.appendXML(buf);
        GazeBehaviour behOut = new GazeBehaviour("bml1", new XMLTokenizer(buf.toString()));
        Assert.assertEquals((Object)"gaze1", (Object)behOut.id);
        Assert.assertEquals((Object)"bml1", (Object)behOut.bmlId);
        Assert.assertEquals((Object)"bluebox", (Object)behOut.getStringParameterValue("target"));
        Assert.assertEquals((Object)"AT", (Object)behOut.getStringParameterValue("type"));
        Assert.assertEquals((double)1.0, (double)behOut.getSyncPoints().get((int)0).getRef().offset, (double)1.0E-4);
    }
}

