/*
 * Decompiled with CFR 0.152.
 */
package hmi.bml.core;

import com.google.common.collect.ImmutableList;
import hmi.bml.core.Behaviour;
import hmi.bml.parser.SyncPoint;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;

public class FaceBehaviour
extends Behaviour {
    private Type type;
    private float amount;
    private Side side;
    private Direction direction;
    private EyebrowPart eyebrowPart;
    private MouthPart mouthPart;
    private int au;
    private String lexeme;
    private static final List<String> DEFAULT_SYNCS = ImmutableList.of((Object)"start", (Object)"attackPeak", (Object)"relax", (Object)"end");
    private static final String XMLTAG = "face";

    @Override
    public float getFloatParameterValue(String name) {
        if (name.equals("au")) {
            return this.au;
        }
        if (name.equals("amount")) {
            return this.amount;
        }
        throw new IllegalArgumentException("Parameter " + name + " not found/not a float.");
    }

    public static List<String> getDefaultSyncPoints() {
        return DEFAULT_SYNCS;
    }

    @Override
    public String getStringParameterValue(String name) {
        if (name.equals("type")) {
            return this.type.toString();
        }
        if (name.equals("amount")) {
            return "" + this.amount;
        }
        if (name.equals("side")) {
            return this.side.toString();
        }
        if (name.equals("direction")) {
            return this.direction.toString();
        }
        if (name.equals("eyebrow_part")) {
            return this.eyebrowPart.toString();
        }
        if (name.equals("mouth_part")) {
            return this.mouthPart.toString();
        }
        if (name.equals("au")) {
            return "" + this.au;
        }
        if (name.equals("lexeme")) {
            return this.lexeme;
        }
        return null;
    }

    @Override
    public boolean specifiesParameter(String name) {
        return name.equals("type") || name.equals("amount") || name.equals("side") || name.equals("direction") || name.equals("eyebrow_part") || name.equals("mouth_part") || name.equals("au") || name.equals("lexeme");
    }

    @Override
    public boolean satisfiesConstraint(String name, String value) {
        if (name.equals("type")) {
            return this.type.toString().equals(value);
        }
        if (name.equals("amount")) {
            return value.equals("" + this.amount);
        }
        if (name.equals("side")) {
            return this.side.toString().equals(value);
        }
        if (name.equals("direction")) {
            return this.direction.toString().equals(value);
        }
        if (name.equals("eyebrow_part")) {
            return this.eyebrowPart.toString().equals(value);
        }
        if (name.equals("mouth_part")) {
            return this.mouthPart.toString().equals(value);
        }
        if (name.equals("au")) {
            return value.equals("" + this.au);
        }
        if (name.equals("lexeme")) {
            return value.equals(this.lexeme);
        }
        return false;
    }

    public FaceBehaviour(String bmlId, XMLTokenizer tokenizer) throws IOException {
        super(bmlId);
        this.readXML(tokenizer);
    }

    @Override
    public StringBuilder appendAttributeString(StringBuilder buf) {
        FaceBehaviour.appendAttribute((StringBuilder)buf, (String)"type", (String)this.type.toString());
        FaceBehaviour.appendAttribute((StringBuilder)buf, (String)"amount", (float)this.amount);
        FaceBehaviour.appendAttribute((StringBuilder)buf, (String)"side", (String)this.side.toString());
        switch (this.type) {
            case BLINK: {
                break;
            }
            case EYEBROW: {
                FaceBehaviour.appendAttribute((StringBuilder)buf, (String)"eyebrow_part", (String)this.eyebrowPart.toString());
                FaceBehaviour.appendAttribute((StringBuilder)buf, (String)"direction", (String)this.direction.toString());
                break;
            }
            case MOUTH: {
                FaceBehaviour.appendAttribute((StringBuilder)buf, (String)"mouth_part", (String)this.mouthPart.toString());
                FaceBehaviour.appendAttribute((StringBuilder)buf, (String)"direction", (String)this.direction.toString());
                break;
            }
            case FACS: {
                FaceBehaviour.appendAttribute((StringBuilder)buf, (String)"au", (int)this.au);
                break;
            }
            case LEXICALIZED: {
                FaceBehaviour.appendAttribute((StringBuilder)buf, (String)"lexeme", (String)this.lexeme);
            }
        }
        return super.appendAttributeString(buf);
    }

    @Override
    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        this.type = Type.valueOf(this.getRequiredAttribute("type", attrMap, tokenizer));
        this.amount = this.getOptionalFloatAttribute("amount", attrMap, 0.5f);
        this.side = Side.valueOf(this.getOptionalAttribute("side", attrMap, Side.BOTH.toString()));
        switch (this.type) {
            case BLINK: {
                break;
            }
            case EYEBROW: {
                this.eyebrowPart = EyebrowPart.valueOf(this.getOptionalAttribute("eyebrow_part", attrMap, EyebrowPart.BOTH.toString()));
                this.direction = Direction.valueOf(this.getRequiredAttribute("direction", attrMap, tokenizer));
                break;
            }
            case MOUTH: {
                this.mouthPart = MouthPart.valueOf(this.getOptionalAttribute("mouth_part", attrMap, MouthPart.CORNERS.toString()));
                this.direction = Direction.valueOf(this.getRequiredAttribute("direction", attrMap, tokenizer));
                break;
            }
            case FACS: {
                this.au = this.getOptionalIntAttribute("au", attrMap, 0);
                break;
            }
            case LEXICALIZED: {
                this.lexeme = this.getRequiredAttribute("lexeme", attrMap, tokenizer);
            }
        }
        super.decodeAttributes(attrMap, tokenizer);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    @Override
    public String getXMLTag() {
        return XMLTAG;
    }

    @Override
    public void addDefaultSyncPoints() {
        for (String s : FaceBehaviour.getDefaultSyncPoints()) {
            this.addSyncPoint(new SyncPoint(this.bmlId, this.id, s));
        }
    }

    private static enum MouthPart {
        CORNERS;

    }

    private static enum EyebrowPart {
        INNER,
        OUTER,
        BOTH;

    }

    private static enum Direction {
        X,
        Y,
        Z;

    }

    private static enum Side {
        LEFT,
        RIGHT,
        BOTH;

    }

    private static enum Type {
        EYEBROW,
        MOUTH,
        BLINK,
        FACS,
        LEXICALIZED;

    }
}

