/*
 * Decompiled with CFR 0.152.
 */
package hmi.bml.core;

import hmi.bml.BMLInfo;
import hmi.bml.core.Behaviour;
import hmi.bml.parser.SyncPoint;
import hmi.xml.XMLScanException;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;

public final class BehaviourParser {
    private BehaviourParser() {
    }

    public static Behaviour parseBehaviour(String bmlId, XMLTokenizer tokenizer) throws IOException {
        String tag = tokenizer.getTagName();
        for (String str : BMLInfo.getBehaviourTypes().keySet()) {
            if (!str.equals(tag)) continue;
            Behaviour b = null;
            try {
                Constructor<? extends Behaviour> c = BMLInfo.getBehaviourTypes().get(tag).getConstructor(String.class, XMLTokenizer.class);
                b = c.newInstance(bmlId, tokenizer);
            }
            catch (InstantiationException e) {
                throw new XMLScanException(e.getMessage(), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new XMLScanException(e.getMessage(), (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                throw new XMLScanException(e.getMessage(), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new XMLScanException(e.getCause().getMessage(), e.getCause());
            }
            catch (SecurityException e) {
                throw new XMLScanException(e.getMessage(), (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                throw new XMLScanException(e.getMessage(), (Throwable)e);
            }
            if (b == null) continue;
            if (b.descBehaviour == null) {
                return b;
            }
            ArrayList<SyncPoint> removeList = new ArrayList<SyncPoint>();
            ArrayList<SyncPoint> addList = new ArrayList<SyncPoint>();
            for (SyncPoint s : b.getSyncPoints()) {
                boolean add = true;
                for (SyncPoint sDesc : b.descBehaviour.getSyncPoints()) {
                    if (!s.getName().equals(sDesc.getName())) continue;
                    if (sDesc.getRef() == null) {
                        removeList.add(sDesc);
                        break;
                    }
                    add = false;
                    break;
                }
                if (!add) continue;
                s.setBehaviourId(b.descBehaviour.id);
                addList.add(s);
            }
            b.descBehaviour.removeSyncPoints(removeList);
            b.descBehaviour.addSyncPoints(addList);
            return b;
        }
        return null;
    }
}

