/*
 * Decompiled with CFR 0.152.
 */
package hmi.bml.core;

import hmi.bml.core.BMLElement;
import hmi.bml.core.Description;
import hmi.bml.parser.BMLParser;
import hmi.bml.parser.InvalidSyncRefException;
import hmi.bml.parser.SyncPoint;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLScanException;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public abstract class Behaviour
extends BMLElement {
    private ArrayList<SyncPoint> syncPoints = new ArrayList();
    private ArrayList<Description> descriptions = new ArrayList();
    public Behaviour descBehaviour = null;
    protected String bmlId;

    @Override
    public String getBmlId() {
        return this.bmlId;
    }

    public Behaviour(String bmlId) {
        this.bmlId = bmlId;
        this.addDefaultSyncPoints();
    }

    public abstract float getFloatParameterValue(String var1);

    public abstract String getStringParameterValue(String var1);

    public abstract boolean specifiesParameter(String var1);

    public boolean satisfiesConstraint(String name, String value) {
        return false;
    }

    public abstract void addDefaultSyncPoints();

    public void addSyncPoint(SyncPoint syncPoint) {
        this.syncPoints.add(syncPoint);
    }

    public void removeSyncPoints(List<SyncPoint> points) {
        this.syncPoints.removeAll(points);
    }

    public void addSyncPoints(List<SyncPoint> points) {
        this.syncPoints.addAll(points);
    }

    public ArrayList<SyncPoint> getSyncPoints() {
        return this.syncPoints;
    }

    public StringBuilder appendAttributeString(StringBuilder buf) {
        Behaviour.appendAttribute((StringBuilder)buf, (String)"id", (String)this.id);
        for (SyncPoint s : this.syncPoints) {
            String ref;
            if (s.getIteration() != -1 || (ref = s.getRefString()).equals("")) continue;
            Behaviour.appendAttribute((StringBuilder)buf, (String)s.getName(), (String)ref);
        }
        return super.appendAttributeString(buf);
    }

    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        for (SyncPoint s : this.syncPoints) {
            String ref = this.getOptionalAttribute(s.getName(), attrMap);
            if (ref == null) continue;
            try {
                s.setRefString(ref);
            }
            catch (InvalidSyncRefException e) {
                throw new XMLScanException("Invalid sync ref", (Throwable)e);
            }
        }
        this.id = this.getRequiredAttribute("id", attrMap, tokenizer);
        String[] idSplit = this.id.split(":");
        if (idSplit.length == 2) {
            this.id = idSplit[1];
            this.bmlId = idSplit[0];
        }
        for (SyncPoint s : this.syncPoints) {
            s.setBehaviourId(this.id);
            s.setBMLId(this.bmlId);
        }
        super.decodeAttributes(attrMap, tokenizer);
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        Behaviour.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.descriptions);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        int descPriority = 0;
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (tag.equals(Description.xmlTag())) {
                Description d = new Description(this.bmlId);
                d.id = this.id;
                d.readXML(tokenizer);
                if (d.isParsed && d.priority > descPriority) {
                    descPriority = d.priority;
                    this.descBehaviour = d.behaviour;
                    this.descBehaviour.id = this.id;
                    this.descBehaviour.bmlId = this.bmlId;
                }
                this.descriptions.add(d);
            }
            this.ensureDecodeProgress(tokenizer);
        }
    }

    public boolean hasContent() {
        return this.descriptions.size() > 0;
    }

    public void constructConstraints(BMLParser scheduler) {
        scheduler.constructConstraints(this);
    }
}

