/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.junit.ext;

import com.googlecode.junit.ext.Context;
import com.googlecode.junit.ext.Precondition;
import com.googlecode.junit.ext.Preconditions;
import com.googlecode.junit.ext.RunIf;
import com.googlecode.junit.ext.checkers.Checker;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.junit.internal.runners.InitializationError;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JunitExtSpringRunner
extends SpringJUnit4ClassRunner {
    public JunitExtSpringRunner(Class<?> aClass) throws InitializationError {
        super(aClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invokeTestMethod(Method method, RunNotifier notifier) {
        block18: {
            block16: {
                if (!this.isPrereuisitSatisfied(method)) break block16;
                Description description = this.methodDescription(method);
                Object test = this.createTest(notifier, description);
                if (test == null) {
                    return;
                }
                List<Precondition> list = this.createPrecondtions(method, test);
                for (Precondition precondition : list) {
                    try {
                        this.getTestContextManager().prepareTestInstance((Object)precondition);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ArrayList<Exception> possibleExceptions = new ArrayList<Exception>();
                int failedAt = this.invokeSetupForPreconditions(list, possibleExceptions);
                try {
                    if (this.arePreconditionsSetUpSucceed(failedAt)) {
                        super.invokeTestMethod(method, notifier);
                    } else {
                        notifier.fireTestStarted(description);
                        notifier.fireTestStarted(description);
                    }
                    failedAt = this.arePreconditionsSetUpSucceed(failedAt) ? list.size() : failedAt;
                }
                catch (Throwable throwable) {
                    failedAt = this.arePreconditionsSetUpSucceed(failedAt) ? list.size() : failedAt;
                    for (int i = 0; i < failedAt; ++i) {
                        try {
                            Precondition precondition = list.get(i);
                            precondition.teardown();
                            continue;
                        }
                        catch (Exception e) {
                            possibleExceptions.add(e);
                        }
                    }
                    throw throwable;
                }
                for (int i = 0; i < failedAt; ++i) {
                    try {
                        Precondition precondition = list.get(i);
                        precondition.teardown();
                        continue;
                    }
                    catch (Exception e) {
                        possibleExceptions.add(e);
                    }
                }
                if (!possibleExceptions.isEmpty()) {
                    for (Exception e : possibleExceptions) {
                        notifier.fireTestFailure(new Failure(description, (Throwable)e));
                    }
                }
                break block18;
            }
            Description testDescription = Description.createTestDescription((Class)this.getTestClass().getJavaClass(), (String)method.getName());
            notifier.fireTestIgnored(testDescription);
        }
    }

    private boolean arePreconditionsSetUpSucceed(int failedAt) {
        return failedAt == -1;
    }

    private int invokeSetupForPreconditions(List<Precondition> list, List<Exception> possibleExceptions) {
        int failedAt = -1;
        int currentIndex = 0;
        for (Precondition precondition : list) {
            ++currentIndex;
            try {
                precondition.setup();
            }
            catch (Exception e) {
                possibleExceptions.add(e);
                failedAt = currentIndex;
                break;
            }
        }
        return failedAt;
    }

    private List<Precondition> createPrecondtions(Method method, Object test) {
        Class<? extends Precondition>[] classes;
        Class<?> declaringClass = method.getDeclaringClass();
        Field[] declaredFields = declaringClass.getDeclaredFields();
        Object context = null;
        for (Field declaredField : declaredFields) {
            if (!declaredField.isAnnotationPresent(Context.class)) continue;
            try {
                declaredField.setAccessible(true);
                context = declaredField.get(test);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        Preconditions preconditions = method.getAnnotation(Preconditions.class);
        ArrayList<Precondition> preconditionsAsList = new ArrayList<Precondition>();
        if (preconditions == null) {
            return preconditionsAsList;
        }
        for (Class<? extends Precondition> aClass : classes = preconditions.value()) {
            try {
                Precondition precondition;
                if (context != null) {
                    Constructor<? extends Precondition> constructor = aClass.getConstructor(Object.class);
                    precondition = constructor.newInstance(context);
                } else {
                    precondition = aClass.newInstance();
                }
                preconditionsAsList.add(precondition);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return preconditionsAsList;
    }

    public boolean isPrereuisitSatisfied(Method method) {
        RunIf resource = method.getAnnotation(RunIf.class);
        if (resource == null) {
            return true;
        }
        Class<? extends Checker> prerequisiteChecker = resource.value();
        try {
            Checker checker;
            String[] arguments = resource.arguments();
            if (this.isArgumentNotProvided(arguments)) {
                checker = prerequisiteChecker.newInstance();
            } else if (arguments.length == 1) {
                Constructor<? extends Checker> constructor = prerequisiteChecker.getConstructor(String.class);
                checker = constructor.newInstance(arguments[0]);
            } else {
                Constructor<? extends Checker> constructor = prerequisiteChecker.getConstructor(String[].class);
                checker = constructor.newInstance(new Object[]{arguments});
            }
            return checker.satisfy();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isArgumentNotProvided(String[] argument) {
        return argument == null || argument.length == 0;
    }

    public Object createTest(RunNotifier notifier, Description description) {
        Object test = null;
        try {
            try {
                test = this.createTest();
            }
            catch (InvocationTargetException e) {
                this.testAborted(notifier, description, e.getCause());
                return null;
            }
            catch (Exception e) {
                this.testAborted(notifier, description, e);
                return null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return test;
    }

    private void testAborted(RunNotifier notifier, Description description, Throwable e) {
        notifier.fireTestStarted(description);
        notifier.fireTestFailure(new Failure(description, e));
        notifier.fireTestFinished(description);
    }
}

