/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.util;

import edu.cmu.sphinx.util.Utilities;
import java.text.DecimalFormat;

public class Timer {
    private static final DecimalFormat timeFormatter = new DecimalFormat("###0.0000");
    private final String name;
    private double sum;
    private long count;
    private long startTime;
    private long curTime;
    private long minTime = Long.MAX_VALUE;
    private long maxTime;
    private boolean notReliable;

    Timer(String name) {
        assert (name != null) : "timers must have a name!";
        this.name = name;
        this.reset();
    }

    public String getName() {
        return this.name;
    }

    public void reset() {
        this.startTime = 0L;
        this.count = 0L;
        this.sum = 0.0;
        this.minTime = Long.MAX_VALUE;
        this.maxTime = 0L;
        this.notReliable = false;
    }

    public boolean isStarted() {
        return this.startTime > 0L;
    }

    public void start() {
        if (this.startTime != 0L) {
            this.notReliable = true;
            System.out.println(this.getName() + " timer.start() called without a stop()");
        }
        this.startTime = System.currentTimeMillis();
    }

    public void start(long time) {
        if (this.startTime != 0L) {
            this.notReliable = true;
            System.out.println(this.getName() + " timer.start() called without a stop()");
        }
        if (time > System.currentTimeMillis()) {
            throw new IllegalStateException("Start time is later than current time");
        }
        this.startTime = time;
    }

    public long stop(boolean verbose) {
        if (this.startTime == 0L) {
            this.notReliable = true;
            System.out.println(this.getName() + " timer.stop() called without a start()");
        }
        this.curTime = System.currentTimeMillis() - this.startTime;
        this.startTime = 0L;
        if (this.curTime > this.maxTime) {
            this.maxTime = this.curTime;
        }
        if (this.curTime < this.minTime) {
            this.minTime = this.curTime;
        }
        ++this.count;
        this.sum += (double)this.curTime;
        if (verbose) {
            this.dump();
        }
        return this.curTime;
    }

    public void stop() {
        this.stop(false);
    }

    public void dump() {
        this.showTimesShort();
    }

    public long getCount() {
        return this.count;
    }

    public long getCurTime() {
        return this.curTime;
    }

    public double getAverageTime() {
        if (this.count == 0L) {
            return 0.0;
        }
        return this.sum / (double)this.count;
    }

    public long getMinTime() {
        return this.minTime;
    }

    public long getMaxTime() {
        return this.maxTime;
    }

    private String fmtTime(long time) {
        return this.fmtTime((double)time / 1000.0);
    }

    private String fmtTime(double time) {
        return Utilities.pad(timeFormatter.format(time) + 's', 10);
    }

    private void showTimesShort() {
        double avgTime = 0.0;
        if (this.count == 0L) {
            return;
        }
        if (this.count > 0L) {
            avgTime = this.sum / (double)this.count / 1000.0;
        }
        if (this.notReliable) {
            System.out.print(Utilities.pad(this.name, 20) + ' ');
            System.out.println("Not reliable.");
        } else {
            System.out.print(Utilities.pad(this.name, 20) + ' ');
            System.out.print(Utilities.pad(String.valueOf(this.count), 8));
            System.out.print(this.fmtTime(this.curTime));
            System.out.print(this.fmtTime(this.minTime));
            System.out.print(this.fmtTime(this.maxTime));
            System.out.print(this.fmtTime(avgTime));
            System.out.print(this.fmtTime(this.sum / 1000.0));
            System.out.println();
        }
    }
}

