/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.result;

import edu.cmu.sphinx.result.ConfidenceResult;
import edu.cmu.sphinx.result.ConfusionSet;
import edu.cmu.sphinx.result.Path;
import edu.cmu.sphinx.result.SimpleWordResult;
import edu.cmu.sphinx.result.WordResult;
import edu.cmu.sphinx.result.WordResultPath;
import edu.cmu.sphinx.util.LogMath;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Sausage
implements ConfidenceResult {
    protected final List<ConfusionSet> confusionSets;

    public Sausage(int size) {
        this.confusionSets = new ArrayList<ConfusionSet>(size);
        for (int i = 0; i < size; ++i) {
            this.confusionSets.add(new ConfusionSet());
        }
    }

    @Override
    public Iterator<ConfusionSet> iterator() {
        return this.confusionSets.iterator();
    }

    public void fillInBlanks(LogMath logMath) {
        int index = 0;
        for (ConfusionSet set : this.confusionSets) {
            float sum = LogMath.getLogZero();
            for (Double val : set.keySet()) {
                sum = logMath.addAsLinear(sum, val.floatValue());
            }
            if (sum < LogMath.getLogOne() - 10.0f) {
                float remainder = logMath.subtractAsLinear(LogMath.getLogOne(), sum);
                this.addWordHypothesis(index, "<skip>", remainder, logMath);
            } else {
                ConfusionSet newSet = new ConfusionSet();
                for (Map.Entry entry : set.entrySet()) {
                    Double oldProb = (Double)entry.getKey();
                    Double newProb = oldProb - (double)sum;
                    newSet.put(newProb, entry.getValue());
                }
                this.confusionSets.set(index, newSet);
            }
            ++index;
        }
    }

    public void addWordHypothesis(int position, WordResult word) {
        this.getConfusionSet(position).addWordHypothesis(word);
    }

    public void addWordHypothesis(int position, String word, double confidence, LogMath logMath) {
        SimpleWordResult wr = new SimpleWordResult(word, confidence, logMath);
        this.addWordHypothesis(position, wr);
    }

    @Override
    public Path getBestHypothesis() {
        return this.getBestHypothesis(true);
    }

    public Path getBestHypothesisNoFiller() {
        return this.getBestHypothesis(false);
    }

    protected Path getBestHypothesis(boolean wantFiller) {
        WordResultPath path = new WordResultPath();
        for (ConfusionSet cs : this) {
            WordResult wr = cs.getBestHypothesis();
            if (!wantFiller && wr.isFiller()) continue;
            path.add(cs.getBestHypothesis());
        }
        return path;
    }

    public void removeFillers() {
        Iterator<ConfusionSet> c = this.iterator();
        while (c.hasNext()) {
            ConfusionSet cs = c.next();
            Iterator j = cs.values().iterator();
            while (j.hasNext()) {
                Set words = (Set)j.next();
                Iterator w = words.iterator();
                while (w.hasNext()) {
                    WordResult word = (WordResult)w.next();
                    if (!word.isFiller()) continue;
                    w.remove();
                }
                if (!words.isEmpty()) continue;
                j.remove();
            }
            if (!cs.isEmpty()) continue;
            c.remove();
        }
    }

    public String getBestHypothesisString() {
        return ((Object)this.getBestHypothesis()).toString();
    }

    public Set<WordResult> getBestWordHypothesis(int pos) {
        ConfusionSet set = this.confusionSets.get(pos);
        return (Set)set.get(set.lastKey());
    }

    public double getBestWordHypothesisPosterior(int pos) {
        return (Double)this.confusionSets.get(pos).lastKey();
    }

    @Override
    public ConfusionSet getConfusionSet(int pos) {
        return this.confusionSets.get(pos);
    }

    public int countWordHypotheses() {
        int count = 0;
        for (ConfusionSet cs : this) {
            for (Set words : cs.values()) {
                count += words.size();
            }
        }
        return count;
    }

    @Override
    public int size() {
        return this.confusionSets.size();
    }

    public void dumpAISee(String fileName, String title) {
        try {
            System.err.println("Dumping " + title + " to " + fileName);
            FileWriter f = new FileWriter(fileName);
            f.write("graph: {\n");
            f.write("title: \"" + title + "\"\n");
            f.write("display_edge_labels: yes\n");
            f.write("orientation: left_to_right\n");
            int index = 0;
            for (ConfusionSet set : this.confusionSets) {
                f.write("node: { title: \"" + index + "\" label: \"" + index + "\"}\n");
                for (Map.Entry entry : set.entrySet()) {
                    Double prob = (Double)entry.getKey();
                    StringBuilder edge = new StringBuilder();
                    edge.append("edge: { sourcename: \"").append(index).append("\" targetname: \"").append(index + 1).append("\" label: \"");
                    Set wordSet = (Set)entry.getValue();
                    for (WordResult wordResult : wordSet) {
                        edge.append(wordResult).append('/');
                    }
                    if (!wordSet.isEmpty()) {
                        edge.setLength(edge.length() - 1);
                    }
                    edge.append(':').append(prob).append("\" }\n");
                    f.write(edge.toString());
                }
                ++index;
            }
            f.write("node: { title: \"" + this.size() + "\" label: \"" + this.size() + "\"}\n");
            f.write("}\n");
            f.close();
        }
        catch (IOException e) {
            throw new Error(e.toString());
        }
    }
}

