/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.result;

import edu.cmu.sphinx.linguist.WordSequence;
import edu.cmu.sphinx.linguist.dictionary.Word;
import edu.cmu.sphinx.linguist.language.ngram.LanguageModel;
import edu.cmu.sphinx.result.Edge;
import edu.cmu.sphinx.result.Lattice;
import edu.cmu.sphinx.util.LogMath;
import java.util.LinkedList;
import java.util.List;

public class LatticeRescorer {
    protected final Lattice lattice;
    protected final LanguageModel model;
    private int depth;
    private float languageWeigth = 8.0f;

    public LatticeRescorer(Lattice lattice, LanguageModel model) {
        this.lattice = lattice;
        this.model = model;
        this.depth = model.getMaxDepth();
    }

    private void rescoreEdges() {
        for (Edge edge : this.lattice.edges) {
            if (this.lattice.isFillerNode(edge.getToNode())) continue;
            List<String> paths = this.allPathsTo("", edge, this.depth);
            float minProb = LogMath.getLogZero();
            for (String path : paths) {
                LinkedList<Word> wordList = new LinkedList<Word>();
                for (String pathWord : path.split(" ")) {
                    wordList.add(new Word(pathWord, null, false));
                }
                wordList.add(edge.getToNode().getWord());
                WordSequence seq = new WordSequence(wordList);
                float prob = this.model.getProbability(seq) * this.languageWeigth;
                if (!(minProb < prob)) continue;
                minProb = prob;
            }
            edge.setLMScore(minProb);
        }
    }

    protected List<String> allPathsTo(String path, Edge edge, int currentDepth) {
        LinkedList<String> l = new LinkedList<String>();
        String p = edge.getFromNode().getWord().toString() + ' ' + path;
        if (currentDepth == 2 || edge.getFromNode().equals(this.lattice.getInitialNode())) {
            l.add(p);
        } else {
            for (Edge e : edge.getFromNode().getEnteringEdges()) {
                l.addAll(this.allPathsTo(p, e, currentDepth - 1));
            }
        }
        return l;
    }

    public void rescore() {
        this.lattice.removeFillers();
        this.rescoreEdges();
    }
}

