/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.result;

import edu.cmu.sphinx.result.WordResult;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class ConfusionSet
extends TreeMap<Double, Set<WordResult>> {
    public void addWordHypothesis(WordResult word) {
        Set<WordResult> wordSet = this.getWordSet(word.getConfidence());
        if (wordSet == null) {
            wordSet = new HashSet<WordResult>();
            this.put(word.getConfidence(), wordSet);
        }
        wordSet.add(word);
    }

    public Set<WordResult> getWordSet(double posterior) {
        return (Set)this.get(new Double(posterior));
    }

    public Set<WordResult> getBestHypothesisSet() {
        return (Set)this.get(this.lastKey());
    }

    public WordResult getBestHypothesis() {
        Set<WordResult> s = this.getBestHypothesisSet();
        return s.iterator().next();
    }

    public double getBestPosterior() {
        return (Double)this.lastKey();
    }

    public boolean containsWord(String word) {
        return this.getWordResult(word) != null;
    }

    public boolean containsFiller() {
        for (Set wordSet : this.values()) {
            for (WordResult wordResult : wordSet) {
                if (!wordResult.isFiller()) continue;
                return true;
            }
        }
        return false;
    }

    public WordResult getWordResult(String word) {
        for (Set wordSet : this.values()) {
            for (WordResult wordResult : wordSet) {
                String resultSpelling = ((Object)wordResult).toString();
                if (!resultSpelling.equals(word)) continue;
                return wordResult;
            }
        }
        return null;
    }

    public void dump(String name) {
        System.out.print(name + " :");
        for (Set wordSet : this.values()) {
            for (WordResult wordResult : wordSet) {
                System.out.print(' ' + wordResult.getPronunciation().getWord().getSpelling());
            }
        }
        System.out.println();
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        for (Map.Entry entry : this.entrySet()) {
            b.append(entry.getKey()).append(':');
            for (WordResult wordResult : (Set)entry.getValue()) {
                b.append(wordResult).append(',');
            }
            if (!((Set)entry.getValue()).isEmpty()) {
                b.setLength(b.length() - 1);
            }
            b.append(' ');
        }
        return b.toString();
    }
}

