/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.research.parallel;

import edu.cmu.sphinx.decoder.pruner.Pruner;
import edu.cmu.sphinx.decoder.search.ActiveList;
import edu.cmu.sphinx.decoder.search.ActiveListFactory;
import edu.cmu.sphinx.decoder.search.Token;
import edu.cmu.sphinx.util.LogMath;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Component;
import edu.cmu.sphinx.util.props.S4Integer;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public abstract class TokenScorePruner
implements Pruner {
    @S4Integer(defaultValue=2000)
    public static final String PROP_ABSOLUTE_BEAM_WIDTH = "absoluteBeamWidth";
    @S4Integer(defaultValue=0)
    public static final String PROP_RELATIVE_BEAM_WIDTH = "relativeBeamWidth";
    @S4Component(type=LogMath.class)
    public static final String PROP_LOG_MATH = "logMath";
    public static final String PROP_ACTIVE_LIST_FACTORY = "activeListFactory";
    private String name;
    private int absoluteBeamWidth;
    private float relativeBeamWidth;
    private boolean doRelativePruning;
    private LogMath logMath;
    private ActiveListFactory activeListFactory;
    private static Comparator<Token> tokenComparator;

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        this.logMath = (LogMath)ps.getComponent(PROP_LOG_MATH);
        this.setAbsoluteBeamWidth(ps.getInt(PROP_ABSOLUTE_BEAM_WIDTH));
        double linearRelativeBeamWidth = ps.getDouble(PROP_RELATIVE_BEAM_WIDTH);
        this.setRelativeBeamWidth(this.logMath.linearToLog(linearRelativeBeamWidth));
        this.activeListFactory = (ActiveListFactory)ps.getComponent(PROP_ACTIVE_LIST_FACTORY);
    }

    protected abstract float getTokenScore(Token var1);

    protected Comparator<Token> getTokenComparator() {
        if (tokenComparator == null) {
            tokenComparator = new Comparator<Token>(){

                @Override
                public int compare(Token t1, Token t2) {
                    if (TokenScorePruner.this.getTokenScore(t1) > TokenScorePruner.this.getTokenScore(t2)) {
                        return -1;
                    }
                    if (TokenScorePruner.this.getTokenScore(t1) == TokenScorePruner.this.getTokenScore(t2)) {
                        return 0;
                    }
                    return 1;
                }
            };
        }
        return tokenComparator;
    }

    @Override
    public ActiveList prune(ActiveList activeList) {
        ActiveList newList = this.activeListFactory.newInstance();
        List<Token> tokenList = activeList.getTokens();
        Collections.sort(tokenList, this.getTokenComparator());
        if (!tokenList.isEmpty()) {
            Token bestToken = tokenList.get(0);
            float highestScore = this.getTokenScore(bestToken);
            float pruneScore = highestScore + this.relativeBeamWidth;
            float thisScore = highestScore;
            Iterator<Token> i = tokenList.iterator();
            while (i.hasNext() && newList.size() < this.absoluteBeamWidth) {
                Token token = i.next();
                thisScore = this.getTokenScore(token);
                if (this.doRelativePruning) {
                    if (!(thisScore > pruneScore)) break;
                    newList.add(token);
                    continue;
                }
                newList.add(token);
            }
        }
        return newList;
    }

    public int getAbsoluteBeamWidth() {
        return this.absoluteBeamWidth;
    }

    public void setAbsoluteBeamWidth(int absoluteBeamWidth) {
        this.absoluteBeamWidth = absoluteBeamWidth;
    }

    public float getRelativeBeamWidth() {
        return this.relativeBeamWidth;
    }

    public void setRelativeBeamWidth(float relativeBeamWidth) {
        this.relativeBeamWidth = relativeBeamWidth;
    }

    @Override
    public void startRecognition() {
    }

    @Override
    public void stopRecognition() {
    }

    @Override
    public void allocate() {
    }

    @Override
    public void deallocate() {
    }

    public String getName() {
        return this.name;
    }
}

