/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.research.parallel;

import edu.cmu.sphinx.decoder.pruner.Pruner;
import edu.cmu.sphinx.decoder.scorer.AcousticScorer;
import edu.cmu.sphinx.decoder.scorer.Scoreable;
import edu.cmu.sphinx.decoder.search.ActiveList;
import edu.cmu.sphinx.decoder.search.ActiveListFactory;
import edu.cmu.sphinx.decoder.search.SearchManager;
import edu.cmu.sphinx.decoder.search.Token;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.linguist.Linguist;
import edu.cmu.sphinx.linguist.SearchState;
import edu.cmu.sphinx.linguist.SearchStateArc;
import edu.cmu.sphinx.linguist.flat.SentenceHMMState;
import edu.cmu.sphinx.linguist.flat.SentenceHMMStateArc;
import edu.cmu.sphinx.research.parallel.CombineToken;
import edu.cmu.sphinx.research.parallel.FeatureScoreCombiner;
import edu.cmu.sphinx.research.parallel.FeatureScorePruner;
import edu.cmu.sphinx.research.parallel.FeatureStream;
import edu.cmu.sphinx.research.parallel.ParallelSimpleLinguist;
import edu.cmu.sphinx.research.parallel.ParallelState;
import edu.cmu.sphinx.research.parallel.ParallelToken;
import edu.cmu.sphinx.result.Result;
import edu.cmu.sphinx.util.LogMath;
import edu.cmu.sphinx.util.Timer;
import edu.cmu.sphinx.util.TimerPool;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4Component;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ParallelSearchManager
implements SearchManager {
    @S4Component(type=ActiveListFactory.class)
    public static final String PROP_ACTIVE_LIST_FACTORY = "activeListFactory";
    @S4Boolean(defaultValue=false)
    public static final String PROP_DO_FEATURE_PRUNING = "doFeaturePruning";
    @S4Component(type=FeatureScorePruner.class)
    public static final String PROP_FEATURE_SCORE_PRUNER = "featureScorePruner";
    @S4Boolean(defaultValue=false)
    public static final String PROP_DO_COMBINE_PRUNING = "doCombinePruning";
    @S4Component(type=AcousticScorer.class)
    public static final String PROP_SCORER = "scorer";
    @S4Component(type=Linguist.class)
    public static final String PROP_LINGUIST = "linguist";
    @S4Component(type=LogMath.class)
    public static final String PROP_LOG_MATH = "logMath";
    private ParallelSimpleLinguist linguist;
    private AcousticScorer scorer;
    private Pruner featureScorePruner;
    private Pruner combinedScorePruner;
    private LogMath logMath;
    private int currentFrameNumber;
    private ActiveListFactory activeListFactory;
    private ActiveList combinedActiveList;
    private ActiveList delayedExpansionList;
    private List<Token> resultList;
    private Map<SearchState, Token> bestTokenMap;
    private Timer scoreTimer;
    private Timer pruneTimer;
    private Timer growTimer;
    private boolean doFeaturePruning;
    private boolean doCombinePruning;

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        this.logMath = (LogMath)ps.getComponent(PROP_LOG_MATH);
        this.linguist = (ParallelSimpleLinguist)ps.getComponent(PROP_LINGUIST);
        this.scorer = (AcousticScorer)ps.getComponent(PROP_SCORER);
        this.activeListFactory = (ActiveListFactory)ps.getComponent(PROP_ACTIVE_LIST_FACTORY);
        this.doFeaturePruning = ps.getBoolean(PROP_DO_FEATURE_PRUNING);
        this.doCombinePruning = ps.getBoolean(PROP_DO_COMBINE_PRUNING);
        if (this.doFeaturePruning) {
            this.featureScorePruner = (FeatureScorePruner)ps.getComponent(PROP_FEATURE_SCORE_PRUNER);
        }
        this.scoreTimer = TimerPool.getTimer(this, "Score");
        this.pruneTimer = TimerPool.getTimer(this, "Prune");
        this.growTimer = TimerPool.getTimer(this, "Grow");
    }

    @Override
    public void allocate() {
        this.bestTokenMap = new HashMap<SearchState, Token>();
        try {
            this.linguist.allocate();
            if (this.doFeaturePruning) {
                this.featureScorePruner.allocate();
            }
            if (this.doCombinePruning) {
                this.combinedScorePruner.allocate();
            }
            this.scorer.allocate();
        }
        catch (IOException e) {
            throw new RuntimeException(this.toString() + ": allocation of search manager resources failed", e);
        }
    }

    private void debugPrint(String message) {
    }

    @Override
    public void startRecognition() {
        this.currentFrameNumber = 0;
        this.linguist.startRecognition();
        if (this.doFeaturePruning) {
            this.featureScorePruner.startRecognition();
        }
        if (this.doCombinePruning) {
            this.combinedScorePruner.startRecognition();
        }
        this.scorer.startRecognition();
        this.createInitialLists();
    }

    private void createInitialLists() {
        this.combinedActiveList = this.activeListFactory.newInstance();
        this.delayedExpansionList = this.activeListFactory.newInstance();
        SentenceHMMState firstState = (SentenceHMMState)this.linguist.getSearchGraph().getInitialState();
        CombineToken firstToken = new CombineToken(null, firstState, this.currentFrameNumber);
        this.setBestToken(firstState, firstToken);
        Iterator<FeatureStream> i = this.linguist.getFeatureStreams();
        while (i.hasNext()) {
            FeatureStream stream = i.next();
            stream.setActiveList(this.activeListFactory.newInstance());
            ParallelToken token = new ParallelToken(firstState, stream, this.currentFrameNumber);
            token.setLastCombineTime(this.currentFrameNumber);
            firstToken.addParallelToken(stream, token);
        }
        this.resultList = new LinkedList<Token>();
        this.calculateCombinedScore(firstToken);
        this.growCombineToken(firstToken);
    }

    @Override
    public Result recognize(int nFrames) {
        boolean done = false;
        for (int i = 0; i < nFrames && !done; ++i) {
            done = this.recognize();
        }
        return new Result(this.combinedActiveList, this.resultList, this.currentFrameNumber, done, this.logMath);
    }

    private boolean recognize() {
        this.debugPrint("-----\nFrame: " + this.currentFrameNumber);
        boolean moreTokens = this.score();
        if (moreTokens) {
            this.prune();
            this.grow();
            ++this.currentFrameNumber;
        }
        this.debugPrint("-----");
        return !moreTokens;
    }

    private boolean score() {
        this.scoreTimer.start();
        this.debugPrint("Scoring");
        boolean moreFeatures = false;
        Iterator<FeatureStream> i = this.linguist.getFeatureStreams();
        while (i.hasNext()) {
            FeatureStream stream = i.next();
            Data data = this.scorer.calculateScores(stream.getActiveList().getTokens());
            Scoreable scoreable = null;
            if (data instanceof Scoreable) {
                scoreable = (Scoreable)data;
            }
            moreFeatures = scoreable != null;
        }
        this.debugPrint(" done Scoring");
        this.scoreTimer.stop();
        return moreFeatures;
    }

    private void prune() {
        this.pruneTimer.start();
        this.debugPrint("Pruning");
        if (this.doFeaturePruning) {
            Iterator<FeatureStream> i = this.linguist.getFeatureStreams();
            while (i.hasNext()) {
                FeatureStream stream = i.next();
                stream.setActiveList(this.featureScorePruner.prune(stream.getActiveList()));
            }
        }
        this.debugPrint(" done Pruning");
        this.pruneTimer.stop();
    }

    private void printActiveLists() {
        this.debugPrint(" CombinedActiveList: " + this.combinedActiveList.size());
        Iterator<FeatureStream> i = this.linguist.getFeatureStreams();
        while (i.hasNext()) {
            FeatureStream stream = i.next();
            this.debugPrint(" ActiveList, " + stream.getName() + ": " + stream.getActiveList().size());
        }
    }

    private void grow() {
        FeatureStream stream;
        this.growTimer.start();
        this.debugPrint("Growing");
        this.resultList = new LinkedList<Token>();
        this.combinedActiveList = this.activeListFactory.newInstance();
        this.delayedExpansionList = this.activeListFactory.newInstance();
        Iterator<FeatureStream> i = this.linguist.getFeatureStreams();
        while (i.hasNext()) {
            stream = i.next();
            ActiveList oldActiveList = stream.getActiveList();
            stream.setActiveList(this.activeListFactory.newInstance());
            this.growActiveList(oldActiveList);
        }
        this.growDelayedExpansionList();
        i = this.linguist.getFeatureStreams();
        while (i.hasNext()) {
            stream = i.next();
            ActiveList prunedActiveList = this.activeListFactory.newInstance();
            for (Token t : stream.getActiveList()) {
                ParallelToken token = (ParallelToken)t;
                if (token.isPruned()) continue;
                prunedActiveList.add(token);
            }
            stream.setActiveList(prunedActiveList);
        }
        this.debugPrint(" done Growing");
        this.growTimer.stop();
    }

    private void growDelayedExpansionList() {
        CombineToken token;
        for (Token t : this.delayedExpansionList) {
            token = (CombineToken)t;
            this.calculateCombinedScore(token);
        }
        if (this.doCombinePruning) {
            this.delayedExpansionList = this.combinedScorePruner.prune(this.delayedExpansionList);
        }
        for (Token t : this.delayedExpansionList) {
            token = (CombineToken)t;
            token.setLastCombineTime(this.currentFrameNumber);
            this.growCombineToken(token);
        }
    }

    private void calculateCombinedScore(CombineToken token) {
        new FeatureScoreCombiner().combineScore(token);
    }

    private void growActiveList(ActiveList activeList) {
        for (Token t : activeList) {
            ParallelToken token = (ParallelToken)t;
            this.growParallelToken(token);
        }
    }

    private void growParallelToken(ParallelToken token) {
        SearchStateArc[] arcs;
        assert (!token.isFinal());
        int nextFrameNumber = token.getFrameNumber();
        if (token.isEmitting()) {
            ++nextFrameNumber;
        }
        SentenceHMMState state = (SentenceHMMState)token.getSearchState();
        for (SearchStateArc arc : arcs = state.getSuccessors()) {
            boolean firstToken;
            SentenceHMMState nextState = (SentenceHMMState)arc.getState();
            float logEntryScore = token.getScore() + arc.getProbability();
            Token oldNextToken = this.getBestToken(nextState);
            boolean bl = firstToken = oldNextToken == null || oldNextToken.getFrameNumber() != nextFrameNumber;
            if (nextState.getColor() == SentenceHMMState.Color.RED) {
                CombineToken nextToken;
                if (firstToken) {
                    nextToken = new CombineToken(token, nextState, nextFrameNumber);
                    this.setBestToken(nextState, nextToken);
                    this.delayedExpansionList.add(nextToken);
                } else {
                    nextToken = (CombineToken)this.getBestToken(nextState);
                }
                assert (nextToken.getFrameNumber() == nextFrameNumber);
                ParallelToken oldParallelToken = nextToken.getParallelToken(token.getFeatureStream());
                if (!firstToken && oldParallelToken != null && !(oldParallelToken.getScore() <= logEntryScore)) continue;
                ParallelToken newToken = new ParallelToken(token, nextState, logEntryScore, token.getCombinedScore(), nextFrameNumber, token.getLastCombineTime());
                nextToken.addParallelToken(newToken.getFeatureStream(), newToken);
                continue;
            }
            if (nextState.getColor() == SentenceHMMState.Color.GREEN) {
                if (!firstToken && !(this.getBestToken(nextState).getScore() <= logEntryScore)) continue;
                ParallelToken newToken = new ParallelToken(token, nextState, logEntryScore, token.getCombinedScore(), nextFrameNumber, token.getLastCombineTime());
                if (newToken.isEmitting()) {
                    this.replaceParallelToken(nextState, newToken);
                    this.combinedActiveList.add(newToken);
                    continue;
                }
                this.growParallelToken(newToken);
                continue;
            }
            throw new IllegalStateException("Color of state " + nextState.getName() + " not RED or GREEN, its " + (Object)((Object)nextState.getColor()) + '!');
        }
    }

    private Token getBestToken(SearchState state) {
        return this.bestTokenMap.get(state);
    }

    private Token setBestToken(SearchState state, Token token) {
        return this.bestTokenMap.put(state, token);
    }

    private void growCombineToken(CombineToken token) {
        SearchStateArc[] arcs;
        if (token.isFinal()) {
            this.resultList.add(token);
        }
        int nextFrameNumber = token.getFrameNumber();
        assert (!token.isEmitting());
        SearchState state = token.getSearchState();
        for (SearchStateArc stateArc : arcs = state.getSuccessors()) {
            boolean firstToken;
            SentenceHMMStateArc arc = (SentenceHMMStateArc)stateArc;
            SentenceHMMState nextState = (SentenceHMMState)arc.getState();
            Token oldNextToken = this.getBestToken(nextState);
            boolean bl = firstToken = oldNextToken == null || oldNextToken.getFrameNumber() != nextFrameNumber;
            if (nextState.getColor() == SentenceHMMState.Color.RED) {
                float logEntryScore = token.getScore() + arc.getProbability();
                if (!firstToken && !(oldNextToken.getScore() <= logEntryScore)) continue;
                CombineToken nextToken = new CombineToken(token, nextState, nextFrameNumber);
                nextToken.setScore(logEntryScore);
                this.transitionParallelTokens(token, nextToken, arc.getProbability());
                this.setBestToken(nextState, nextToken);
                this.growCombineToken(nextToken);
                continue;
            }
            if (nextState.getColor() == SentenceHMMState.Color.GREEN) {
                ParallelState pState = (ParallelState)((Object)nextState);
                ParallelToken parallelToken = token.getParallelToken(pState.getFeatureStream());
                if (parallelToken == null) continue;
                float logEntryScore = arc.getProbability() + parallelToken.getFeatureScore();
                ParallelToken oldToken = (ParallelToken)oldNextToken;
                if (!firstToken && !(oldToken.getFeatureScore() <= logEntryScore)) continue;
                ParallelToken nextToken = new ParallelToken(parallelToken, nextState, logEntryScore, parallelToken.getCombinedScore(), nextFrameNumber, parallelToken.getLastCombineTime());
                if (nextState.isEmitting()) {
                    this.replaceParallelToken(nextState, nextToken);
                    this.combinedActiveList.add(nextToken);
                    continue;
                }
                this.growParallelToken(nextToken);
                continue;
            }
            throw new IllegalStateException("Color of state not RED or GREEN!");
        }
    }

    private void transitionParallelTokens(CombineToken oldToken, CombineToken newToken, float transitionScore) {
        for (ParallelToken pToken : oldToken) {
            ParallelToken newParallelToken = new ParallelToken(pToken, (SentenceHMMState)newToken.getSearchState(), pToken.getFeatureScore() + transitionScore, pToken.getCombinedScore(), pToken.getFrameNumber(), pToken.getLastCombineTime());
            newToken.addParallelToken(newParallelToken.getFeatureStream(), newParallelToken);
        }
    }

    private void replaceParallelToken(SentenceHMMState state, ParallelToken newToken) {
        ParallelToken oldToken = (ParallelToken)this.setBestToken(state, newToken);
        ActiveList activeList = newToken.getFeatureStream().getActiveList();
        activeList.add(newToken);
        if (oldToken != null) {
            oldToken.setPruned(true);
        }
    }

    @Override
    public void stopRecognition() {
        this.scorer.stopRecognition();
        if (this.doFeaturePruning) {
            this.featureScorePruner.stopRecognition();
        }
        if (this.doCombinePruning) {
            this.combinedScorePruner.stopRecognition();
        }
        this.linguist.stopRecognition();
        this.bestTokenMap = new HashMap<SearchState, Token>();
    }

    @Override
    public void deallocate() {
        this.scorer.deallocate();
        if (this.doFeaturePruning) {
            this.featureScorePruner.deallocate();
        }
        if (this.doCombinePruning) {
            this.combinedScorePruner.deallocate();
        }
        this.linguist.deallocate();
    }
}

