/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.recognizer;

import edu.cmu.sphinx.decoder.Decoder;
import edu.cmu.sphinx.decoder.ResultListener;
import edu.cmu.sphinx.decoder.ResultProducer;
import edu.cmu.sphinx.instrumentation.Monitor;
import edu.cmu.sphinx.instrumentation.Resetable;
import edu.cmu.sphinx.recognizer.StateListener;
import edu.cmu.sphinx.result.Result;
import edu.cmu.sphinx.util.props.Configurable;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Component;
import edu.cmu.sphinx.util.props.S4ComponentList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Recognizer
implements Configurable,
ResultProducer {
    @S4Component(type=Decoder.class)
    public static final String PROP_DECODER = "decoder";
    @S4ComponentList(type=Monitor.class)
    public static final String PROP_MONITORS = "monitors";
    private String name;
    private Decoder decoder;
    private State currentState = State.DEALLOCATED;
    private final List<StateListener> stateListeners = Collections.synchronizedList(new ArrayList());
    private List<Monitor> monitors;

    public Recognizer(Decoder decoder, List<Monitor> monitors) {
        this.decoder = decoder;
        this.monitors = monitors;
        this.name = null;
    }

    public Recognizer() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        this.decoder = (Decoder)ps.getComponent(PROP_DECODER);
        this.monitors = ps.getComponentList(PROP_MONITORS, Monitor.class);
        this.name = ps.getInstanceName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result recognize(String referenceText) throws IllegalStateException {
        Result result = null;
        this.checkState(State.READY);
        try {
            this.setState(State.RECOGNIZING);
            result = this.decoder.decode(referenceText);
        }
        finally {
            this.setState(State.READY);
        }
        return result;
    }

    public Result recognize() throws IllegalStateException {
        return this.recognize(null);
    }

    private void checkState(State desiredState) {
        if (this.currentState != desiredState) {
            throw new IllegalStateException("Expected state " + (Object)((Object)desiredState) + " actual state " + (Object)((Object)this.currentState));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(State newState) {
        this.currentState = newState;
        List<StateListener> list = this.stateListeners;
        synchronized (list) {
            for (StateListener sl : this.stateListeners) {
                sl.statusChanged(this.currentState);
            }
        }
    }

    public void allocate() throws IllegalStateException {
        this.checkState(State.DEALLOCATED);
        this.setState(State.ALLOCATING);
        this.decoder.allocate();
        this.setState(State.ALLOCATED);
        this.setState(State.READY);
    }

    public void deallocate() throws IllegalStateException {
        this.checkState(State.READY);
        this.setState(State.DEALLOCATING);
        this.decoder.deallocate();
        this.setState(State.DEALLOCATED);
    }

    public State getState() {
        return this.currentState;
    }

    public void resetMonitors() {
        for (Monitor listener : this.monitors) {
            if (!(listener instanceof Resetable)) continue;
            ((Resetable)((Object)listener)).reset();
        }
    }

    @Override
    public void addResultListener(ResultListener resultListener) {
        this.decoder.addResultListener(resultListener);
    }

    public void addStateListener(StateListener stateListener) {
        this.stateListeners.add(stateListener);
    }

    @Override
    public void removeResultListener(ResultListener resultListener) {
        this.decoder.removeResultListener(resultListener);
    }

    public void removeStateListener(StateListener stateListener) {
        this.stateListeners.remove(stateListener);
    }

    public String toString() {
        return "Recognizer: " + this.name + " State: " + (Object)((Object)this.currentState);
    }

    public static enum State {
        DEALLOCATED,
        ALLOCATING,
        ALLOCATED,
        READY,
        RECOGNIZING,
        DEALLOCATING,
        ERROR;

    }
}

