/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.lextree;

import edu.cmu.sphinx.decoder.scorer.ScoreProvider;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.linguist.HMMSearchState;
import edu.cmu.sphinx.linguist.Linguist;
import edu.cmu.sphinx.linguist.SearchGraph;
import edu.cmu.sphinx.linguist.SearchState;
import edu.cmu.sphinx.linguist.SearchStateArc;
import edu.cmu.sphinx.linguist.UnitSearchState;
import edu.cmu.sphinx.linguist.WordSearchState;
import edu.cmu.sphinx.linguist.WordSequence;
import edu.cmu.sphinx.linguist.acoustic.AcousticModel;
import edu.cmu.sphinx.linguist.acoustic.HMM;
import edu.cmu.sphinx.linguist.acoustic.HMMPool;
import edu.cmu.sphinx.linguist.acoustic.HMMState;
import edu.cmu.sphinx.linguist.acoustic.HMMStateArc;
import edu.cmu.sphinx.linguist.acoustic.Unit;
import edu.cmu.sphinx.linguist.acoustic.UnitManager;
import edu.cmu.sphinx.linguist.dictionary.Dictionary;
import edu.cmu.sphinx.linguist.dictionary.Pronunciation;
import edu.cmu.sphinx.linguist.dictionary.Word;
import edu.cmu.sphinx.linguist.language.grammar.Grammar;
import edu.cmu.sphinx.linguist.language.ngram.BackoffLanguageModel;
import edu.cmu.sphinx.linguist.language.ngram.LanguageModel;
import edu.cmu.sphinx.linguist.language.ngram.ProbDepth;
import edu.cmu.sphinx.linguist.lextree.EndNode;
import edu.cmu.sphinx.linguist.lextree.HMMNode;
import edu.cmu.sphinx.linguist.lextree.HMMTree;
import edu.cmu.sphinx.linguist.lextree.InitialWordNode;
import edu.cmu.sphinx.linguist.lextree.Node;
import edu.cmu.sphinx.linguist.lextree.UnitNode;
import edu.cmu.sphinx.linguist.lextree.WordNode;
import edu.cmu.sphinx.linguist.util.LRUCache;
import edu.cmu.sphinx.util.LogMath;
import edu.cmu.sphinx.util.TimerPool;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4Component;
import edu.cmu.sphinx.util.props.S4Double;
import edu.cmu.sphinx.util.props.S4Integer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;

public class LexTreeLinguist
implements Linguist {
    @S4Component(type=Grammar.class)
    public static final String PROP_GRAMMAR = "grammar";
    @S4Component(type=AcousticModel.class)
    public static final String PROP_ACOUSTIC_MODEL = "acousticModel";
    @S4Component(type=UnitManager.class, defaultClass=UnitManager.class)
    public static final String PROP_UNIT_MANAGER = "unitManager";
    @S4Component(type=LogMath.class)
    public static final String PROP_LOG_MATH = "logMath";
    @S4Boolean(defaultValue=true)
    public static final String PROP_FULL_WORD_HISTORIES = "fullWordHistories";
    @S4Component(type=BackoffLanguageModel.class)
    public static final String PROP_LANGUAGE_MODEL = "languageModel";
    @S4Component(type=Dictionary.class)
    public static final String PROP_DICTIONARY = "dictionary";
    @S4Integer(defaultValue=0)
    public static final String PROP_CACHE_SIZE = "cacheSize";
    @S4Boolean(defaultValue=false)
    public static final String PROP_ADD_FILLER_WORDS = "addFillerWords";
    @S4Boolean(defaultValue=false)
    public static final String PROP_GENERATE_UNIT_STATES = "generateUnitStates";
    @S4Boolean(defaultValue=true)
    public static final String PROP_WANT_UNIGRAM_SMEAR = "wantUnigramSmear";
    @S4Double(defaultValue=1.0)
    public static final String PROP_UNIGRAM_SMEAR_WEIGHT = "unigramSmearWeight";
    private static final SearchStateArc[] EMPTY_ARC = new SearchStateArc[0];
    private BackoffLanguageModel languageModel;
    private AcousticModel acousticModel;
    private LogMath logMath;
    private Dictionary dictionary;
    private UnitManager unitManager;
    private Logger logger;
    private boolean fullWordHistories = true;
    protected boolean addFillerWords;
    private boolean generateUnitStates;
    private boolean wantUnigramSmear = true;
    private float unigramSmearWeight = 1.0f;
    private boolean cacheEnabled;
    private int maxArcCacheSize;
    protected float languageWeight;
    private float logWordInsertionProbability;
    private float logUnitInsertionProbability;
    private float logFillerInsertionProbability;
    private float logSilenceInsertionProbability;
    private float logOne;
    private Word sentenceEndWord;
    private Word[] sentenceStartWordArray;
    private SearchGraph searchGraph;
    private HMMPool hmmPool;
    private LRUCache<LexTreeState, SearchStateArc[]> arcCache;
    private int maxDepth;
    protected HMMTree hmmTree;
    private int cacheTrys;
    private int cacheHits;

    public LexTreeLinguist(AcousticModel acousticModel, LogMath logMath, UnitManager unitManager, BackoffLanguageModel languageModel, Dictionary dictionary, boolean fullWordHistories, boolean wantUnigramSmear, double wordInsertionProbability, double silenceInsertionProbability, double fillerInsertionProbability, double unitInsertionProbability, float languageWeight, boolean addFillerWords, boolean generateUnitStates, float unigramSmearWeight, int maxArcCacheSize) {
        this.logger = Logger.getLogger(this.getClass().getName());
        this.acousticModel = acousticModel;
        this.logMath = logMath;
        this.unitManager = unitManager;
        this.languageModel = languageModel;
        this.dictionary = dictionary;
        this.fullWordHistories = fullWordHistories;
        this.wantUnigramSmear = wantUnigramSmear;
        this.logWordInsertionProbability = logMath.linearToLog(wordInsertionProbability);
        this.logSilenceInsertionProbability = logMath.linearToLog(silenceInsertionProbability);
        this.logFillerInsertionProbability = logMath.linearToLog(fillerInsertionProbability);
        this.logUnitInsertionProbability = logMath.linearToLog(unitInsertionProbability);
        this.languageWeight = languageWeight;
        this.addFillerWords = addFillerWords;
        this.generateUnitStates = generateUnitStates;
        this.unigramSmearWeight = unigramSmearWeight;
        this.maxArcCacheSize = maxArcCacheSize;
        boolean bl = this.cacheEnabled = maxArcCacheSize > 0;
        if (this.cacheEnabled) {
            this.arcCache = new LRUCache(maxArcCacheSize);
        }
    }

    public LexTreeLinguist() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        this.logger = ps.getLogger();
        this.acousticModel = (AcousticModel)ps.getComponent(PROP_ACOUSTIC_MODEL);
        this.logMath = (LogMath)ps.getComponent(PROP_LOG_MATH);
        this.unitManager = (UnitManager)ps.getComponent(PROP_UNIT_MANAGER);
        this.languageModel = (BackoffLanguageModel)ps.getComponent(PROP_LANGUAGE_MODEL);
        this.dictionary = (Dictionary)ps.getComponent(PROP_DICTIONARY);
        this.fullWordHistories = ps.getBoolean(PROP_FULL_WORD_HISTORIES);
        this.wantUnigramSmear = ps.getBoolean(PROP_WANT_UNIGRAM_SMEAR);
        this.logWordInsertionProbability = this.logMath.linearToLog(ps.getDouble("wordInsertionProbability"));
        this.logSilenceInsertionProbability = this.logMath.linearToLog(ps.getDouble("silenceInsertionProbability"));
        this.logFillerInsertionProbability = this.logMath.linearToLog(ps.getDouble("fillerInsertionProbability"));
        this.logUnitInsertionProbability = this.logMath.linearToLog(ps.getDouble("unitInsertionProbability"));
        this.languageWeight = ps.getFloat("languageWeight");
        this.addFillerWords = ps.getBoolean(PROP_ADD_FILLER_WORDS);
        this.generateUnitStates = ps.getBoolean(PROP_GENERATE_UNIT_STATES);
        this.unigramSmearWeight = ps.getFloat(PROP_UNIGRAM_SMEAR_WEIGHT);
        this.maxArcCacheSize = ps.getInt(PROP_CACHE_SIZE);
        boolean bl = this.cacheEnabled = this.maxArcCacheSize > 0;
        if (this.cacheEnabled) {
            this.arcCache = new LRUCache(this.maxArcCacheSize);
        }
    }

    @Override
    public void allocate() throws IOException {
        this.dictionary.allocate();
        this.acousticModel.allocate();
        this.languageModel.allocate();
        this.compileGrammar();
    }

    @Override
    public void deallocate() throws IOException {
        if (this.acousticModel != null) {
            this.acousticModel.deallocate();
        }
        if (this.dictionary != null) {
            this.dictionary.deallocate();
        }
        if (this.languageModel != null) {
            this.languageModel.deallocate();
        }
        this.hmmTree = null;
    }

    @Override
    public SearchGraph getSearchGraph() {
        return this.searchGraph;
    }

    @Override
    public void startRecognition() {
        this.languageModel.start();
    }

    @Override
    public void stopRecognition() {
        this.languageModel.stop();
    }

    public LanguageModel getLanguageModel() {
        return this.languageModel;
    }

    public Dictionary getDictionary() {
        return this.dictionary;
    }

    private SearchState getInitialSearchState() {
        InitialWordNode node = this.hmmTree.getInitialNode();
        if (node == null) {
            throw new RuntimeException("Language model has no entry for initial word <s>");
        }
        return new LexTreeWordState(node, node.getParent(), new WordSequence(this.sentenceStartWordArray).trim(this.maxDepth - 1), 0.0f, this.logOne, this.logOne, false);
    }

    private void compileGrammar() {
        TimerPool.getTimer(this, "Compile").start();
        this.sentenceEndWord = this.dictionary.getSentenceEndWord();
        this.sentenceStartWordArray = new Word[1];
        this.sentenceStartWordArray[0] = this.dictionary.getSentenceStartWord();
        this.maxDepth = this.languageModel.getMaxDepth();
        this.generateHmmTree();
        TimerPool.getTimer(this, "Compile").stop();
        this.searchGraph = new LexTreeSearchGraph(this.getInitialSearchState());
    }

    protected void generateHmmTree() {
        this.hmmPool = new HMMPool(this.acousticModel, this.logger, this.unitManager);
        this.hmmTree = new HMMTree(this.hmmPool, this.dictionary, this.languageModel, this.addFillerWords, this.languageWeight);
        this.hmmPool.dumpInfo();
    }

    private float calculateInsertionProbability(UnitNode unitNode) {
        int type = unitNode.getType();
        if (type == 1) {
            return this.logUnitInsertionProbability;
        }
        if (type == 2) {
            return this.logUnitInsertionProbability + this.logWordInsertionProbability;
        }
        if (type == 3) {
            return this.logSilenceInsertionProbability;
        }
        return this.logFillerInsertionProbability;
    }

    private float getUnigramSmear(Node node) {
        float prob = this.wantUnigramSmear ? node.getUnigramProbability() * this.unigramSmearWeight : this.logOne;
        return prob;
    }

    private float getSmearTermFromLanguageModel(WordSequence ws) {
        return this.languageModel.getSmear(ws);
    }

    private HMMNode[] getHMMNodes(EndNode endNode) {
        return this.hmmTree.getHMMNodes(endNode);
    }

    public class LexTreeEndWordState
    extends LexTreeWordState
    implements WordSearchState {
        LexTreeEndWordState(WordNode wordNode, HMMNode lastNode, WordSequence wordSequence, float smearTerm, float smearProb, float logProbability, boolean collapsed) {
            super(wordNode, lastNode, wordSequence, smearTerm, smearProb, logProbability, collapsed);
        }

        @Override
        public int getOrder() {
            return 2;
        }
    }

    public class LexTreeWordState
    extends LexTreeState
    implements WordSearchState {
        private HMMNode lastNode;
        private float logLanguageProbability;

        LexTreeWordState(WordNode wordNode, HMMNode lastNode, WordSequence wordSequence, float smearTerm, float smearProb, float languageProbability, boolean collapsed) {
            super(wordNode, wordSequence, smearTerm, smearProb, collapsed);
            this.lastNode = lastNode;
            this.logLanguageProbability = languageProbability;
        }

        @Override
        public Pronunciation getPronunciation() {
            return ((WordNode)this.getNode()).getPronunciation();
        }

        @Override
        public boolean isFinal() {
            return ((WordNode)this.getNode()).isFinal();
        }

        @Override
        public int hashCode() {
            return super.hashCode() * 41 + this.lastNode.hashCode();
        }

        @Override
        public String getSignature() {
            return super.getSignature() + "-ln-" + this.lastNode.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof LexTreeWordState) {
                LexTreeWordState other = (LexTreeWordState)o;
                return this.lastNode == other.lastNode && super.equals(o);
            }
            return false;
        }

        @Override
        public float getLanguageProbability() {
            return this.logLanguageProbability;
        }

        @Override
        public SearchStateArc[] getSuccessors() {
            SearchStateArc[] arcs = this.getCachedArcs();
            if (arcs == null) {
                arcs = EMPTY_ARC;
                WordNode wordNode = (WordNode)this.getNode();
                if (wordNode.getWord() != LexTreeLinguist.this.sentenceEndWord) {
                    int index = 0;
                    ArrayList<Node> list = new ArrayList<Node>();
                    Unit[] rc = this.lastNode.getRC();
                    Unit left = wordNode.getLastUnit();
                    for (Unit unit : rc) {
                        Node[] epList;
                        for (Node n : epList = LexTreeLinguist.this.hmmTree.getEntryPoint(left, unit)) {
                            list.add(n);
                        }
                    }
                    arcs = new SearchStateArc[list.size() + 1];
                    for (Node node : list) {
                        arcs[index++] = this.createUnitStateArc((HMMNode)node, this);
                    }
                    arcs[index++] = this.createWordStateArc(LexTreeLinguist.this.hmmTree.getSentenceEndWordNode(), this.lastNode, this);
                }
                this.putCachedArcs(arcs);
            }
            return arcs;
        }

        @Override
        public int getOrder() {
            return 1;
        }

        @Override
        public boolean isWordStart() {
            return false;
        }
    }

    public class LexTreeNonEmittingHMMState
    extends LexTreeHMMState {
        LexTreeNonEmittingHMMState(HMMNode hmmNode, WordSequence wordSequence, float smearTerm, float smearProb, HMMState hmmState, float probability, Node parentNode, boolean collapsed) {
            super(hmmNode, wordSequence, smearTerm, smearProb, hmmState, LexTreeLinguist.this.logOne, probability, parentNode, collapsed);
        }

        @Override
        public int getOrder() {
            return 0;
        }
    }

    public class LexTreeHMMState
    extends LexTreeState
    implements HMMSearchState,
    ScoreProvider {
        private final HMMState hmmState;
        private float logLanguageProbability;
        private float logInsertionProbability;
        private final Node parentNode;
        int hashCode;

        LexTreeHMMState(HMMNode hmmNode, WordSequence wordSequence, float smearTerm, float smearProb, HMMState hmmState, float languageProbability, float insertionProbability, Node parentNode, boolean collapsed) {
            super(hmmNode, wordSequence, smearTerm, smearProb, collapsed);
            this.hashCode = -1;
            this.hmmState = hmmState;
            this.parentNode = parentNode;
            this.logLanguageProbability = languageProbability;
            this.logInsertionProbability = insertionProbability;
        }

        @Override
        public String getSignature() {
            return super.getSignature() + "-HMM-" + this.hmmState.getState();
        }

        @Override
        public HMMState getHMMState() {
            return this.hmmState;
        }

        @Override
        public int hashCode() {
            if (this.hashCode == -1) {
                this.hashCode = super.hashCode() * 29 + (this.hmmState.getState() + 1);
                if (this.parentNode != null) {
                    this.hashCode *= 377;
                    this.hashCode += this.parentNode.hashCode();
                }
            }
            return this.hashCode;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof LexTreeHMMState) {
                LexTreeHMMState other = (LexTreeHMMState)o;
                return this.hmmState == other.hmmState && this.parentNode == other.parentNode && super.equals(o);
            }
            return false;
        }

        @Override
        public float getLanguageProbability() {
            return this.logLanguageProbability;
        }

        @Override
        public float getInsertionProbability() {
            return this.logInsertionProbability;
        }

        @Override
        public SearchStateArc[] getSuccessors() {
            SearchStateArc[] nextStates = this.getCachedArcs();
            if (nextStates == null) {
                if (this.hmmState.isExitState()) {
                    nextStates = this.parentNode == null ? super.getSuccessors() : super.getSuccessors(this.parentNode);
                } else {
                    HMMStateArc[] arcs = this.hmmState.getSuccessors();
                    nextStates = new SearchStateArc[arcs.length];
                    for (int i = 0; i < arcs.length; ++i) {
                        HMMStateArc arc = arcs[i];
                        if (arc.getHMMState().isEmitting()) {
                            if (arc.getHMMState() == this.hmmState && this.logInsertionProbability == arc.getLogProbability()) {
                                nextStates[i] = this;
                                continue;
                            }
                            nextStates[i] = new LexTreeHMMState((HMMNode)this.getNode(), this.getWordHistory(), this.getSmearTerm(), this.getSmearProb(), arc.getHMMState(), LexTreeLinguist.this.logOne, arc.getLogProbability(), this.parentNode, this.collapsed);
                            continue;
                        }
                        nextStates[i] = new LexTreeNonEmittingHMMState((HMMNode)this.getNode(), this.getWordHistory(), this.getSmearTerm(), this.getSmearProb(), arc.getHMMState(), arc.getLogProbability(), this.parentNode, this.collapsed);
                    }
                }
                this.putCachedArcs(nextStates);
            }
            return nextStates;
        }

        @Override
        public boolean isEmitting() {
            return this.hmmState.isEmitting();
        }

        @Override
        public String toString() {
            return super.toString() + " hmm:" + this.hmmState;
        }

        @Override
        public int getOrder() {
            return 5;
        }

        @Override
        public float getScore(Data data) {
            return this.hmmState.getScore(data);
        }
    }

    public class LexTreeUnitState
    extends LexTreeState
    implements UnitSearchState {
        private float logInsertionProbability;
        private float logLanguageProbability;
        private Node parentNode;
        private int hashCode;

        LexTreeUnitState(HMMNode hmmNode, WordSequence wordSequence, float smearTerm, float smearProb, float languageProbability, float insertionProbability, boolean collapsed) {
            this(hmmNode, wordSequence, smearTerm, smearProb, languageProbability, insertionProbability, null, collapsed);
        }

        LexTreeUnitState(HMMNode hmmNode, WordSequence wordSequence, float smearTerm, float smearProb, float languageProbability, float insertionProbability, Node parentNode, boolean collapsed) {
            super(hmmNode, wordSequence, smearTerm, smearProb, collapsed);
            this.hashCode = -1;
            this.logInsertionProbability = insertionProbability;
            this.logLanguageProbability = languageProbability;
            this.parentNode = parentNode;
        }

        @Override
        public Unit getUnit() {
            return this.getHMMNode().getBaseUnit();
        }

        @Override
        public int hashCode() {
            if (this.hashCode == -1) {
                this.hashCode = super.hashCode() * 17 + 421;
                if (this.parentNode != null) {
                    this.hashCode *= 432;
                    this.hashCode += this.parentNode.hashCode();
                }
            }
            return this.hashCode;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof LexTreeUnitState) {
                LexTreeUnitState other = (LexTreeUnitState)o;
                return this.parentNode == other.parentNode && super.equals(o);
            }
            return false;
        }

        private HMMNode getHMMNode() {
            return (HMMNode)this.getNode();
        }

        @Override
        public SearchStateArc[] getSuccessors() {
            SearchStateArc[] arcs = new SearchStateArc[1];
            HMM hmm = this.getHMMNode().getHMM();
            arcs[0] = new LexTreeHMMState(this.getHMMNode(), this.getWordHistory(), this.getSmearTerm(), this.getSmearProb(), hmm.getInitialState(), LexTreeLinguist.this.logOne, LexTreeLinguist.this.logOne, this.parentNode, this.collapsed);
            return arcs;
        }

        @Override
        public String toString() {
            return super.toString() + " unit";
        }

        @Override
        public float getInsertionProbability() {
            return this.logInsertionProbability;
        }

        @Override
        public float getLanguageProbability() {
            return this.logLanguageProbability;
        }

        @Override
        public int getOrder() {
            return 4;
        }
    }

    public class LexTreeEndUnitState
    extends LexTreeState
    implements UnitSearchState {
        float logLanguageProbability;
        float logInsertionProbability;

        LexTreeEndUnitState(EndNode endNode, WordSequence wordSequence, float smearTerm, float smearProb, float languageProbability, float insertionProbability, boolean collapsed) {
            super(endNode, wordSequence, smearTerm, smearProb, collapsed);
            this.logLanguageProbability = languageProbability;
            this.logInsertionProbability = insertionProbability;
        }

        @Override
        public Unit getUnit() {
            return this.getEndNode().getBaseUnit();
        }

        @Override
        public int hashCode() {
            return super.hashCode() * 17 + 423;
        }

        @Override
        public float getInsertionProbability() {
            return this.logInsertionProbability;
        }

        @Override
        public float getLanguageProbability() {
            return this.logLanguageProbability;
        }

        @Override
        public boolean equals(Object o) {
            return o == this || o instanceof LexTreeEndUnitState && super.equals(o);
        }

        private EndNode getEndNode() {
            return (EndNode)this.getNode();
        }

        @Override
        public SearchStateArc[] getSuccessors() {
            SearchStateArc[] arcs = this.getCachedArcs();
            if (arcs == null) {
                HMMNode[] nodes = LexTreeLinguist.this.getHMMNodes(this.getEndNode());
                arcs = new SearchStateArc[nodes.length];
                if (LexTreeLinguist.this.generateUnitStates) {
                    for (int i = 0; i < nodes.length; ++i) {
                        arcs[i] = new LexTreeUnitState(nodes[i], this.getWordHistory(), this.getSmearTerm(), this.getSmearProb(), LexTreeLinguist.this.logOne, LexTreeLinguist.this.logOne, this.getNode(), this.collapsed);
                    }
                } else {
                    for (int i = 0; i < nodes.length; ++i) {
                        HMM hmm = nodes[i].getHMM();
                        arcs[i] = new LexTreeHMMState(nodes[i], this.getWordHistory(), this.getSmearTerm(), this.getSmearProb(), hmm.getInitialState(), LexTreeLinguist.this.logOne, LexTreeLinguist.this.logOne, this.getNode(), this.collapsed);
                    }
                }
                this.putCachedArcs(arcs);
            }
            return arcs;
        }

        @Override
        public String toString() {
            return super.toString() + " EndUnit";
        }

        @Override
        public int getOrder() {
            return 3;
        }
    }

    abstract class LexTreeState
    implements SearchState,
    SearchStateArc {
        private final Node node;
        private final WordSequence wordSequence;
        protected final boolean collapsed;
        final float currentSmearTerm;
        final float currentSmearProb;

        LexTreeState(Node node, WordSequence wordSequence, float smearTerm, float smearProb, boolean collapsed) {
            this.node = node;
            this.wordSequence = wordSequence;
            this.currentSmearTerm = smearTerm;
            this.currentSmearProb = smearProb;
            this.collapsed = collapsed;
        }

        @Override
        public String getSignature() {
            return "lts-" + this.node.hashCode() + "-ws-" + this.wordSequence;
        }

        public float getSmearTerm() {
            return this.currentSmearTerm;
        }

        public float getSmearProb() {
            return this.currentSmearProb;
        }

        public int hashCode() {
            int hashCode = this.collapsed ? 37 : this.wordSequence.hashCode() * 37;
            return hashCode += this.node.hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof LexTreeState) {
                LexTreeState other = (LexTreeState)o;
                if (this.node != other.node) {
                    return false;
                }
                if (this.collapsed != other.collapsed) {
                    return false;
                }
                boolean wordSequenceMatch = this.collapsed || this.wordSequence.equals(other.wordSequence);
                return wordSequenceMatch;
            }
            return false;
        }

        @Override
        public SearchState getState() {
            return this;
        }

        @Override
        public float getProbability() {
            return this.getLanguageProbability() + this.getInsertionProbability();
        }

        @Override
        public float getLanguageProbability() {
            return LexTreeLinguist.this.logOne;
        }

        @Override
        public float getInsertionProbability() {
            return LexTreeLinguist.this.logOne;
        }

        @Override
        public boolean isEmitting() {
            return false;
        }

        @Override
        public boolean isFinal() {
            return false;
        }

        protected Node getNode() {
            return this.node;
        }

        @Override
        public WordSequence getWordHistory() {
            return this.wordSequence;
        }

        @Override
        public Node getLexState() {
            return this.node;
        }

        @Override
        public SearchStateArc[] getSuccessors() {
            SearchStateArc[] arcs = this.getCachedArcs();
            if (arcs == null) {
                arcs = this.getSuccessors(this.node);
                this.putCachedArcs(arcs);
            }
            return arcs;
        }

        protected SearchStateArc[] getSuccessors(Node theNode) {
            Node[] nodes = theNode.getSuccessors();
            SearchStateArc[] arcs = new SearchStateArc[nodes.length];
            int i = 0;
            for (Node nextNode : nodes) {
                arcs[i] = nextNode instanceof WordNode ? this.createWordStateArc((WordNode)nextNode, (HMMNode)this.getNode(), this) : (nextNode instanceof EndNode ? this.createEndUnitArc((EndNode)nextNode, this) : this.createUnitStateArc((HMMNode)nextNode, this));
                ++i;
            }
            return arcs;
        }

        protected SearchStateArc createWordStateArc(WordNode wordNode, HMMNode lastUnit, LexTreeState previous) {
            boolean collapse;
            float languageProbability = LexTreeLinguist.this.logOne;
            Word nextWord = wordNode.getWord();
            float smearTerm = previous.getSmearTerm();
            if (nextWord.isFiller() && nextWord != LexTreeLinguist.this.sentenceEndWord) {
                return new LexTreeWordState(wordNode, lastUnit, this.wordSequence, smearTerm, LexTreeLinguist.this.logOne, languageProbability, this.collapsed);
            }
            WordSequence nextWordSequence = this.wordSequence.addWord(nextWord, LexTreeLinguist.this.maxDepth);
            ProbDepth probDepth = LexTreeLinguist.this.languageModel.getProbDepth(nextWordSequence);
            smearTerm = LexTreeLinguist.this.getSmearTermFromLanguageModel(nextWordSequence);
            float probability = probDepth.probability * LexTreeLinguist.this.languageWeight;
            languageProbability = probability - previous.getSmearProb();
            boolean bl = collapse = probDepth.depth < LexTreeLinguist.this.maxDepth - 1 || !LexTreeLinguist.this.fullWordHistories;
            if (nextWord == LexTreeLinguist.this.sentenceEndWord) {
                return new LexTreeEndWordState(wordNode, lastUnit, nextWordSequence.trim(LexTreeLinguist.this.maxDepth - 1), smearTerm, LexTreeLinguist.this.logOne, languageProbability, collapse);
            }
            return new LexTreeWordState(wordNode, lastUnit, nextWordSequence.trim(LexTreeLinguist.this.maxDepth - 1), smearTerm, LexTreeLinguist.this.logOne, languageProbability, collapse);
        }

        SearchStateArc createUnitStateArc(HMMNode hmmNode, LexTreeState previous) {
            LexTreeState arc;
            float insertionProbability = LexTreeLinguist.this.calculateInsertionProbability(hmmNode);
            float smearProbability = LexTreeLinguist.this.getUnigramSmear(hmmNode) + previous.getSmearTerm();
            float languageProbability = smearProbability - previous.getSmearProb();
            if (LexTreeLinguist.this.generateUnitStates) {
                arc = new LexTreeUnitState(hmmNode, this.getWordHistory(), previous.getSmearTerm(), smearProbability, languageProbability, insertionProbability, this.collapsed);
            } else {
                HMM hmm = hmmNode.getHMM();
                arc = new LexTreeHMMState(hmmNode, this.getWordHistory(), previous.getSmearTerm(), smearProbability, hmm.getInitialState(), languageProbability, insertionProbability, null, this.collapsed);
            }
            return arc;
        }

        SearchStateArc createEndUnitArc(EndNode endNode, LexTreeState previous) {
            float smearProbability = LexTreeLinguist.this.getUnigramSmear(endNode) + previous.getSmearTerm();
            float languageProbability = smearProbability - previous.getSmearProb();
            float insertionProbability = LexTreeLinguist.this.calculateInsertionProbability(endNode);
            return new LexTreeEndUnitState(endNode, this.getWordHistory(), previous.getSmearTerm(), smearProbability, languageProbability, insertionProbability, this.collapsed);
        }

        public String toString() {
            return "lt-" + this.node + ' ' + this.getProbability() + '{' + this.wordSequence + '}';
        }

        @Override
        public String toPrettyString() {
            return this.toString();
        }

        SearchStateArc[] getCachedArcs() {
            if (LexTreeLinguist.this.cacheEnabled) {
                SearchStateArc[] arcs = (SearchStateArc[])LexTreeLinguist.this.arcCache.get(this);
                if (arcs != null) {
                    LexTreeLinguist.this.cacheHits++;
                }
                if (++LexTreeLinguist.this.cacheTrys % 1000000 == 0) {
                    System.out.println("Hits: " + LexTreeLinguist.this.cacheHits + " of " + LexTreeLinguist.this.cacheTrys + ' ' + (float)LexTreeLinguist.this.cacheHits / (float)LexTreeLinguist.this.cacheTrys * 100.0f);
                }
                return arcs;
            }
            return null;
        }

        void putCachedArcs(SearchStateArc[] arcs) {
            if (LexTreeLinguist.this.cacheEnabled) {
                LexTreeLinguist.this.arcCache.put(this, arcs);
            }
        }

        @Override
        public abstract int getOrder();
    }

    class LexTreeSearchGraph
    implements SearchGraph {
        private SearchState initialState;

        LexTreeSearchGraph(SearchState initialState) {
            this.initialState = initialState;
        }

        @Override
        public SearchState getInitialState() {
            return this.initialState;
        }

        @Override
        public int getNumStateOrder() {
            return 6;
        }
    }
}

