/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.flat;

import edu.cmu.sphinx.linguist.Linguist;
import edu.cmu.sphinx.linguist.SearchGraph;
import edu.cmu.sphinx.linguist.SearchState;
import edu.cmu.sphinx.linguist.SearchStateArc;
import edu.cmu.sphinx.linguist.acoustic.AcousticModel;
import edu.cmu.sphinx.linguist.acoustic.HMM;
import edu.cmu.sphinx.linguist.acoustic.HMMPosition;
import edu.cmu.sphinx.linguist.acoustic.HMMState;
import edu.cmu.sphinx.linguist.acoustic.HMMStateArc;
import edu.cmu.sphinx.linguist.acoustic.LeftRightContext;
import edu.cmu.sphinx.linguist.acoustic.Unit;
import edu.cmu.sphinx.linguist.acoustic.UnitManager;
import edu.cmu.sphinx.linguist.dictionary.Pronunciation;
import edu.cmu.sphinx.linguist.dictionary.Word;
import edu.cmu.sphinx.linguist.flat.BranchState;
import edu.cmu.sphinx.linguist.flat.CIPhoneLoop;
import edu.cmu.sphinx.linguist.flat.ContextPair;
import edu.cmu.sphinx.linguist.flat.ExtendedUnitState;
import edu.cmu.sphinx.linguist.flat.GrammarState;
import edu.cmu.sphinx.linguist.flat.HMMStateState;
import edu.cmu.sphinx.linguist.flat.NonEmittingHMMState;
import edu.cmu.sphinx.linguist.flat.PronunciationState;
import edu.cmu.sphinx.linguist.flat.SentenceHMMState;
import edu.cmu.sphinx.linguist.flat.SentenceHMMStateArc;
import edu.cmu.sphinx.linguist.flat.UnitContext;
import edu.cmu.sphinx.linguist.flat.UnitState;
import edu.cmu.sphinx.linguist.language.grammar.Grammar;
import edu.cmu.sphinx.linguist.language.grammar.GrammarArc;
import edu.cmu.sphinx.linguist.language.grammar.GrammarNode;
import edu.cmu.sphinx.util.Cache;
import edu.cmu.sphinx.util.LogMath;
import edu.cmu.sphinx.util.StatisticsVariable;
import edu.cmu.sphinx.util.TimerPool;
import edu.cmu.sphinx.util.props.Configurable;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4Component;
import edu.cmu.sphinx.util.props.S4Double;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FlatLinguist
implements Linguist,
Configurable {
    @S4Component(type=Grammar.class)
    public static final String PROP_GRAMMAR = "grammar";
    @S4Component(type=UnitManager.class)
    public static final String PROP_UNIT_MANAGER = "unitManager";
    @S4Component(type=AcousticModel.class)
    public static final String PROP_ACOUSTIC_MODEL = "acousticModel";
    @S4Component(type=LogMath.class)
    public static final String PROP_LOG_MATH = "logMath";
    @S4Boolean(defaultValue=false)
    public static final String PROP_DUMP_GSTATES = "dumpGstates";
    @S4Boolean(defaultValue=false)
    public static final String PROP_ADD_OUT_OF_GRAMMAR_BRANCH = "addOutOfGrammarBranch";
    @S4Double(defaultValue=1.0)
    public static final String PROP_OUT_OF_GRAMMAR_PROBABILITY = "outOfGrammarProbability";
    @S4Component(type=AcousticModel.class)
    public static final String PROP_PHONE_LOOP_ACOUSTIC_MODEL = "phoneLoopAcousticModel";
    @S4Double(defaultValue=1.0)
    public static final String PROP_PHONE_INSERTION_PROBABILITY = "phoneInsertionProbability";
    @S4Boolean(defaultValue=false)
    public static final String PROP_SHOW_COMPILATION_PROGRESS = "showCompilationProgress";
    @S4Boolean(defaultValue=false)
    public static final String PROP_SPREAD_WORD_PROBABILITIES_ACROSS_PRONUNCIATIONS = "spreadWordProbabilitiesAcrossPronunciations";
    protected static final float logOne = LogMath.getLogOne();
    protected Grammar grammar;
    private AcousticModel acousticModel;
    private UnitManager unitManager;
    protected LogMath logMath;
    protected AcousticModel phoneLoopAcousticModel;
    protected boolean addOutOfGrammarBranch;
    protected float logOutOfGrammarBranchProbability;
    protected float logPhoneInsertionProbability;
    private float logWordInsertionProbability;
    private float logSilenceInsertionProbability;
    private float logFillerInsertionProbability;
    private float logUnitInsertionProbability;
    private boolean showCompilationProgress = true;
    private boolean spreadWordProbabilitiesAcrossPronunciations;
    private boolean dumpGStates;
    private float languageWeight;
    protected StatisticsVariable totalStates;
    protected StatisticsVariable totalArcs;
    protected StatisticsVariable actualArcs;
    private transient int totalStateCounter;
    private static final boolean tracing = false;
    private transient Collection<SentenceHMMState> stateSet;
    private String name;
    protected Map<GrammarNode, GState> nodeStateMap;
    protected Cache<SentenceHMMStateArc> arcPool;
    protected GrammarNode initialGrammarState;
    protected SearchGraph searchGraph;

    @Override
    public SearchGraph getSearchGraph() {
        return this.searchGraph;
    }

    public FlatLinguist(AcousticModel acousticModel, LogMath logMath, Grammar grammar, UnitManager unitManager, double wordInsertionProbability, double silenceInsertionProbability, double fillerInsertionProbability, double unitInsertionProbability, float languageWeight, boolean dumpGStates, boolean showCompilationProgress, boolean spreadWordProbabilitiesAcrossPronunciations, boolean addOutOfGrammarBranch, double outOfGrammarBranchProbability, double phoneInsertionProbability, AcousticModel phoneLoopAcousticModel) {
        this.acousticModel = acousticModel;
        this.logMath = logMath;
        this.grammar = grammar;
        this.unitManager = unitManager;
        this.logWordInsertionProbability = logMath.linearToLog(wordInsertionProbability);
        this.logSilenceInsertionProbability = logMath.linearToLog(silenceInsertionProbability);
        this.logFillerInsertionProbability = logMath.linearToLog(fillerInsertionProbability);
        this.logUnitInsertionProbability = logMath.linearToLog(unitInsertionProbability);
        this.languageWeight = languageWeight;
        this.dumpGStates = dumpGStates;
        this.showCompilationProgress = showCompilationProgress;
        this.spreadWordProbabilitiesAcrossPronunciations = spreadWordProbabilitiesAcrossPronunciations;
        this.addOutOfGrammarBranch = addOutOfGrammarBranch;
        if (addOutOfGrammarBranch) {
            this.logOutOfGrammarBranchProbability = logMath.linearToLog(outOfGrammarBranchProbability);
            this.logPhoneInsertionProbability = logMath.linearToLog(phoneInsertionProbability);
            this.phoneLoopAcousticModel = phoneLoopAcousticModel;
        }
        this.name = null;
    }

    public FlatLinguist() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        this.setupAcousticModel(ps);
        this.logMath = (LogMath)ps.getComponent(PROP_LOG_MATH);
        this.grammar = (Grammar)ps.getComponent(PROP_GRAMMAR);
        this.unitManager = (UnitManager)ps.getComponent(PROP_UNIT_MANAGER);
        this.logWordInsertionProbability = this.logMath.linearToLog(ps.getDouble("wordInsertionProbability"));
        this.logSilenceInsertionProbability = this.logMath.linearToLog(ps.getDouble("silenceInsertionProbability"));
        this.logFillerInsertionProbability = this.logMath.linearToLog(ps.getDouble("fillerInsertionProbability"));
        this.logUnitInsertionProbability = this.logMath.linearToLog(ps.getDouble("unitInsertionProbability"));
        this.languageWeight = ps.getFloat("languageWeight");
        this.dumpGStates = ps.getBoolean(PROP_DUMP_GSTATES);
        this.showCompilationProgress = ps.getBoolean(PROP_SHOW_COMPILATION_PROGRESS);
        this.spreadWordProbabilitiesAcrossPronunciations = ps.getBoolean(PROP_SPREAD_WORD_PROBABILITIES_ACROSS_PRONUNCIATIONS);
        this.addOutOfGrammarBranch = ps.getBoolean(PROP_ADD_OUT_OF_GRAMMAR_BRANCH);
        if (this.addOutOfGrammarBranch) {
            this.logOutOfGrammarBranchProbability = this.logMath.linearToLog(ps.getDouble(PROP_OUT_OF_GRAMMAR_PROBABILITY));
            this.logPhoneInsertionProbability = this.logMath.linearToLog(ps.getDouble(PROP_PHONE_INSERTION_PROBABILITY));
            this.phoneLoopAcousticModel = (AcousticModel)ps.getComponent(PROP_PHONE_LOOP_ACOUSTIC_MODEL);
        }
        this.name = ps.getInstanceName();
    }

    protected void setupAcousticModel(PropertySheet ps) throws PropertyException {
        this.acousticModel = (AcousticModel)ps.getComponent(PROP_ACOUSTIC_MODEL);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void allocate() throws IOException {
        this.allocateAcousticModel();
        this.grammar.allocate();
        this.totalStates = StatisticsVariable.getStatisticsVariable(this.getName(), "totalStates");
        this.totalArcs = StatisticsVariable.getStatisticsVariable(this.getName(), "totalArcs");
        this.actualArcs = StatisticsVariable.getStatisticsVariable(this.getName(), "actualArcs");
        this.stateSet = this.compileGrammar();
        this.totalStates.value = this.stateSet.size();
    }

    protected void allocateAcousticModel() throws IOException {
        this.acousticModel.allocate();
        if (this.addOutOfGrammarBranch) {
            this.phoneLoopAcousticModel.allocate();
        }
    }

    @Override
    public void deallocate() {
        if (this.acousticModel != null) {
            this.acousticModel.deallocate();
        }
        this.grammar.deallocate();
    }

    @Override
    public void startRecognition() {
        if (this.grammarHasChanged()) {
            this.stateSet = this.compileGrammar();
            this.totalStates.value = this.stateSet.size();
        }
    }

    @Override
    public void stopRecognition() {
    }

    public LogMath getLogMath() {
        return this.logMath;
    }

    public float getLogSilenceInsertionProbability() {
        return this.logSilenceInsertionProbability;
    }

    protected Collection<SentenceHMMState> compileGrammar() {
        this.initialGrammarState = this.grammar.getInitialNode();
        this.nodeStateMap = new HashMap<GrammarNode, GState>();
        this.arcPool = new Cache();
        ArrayList<GState> gstateList = new ArrayList<GState>();
        TimerPool.getTimer(this, "Compile").start();
        TimerPool.getTimer(this, "Create States").start();
        for (GrammarNode grammarNode : this.grammar.getGrammarNodes()) {
            GState gstate = this.createGState(grammarNode);
            gstateList.add(gstate);
        }
        TimerPool.getTimer(this, "Create States").stop();
        this.addStartingPath();
        TimerPool.getTimer(this, "Collect Contexts").start();
        for (GState gstate : gstateList) {
            gstate.collectContexts();
        }
        TimerPool.getTimer(this, "Collect Contexts").stop();
        TimerPool.getTimer(this, "Expand States").start();
        for (GState gstate : gstateList) {
            gstate.expand();
        }
        TimerPool.getTimer(this, "Expand States").stop();
        TimerPool.getTimer(this, "Connect Nodes").start();
        for (GState gstate : gstateList) {
            gstate.connect();
        }
        TimerPool.getTimer(this, "Connect Nodes").stop();
        SentenceHMMState initialState = this.findStartingState();
        if (this.addOutOfGrammarBranch) {
            CIPhoneLoop phoneLoop = new CIPhoneLoop(this.phoneLoopAcousticModel, this.logPhoneInsertionProbability);
            SentenceHMMState firstBranchState = (SentenceHMMState)phoneLoop.getSearchGraph().getInitialState();
            initialState.connect(this.getArc(firstBranchState, logOne, this.logOutOfGrammarBranchProbability));
        }
        this.searchGraph = new FlatSearchGraph(initialState);
        TimerPool.getTimer(this, "Compile").stop();
        if (this.dumpGStates) {
            for (GrammarNode grammarNode : this.grammar.getGrammarNodes()) {
                GState gstate = this.getGState(grammarNode);
                gstate.dumpInfo();
            }
        }
        this.nodeStateMap = null;
        this.arcPool = null;
        return SentenceHMMState.collectStates(initialState);
    }

    protected GState createGState(GrammarNode grammarNode) {
        return new GState(grammarNode);
    }

    protected void addStartingPath() {
        this.addStartingPath(this.grammar.getInitialNode());
    }

    protected void addStartingPath(GrammarNode initialNode) {
        GrammarNode node = initialNode;
        GState gstate = this.getGState(node);
        gstate.addLeftContext(UnitContext.SILENCE);
    }

    protected boolean grammarHasChanged() {
        return this.initialGrammarState == null || this.initialGrammarState != this.grammar.getInitialNode();
    }

    protected SentenceHMMState findStartingState() {
        GrammarNode node = this.grammar.getInitialNode();
        GState gstate = this.getGState(node);
        return gstate.getEntryPoint();
    }

    protected SentenceHMMStateArc getArc(SentenceHMMState nextState, float logLanguageProbability, float logInsertionProbability) {
        SentenceHMMStateArc arc = new SentenceHMMStateArc(nextState, logLanguageProbability * this.languageWeight, logInsertionProbability);
        SentenceHMMStateArc pooledArc = this.arcPool.cache(arc);
        this.actualArcs.value = this.arcPool.getMisses();
        this.totalArcs.value = this.arcPool.getHits() + this.arcPool.getMisses();
        return pooledArc == null ? arc : pooledArc;
    }

    protected GState getGState(GrammarNode node) {
        return this.nodeStateMap.get(node);
    }

    private void T(String s) {
    }

    protected class GState {
        private final Map<ContextPair, List<SearchState>> entryPoints = new HashMap<ContextPair, List<SearchState>>();
        private final Map<ContextPair, List<SearchState>> exitPoints = new HashMap<ContextPair, List<SearchState>>();
        private final Map<String, SentenceHMMState> existingStates = new HashMap<String, SentenceHMMState>();
        private final GrammarNode node;
        private final Set<UnitContext> rightContexts = new HashSet<UnitContext>();
        private final Set<UnitContext> leftContexts = new HashSet<UnitContext>();
        private Set<UnitContext> startingContexts;
        private int exitConnections;

        protected GState(GrammarNode node) {
            this.node = node;
            FlatLinguist.this.nodeStateMap.put(node, this);
        }

        private Set<UnitContext> getStartingContexts() {
            block4: {
                if (this.startingContexts != null) break block4;
                this.startingContexts = new HashSet<UnitContext>();
                if (this.node.isEmpty()) {
                    GrammarArc[] arcs;
                    for (GrammarArc arc : arcs = this.getSuccessors()) {
                        GState gstate = FlatLinguist.this.getGState(arc.getGrammarNode());
                        this.startingContexts.addAll(gstate.getStartingContexts());
                    }
                } else {
                    Pronunciation[] prons;
                    Word word = this.node.getWord();
                    for (Pronunciation pron : prons = word.getPronunciations(null)) {
                        UnitContext startingContext = this.getStartingContext(pron);
                        this.startingContexts.add(startingContext);
                    }
                }
            }
            return this.startingContexts;
        }

        private UnitContext getStartingContext(Pronunciation pronunciation) {
            int maxSize = this.getRightContextSize();
            Unit[] units = pronunciation.getUnits();
            Unit[] context = units.length > maxSize ? Arrays.copyOf(units, maxSize) : units;
            return UnitContext.get(context);
        }

        Collection<UnitContext> getEndingContexts() {
            ArrayList<UnitContext> endingContexts = new ArrayList<UnitContext>();
            if (!this.node.isEmpty()) {
                Pronunciation[] prons;
                int maxSize = this.getLeftContextSize();
                Word word = this.node.getWord();
                for (Pronunciation pron : prons = word.getPronunciations(null)) {
                    Unit[] units = pron.getUnits();
                    int size = units.length;
                    Unit[] context = size > maxSize ? Arrays.copyOfRange(units, size - maxSize, size) : units;
                    endingContexts.add(UnitContext.get(context));
                }
            }
            return endingContexts;
        }

        private void pullRightContexts() {
            GrammarArc[] arcs;
            for (GrammarArc arc : arcs = this.getSuccessors()) {
                GState gstate = FlatLinguist.this.getGState(arc.getGrammarNode());
                this.rightContexts.addAll(gstate.getStartingContexts());
            }
        }

        private GrammarArc[] getSuccessors() {
            return this.node.getSuccessors();
        }

        void pushLeftContexts() {
            Collection<UnitContext> endingContext = this.getEndingContexts();
            HashSet<GrammarNode> visitedSet = new HashSet<GrammarNode>();
            this.pushLeftContexts(visitedSet, endingContext);
        }

        void pushLeftContexts(Set<GrammarNode> visitedSet, Collection<UnitContext> leftContext) {
            if (visitedSet.contains(this.getNode())) {
                return;
            }
            visitedSet.add(this.getNode());
            for (GrammarArc arc : this.getSuccessors()) {
                GState gstate = FlatLinguist.this.getGState(arc.getGrammarNode());
                gstate.addLeftContext(leftContext);
                if (!gstate.getNode().isEmpty()) continue;
                gstate.pushLeftContexts(visitedSet, leftContext);
            }
        }

        private void addLeftContext(Collection<UnitContext> context) {
            this.leftContexts.addAll(context);
        }

        private void addLeftContext(UnitContext context) {
            this.leftContexts.add(context);
        }

        private List<SearchState> getEntryPoints(ContextPair contextPair) {
            return this.entryPoints.get(contextPair);
        }

        public SentenceHMMState getEntryPoint() {
            ContextPair cp = ContextPair.get(UnitContext.SILENCE, UnitContext.SILENCE);
            List<SearchState> list = this.getEntryPoints(cp);
            return list == null || list.isEmpty() ? null : (SentenceHMMState)list.get(0);
        }

        public void collectContexts() {
            this.pullRightContexts();
            this.pushLeftContexts();
        }

        public void expand() {
            for (UnitContext unitContext : this.leftContexts) {
                for (UnitContext startingContext : this.getStartingContexts()) {
                    ContextPair contextPair = ContextPair.get(unitContext, startingContext);
                    this.entryPoints.put(contextPair, new ArrayList());
                }
            }
            if (this.node.isFinalNode()) {
                GrammarState gs = new GrammarState(this.node);
                for (List<SearchState> epList : this.entryPoints.values()) {
                    epList.add(gs);
                }
            } else if (!this.node.isEmpty()) {
                for (UnitContext unitContext : this.leftContexts) {
                    this.expandWord(unitContext);
                }
            } else {
                for (Map.Entry entry : this.entryPoints.entrySet()) {
                    ContextPair cp = (ContextPair)entry.getKey();
                    List epList = (List)entry.getValue();
                    BranchState bs = new BranchState(cp.getLeftContext().toString(), cp.getRightContext().toString(), this.node.getID());
                    epList.add(bs);
                    this.addExitPoint(cp, bs);
                }
            }
            this.addEmptyEntryPoints();
        }

        private void addEmptyEntryPoints() {
            HashMap emptyEntryPoints = new HashMap();
            for (Map.Entry<ContextPair, List<SearchState>> entry : this.entryPoints.entrySet()) {
                ContextPair cp = entry.getKey();
                if (!this.needsEmptyVersion(cp)) continue;
                ContextPair emptyContextPair = ContextPair.get(cp.getLeftContext(), UnitContext.EMPTY);
                ArrayList epList = (ArrayList)emptyEntryPoints.get(emptyContextPair);
                if (epList == null) {
                    epList = new ArrayList();
                    emptyEntryPoints.put(emptyContextPair, epList);
                }
                epList.addAll(entry.getValue());
            }
            this.entryPoints.putAll(emptyEntryPoints);
        }

        private boolean needsEmptyVersion(ContextPair cp) {
            UnitContext left = cp.getLeftContext();
            Unit[] units = left.getUnits();
            return units.length > 0 && this.getRightContextSize(units[0]) < this.getRightContextSize();
        }

        private GrammarNode getNode() {
            return this.node;
        }

        private void expandWord(UnitContext leftContext) {
            Word word = this.node.getWord();
            FlatLinguist.this.T("  Expanding word " + word + " for lc " + leftContext);
            Pronunciation[] pronunciations = word.getPronunciations(null);
            for (int i = 0; i < pronunciations.length; ++i) {
                this.expandPronunciation(leftContext, pronunciations[i], i);
            }
        }

        private void expandPronunciation(UnitContext leftContext, Pronunciation pronunciation, int which) {
            UnitContext startingContext = this.getStartingContext(pronunciation);
            String pname = "P(" + pronunciation.getWord() + '[' + leftContext + ',' + startingContext + "])-G" + this.getNode().getID();
            PronunciationState ps = new PronunciationState(pname, pronunciation, which);
            FlatLinguist.this.T("     Expanding " + ps.getPronunciation() + " for lc " + leftContext);
            ContextPair cp = ContextPair.get(leftContext, startingContext);
            List<SearchState> epList = this.entryPoints.get(cp);
            if (epList == null) {
                throw new Error("No EP list for context pair " + cp);
            }
            epList.add(ps);
            Unit[] units = pronunciation.getUnits();
            int fanOutPoint = units.length - this.getRightContextSize();
            if (fanOutPoint < 0) {
                fanOutPoint = 0;
            }
            SentenceHMMState tail = ps;
            for (int i = 0; tail != null && i < fanOutPoint; ++i) {
                tail = this.attachUnit(ps, tail, units, i, leftContext, UnitContext.EMPTY);
            }
            PronunciationState branchTail = tail;
            for (UnitContext finalRightContext : this.rightContexts) {
                tail = branchTail;
                for (int i = fanOutPoint; tail != null && i < units.length; ++i) {
                    tail = this.attachUnit(ps, tail, units, i, leftContext, finalRightContext);
                }
            }
        }

        private SentenceHMMState attachUnit(PronunciationState parent, SentenceHMMState tail, Unit[] units, int which, UnitContext leftContext, UnitContext rightContext) {
            Unit[] lc = this.getLC(leftContext, units, which);
            Unit[] rc = this.getRC(units, which, rightContext);
            UnitContext actualRightContext = UnitContext.get(rc);
            LeftRightContext context = LeftRightContext.get(lc, rc);
            Unit cdUnit = FlatLinguist.this.unitManager.getUnit(units[which].getName(), units[which].isFiller(), context);
            ExtendedUnitState unitState = new ExtendedUnitState(parent, which, cdUnit);
            float logInsertionProbability = unitState.getUnit().isSilence() ? FlatLinguist.this.logSilenceInsertionProbability : (unitState.getUnit().isFiller() ? FlatLinguist.this.logFillerInsertionProbability : (unitState.getWhich() == 0 ? FlatLinguist.this.logWordInsertionProbability : FlatLinguist.this.logUnitInsertionProbability));
            SentenceHMMState existingState = this.getExistingState(unitState);
            if (existingState != null) {
                this.attachState(tail, existingState, logOne, logInsertionProbability);
                return null;
            }
            this.attachState(tail, unitState, logOne, logInsertionProbability);
            this.addStateToCache(unitState);
            tail = this.expandUnit(unitState);
            if (unitState.isLast()) {
                UnitContext nextLeftContext = this.generateNextLeftContext(leftContext, units[which]);
                ContextPair cp = ContextPair.get(nextLeftContext, actualRightContext);
                this.addExitPoint(cp, tail);
            }
            return tail;
        }

        private void addExitPoint(ContextPair cp, SentenceHMMState state) {
            List<SearchState> list = this.exitPoints.get(cp);
            if (list == null) {
                list = new ArrayList<SearchState>();
                this.exitPoints.put(cp, list);
            }
            list.add(state);
        }

        private Unit[] getLC(UnitContext left, Unit[] units, int index) {
            Unit[] leftUnits = left.getUnits();
            int curSize = leftUnits.length + index;
            int actSize = Math.min(curSize, this.getLeftContextSize(units[index]));
            int leftIndex = index - actSize;
            Unit[] lc = new Unit[actSize];
            for (int i = 0; i < lc.length; ++i) {
                int lcIndex = leftIndex + i;
                lc[i] = lcIndex < 0 ? leftUnits[leftUnits.length + lcIndex] : units[lcIndex];
            }
            return lc;
        }

        private Unit[] getRC(Unit[] units, int index, UnitContext right) {
            Unit[] rightUnits = right.getUnits();
            int leftIndex = index + 1;
            int curSize = units.length - leftIndex + rightUnits.length;
            int actSize = Math.min(curSize, this.getRightContextSize(units[index]));
            Unit[] rc = new Unit[actSize];
            for (int i = 0; i < rc.length; ++i) {
                int rcIndex = leftIndex + i;
                rc[i] = rcIndex < units.length ? units[rcIndex] : rightUnits[rcIndex - units.length];
            }
            return rc;
        }

        private int getLeftContextSize(Unit unit) {
            return unit.isFiller() ? 0 : this.getLeftContextSize();
        }

        private int getRightContextSize(Unit unit) {
            return unit.isFiller() ? 0 : this.getRightContextSize();
        }

        protected int getLeftContextSize() {
            return FlatLinguist.this.acousticModel.getLeftContextSize();
        }

        protected int getRightContextSize() {
            return FlatLinguist.this.acousticModel.getRightContextSize();
        }

        UnitContext generateNextLeftContext(UnitContext prevLeftContext, Unit unit) {
            Unit[] prevUnits = prevLeftContext.getUnits();
            int actSize = Math.min(prevUnits.length, this.getLeftContextSize());
            if (actSize == 0) {
                return UnitContext.EMPTY;
            }
            Unit[] leftUnits = Arrays.copyOfRange(prevUnits, 1, actSize + 1);
            leftUnits[actSize - 1] = unit;
            return UnitContext.get(leftUnits);
        }

        protected SentenceHMMState expandUnit(UnitState unit) {
            HMMStateState tail = this.getHMMStates(unit);
            if (unit.getUnit().isSilence()) {
                this.attachState(tail, unit, logOne, FlatLinguist.this.logSilenceInsertionProbability);
            }
            return tail;
        }

        private HMMStateState getHMMStates(UnitState unitState) {
            Unit unit = unitState.getUnit();
            HMMPosition position = unitState.getPosition();
            HMM hmm = FlatLinguist.this.acousticModel.lookupNearestHMM(unit, position, false);
            HMMState initialState = hmm.getInitialState();
            HMMStateState hmmTree = new HMMStateState(unitState, initialState);
            this.attachState(unitState, hmmTree, logOne, logOne);
            this.addStateToCache(hmmTree);
            HMMStateState finalState = this.expandHMMTree(unitState, hmmTree);
            return finalState;
        }

        private HMMStateState expandHMMTree(UnitState parent, HMMStateState tree) {
            HMMStateState retState = tree;
            for (HMMStateArc arc : tree.getHMMState().getSuccessors()) {
                HMMStateState newState = arc.getHMMState().isEmitting() ? new HMMStateState(parent, arc.getHMMState()) : new NonEmittingHMMState(parent, arc.getHMMState());
                SentenceHMMState existingState = this.getExistingState(newState);
                float logProb = arc.getLogProbability();
                if (existingState != null) {
                    this.attachState(tree, existingState, logOne, logProb);
                    continue;
                }
                this.attachState(tree, newState, logOne, logProb);
                this.addStateToCache(newState);
                retState = this.expandHMMTree(parent, newState);
            }
            return retState;
        }

        public void connect() {
            for (GrammarArc arc : this.getSuccessors()) {
                GState gstate = FlatLinguist.this.getGState(arc.getGrammarNode());
                if (!gstate.getNode().isEmpty() && gstate.getNode().getWord().getSpelling().equals("<s>")) continue;
                float probability = arc.getProbability();
                if (FlatLinguist.this.spreadWordProbabilitiesAcrossPronunciations && !gstate.getNode().isEmpty()) {
                    int numPronunciations = gstate.getNode().getWord().getPronunciations(null).length;
                    probability -= FlatLinguist.this.logMath.linearToLog(numPronunciations);
                }
                float fprob = probability;
                for (Map.Entry<ContextPair, List<SearchState>> entry : this.exitPoints.entrySet()) {
                    List<SearchState> destEntryPoints = gstate.getEntryPoints(entry.getKey());
                    if (destEntryPoints == null) continue;
                    List<SearchState> srcExitPoints = entry.getValue();
                    this.connect(srcExitPoints, destEntryPoints, fprob);
                }
            }
        }

        private void connect(List<SearchState> sourceList, List<SearchState> destList, float logLangProb) {
            for (SearchState source : sourceList) {
                SentenceHMMState sourceState = (SentenceHMMState)source;
                for (SearchState dest : destList) {
                    SentenceHMMState destState = (SentenceHMMState)dest;
                    sourceState.connect(FlatLinguist.this.getArc(destState, logLangProb, logOne));
                    ++this.exitConnections;
                }
            }
        }

        protected void attachState(SentenceHMMState prevState, SentenceHMMState nextState, float logLanguageProbablity, float logInsertionProbablity) {
            prevState.connect(FlatLinguist.this.getArc(nextState, logLanguageProbablity, logInsertionProbablity));
            if (FlatLinguist.this.showCompilationProgress && FlatLinguist.this.totalStateCounter++ % 1000 == 0) {
                System.out.print(".");
            }
        }

        public Collection<SearchState> getStates() {
            ArrayList<SearchState> allStates = new ArrayList<SearchState>(this.existingStates.values());
            for (List<SearchState> list : this.entryPoints.values()) {
                allStates.addAll(list);
            }
            return allStates;
        }

        private SentenceHMMState getExistingState(SentenceHMMState state) {
            return this.existingStates.get(state.getSignature());
        }

        private void addStateToCache(SentenceHMMState state) {
            this.existingStates.put(state.getSignature(), state);
        }

        void dumpInfo() {
            System.out.println(" ==== " + this + " ========");
            System.out.print("Node: " + this.node);
            if (this.node.isEmpty()) {
                System.out.print("  (Empty)");
            } else {
                System.out.print(" " + this.node.getWord());
            }
            System.out.print(" ep: " + this.entryPoints.size());
            System.out.print(" exit: " + this.exitPoints.size());
            System.out.print(" cons: " + this.exitConnections);
            System.out.print(" tot: " + this.getStates().size());
            System.out.print(" sc: " + this.getStartingContexts().size());
            System.out.print(" rc: " + this.leftContexts.size());
            System.out.println(" lc: " + this.rightContexts.size());
            this.dumpDetails();
        }

        void dumpDetails() {
            this.dumpCollection(" entryPoints", this.entryPoints.keySet());
            this.dumpCollection(" entryPoints states", this.entryPoints.values());
            this.dumpCollection(" exitPoints", this.exitPoints.keySet());
            this.dumpCollection(" exitPoints states", this.exitPoints.values());
            this.dumpNextNodes();
            this.dumpExitPoints(this.exitPoints.values());
            this.dumpCollection(" startingContexts", this.getStartingContexts());
            this.dumpCollection(" branchingInFrom", this.leftContexts);
            this.dumpCollection(" branchingOutTo", this.rightContexts);
            this.dumpCollection(" existingStates", this.existingStates.keySet());
        }

        private void dumpNextNodes() {
            System.out.println("     Next Grammar Nodes: ");
            for (GrammarArc arc : this.node.getSuccessors()) {
                System.out.println("          " + arc.getGrammarNode());
            }
        }

        private void dumpExitPoints(Collection<List<SearchState>> eps) {
            for (List<SearchState> epList : eps) {
                for (SearchState state : epList) {
                    System.out.println("      Arcs from: " + state);
                    for (SearchStateArc arc : state.getSuccessors()) {
                        System.out.println("          " + arc.getState());
                    }
                }
            }
        }

        private void dumpCollection(String name, Collection<?> collection) {
            System.out.println("     " + name);
            for (Object obj : collection) {
                System.out.println("         " + obj);
            }
        }

        public String toString() {
            if (this.node.isEmpty()) {
                return "GState " + this.node + "(empty)";
            }
            return "GState " + this.node + " word " + this.node.getWord();
        }
    }

    protected class FlatSearchGraph
    implements SearchGraph {
        private final SearchState initialState;

        public FlatSearchGraph(SearchState initialState) {
            this.initialState = initialState;
        }

        @Override
        public SearchState getInitialState() {
            return this.initialState;
        }

        @Override
        public int getNumStateOrder() {
            return 7;
        }
    }
}

