/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.dictionary;

import edu.cmu.sphinx.linguist.acoustic.Context;
import edu.cmu.sphinx.linguist.acoustic.Unit;
import edu.cmu.sphinx.linguist.acoustic.UnitManager;
import edu.cmu.sphinx.linguist.dictionary.Dictionary;
import edu.cmu.sphinx.linguist.dictionary.Pronunciation;
import edu.cmu.sphinx.linguist.dictionary.Word;
import edu.cmu.sphinx.linguist.dictionary.WordClassification;
import edu.cmu.sphinx.util.ExtendedStreamTokenizer;
import edu.cmu.sphinx.util.Timer;
import edu.cmu.sphinx.util.TimerPool;
import edu.cmu.sphinx.util.props.ConfigurationManagerUtils;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;

public class FullDictionary
implements Dictionary {
    private Logger logger;
    protected boolean addSilEndingPronunciation;
    private boolean allowMissingWords;
    private boolean createMissingWords;
    private String wordReplacement;
    private URL wordDictionaryFile;
    private URL fillerDictionaryFile;
    private boolean allocated;
    private UnitManager unitManager;
    protected List<URL> addendaUrlList;
    private Map<String, Word> wordDictionary;
    private Map<String, Word> fillerDictionary;
    private Timer loadTimer;

    public FullDictionary(URL wordDictionaryFile, URL fillerDictionaryFile, List<URL> addendaUrlList, boolean addSilEndingPronunciation, String wordReplacement, boolean allowMissingWords, boolean createMissingWords, UnitManager unitManager) {
        this.logger = Logger.getLogger(this.getClass().getName());
        this.wordDictionaryFile = wordDictionaryFile;
        this.fillerDictionaryFile = fillerDictionaryFile;
        this.addendaUrlList = addendaUrlList;
        this.addSilEndingPronunciation = addSilEndingPronunciation;
        this.wordReplacement = wordReplacement;
        this.allowMissingWords = allowMissingWords;
        this.createMissingWords = createMissingWords;
        this.unitManager = unitManager;
    }

    public FullDictionary() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        this.logger = ps.getLogger();
        this.wordDictionaryFile = ConfigurationManagerUtils.getResource("dictionaryPath", ps);
        this.fillerDictionaryFile = ConfigurationManagerUtils.getResource("fillerPath", ps);
        this.addendaUrlList = ps.getResourceList("addenda");
        this.addSilEndingPronunciation = ps.getBoolean("addSilEndingPronunciation");
        this.wordReplacement = ps.getString("wordReplacement");
        this.allowMissingWords = ps.getBoolean("allowMissingWords");
        this.createMissingWords = ps.getBoolean("createMissingWords");
        this.unitManager = (UnitManager)ps.getComponent("unitManager");
    }

    @Override
    public void allocate() throws IOException {
        if (!this.allocated) {
            this.loadTimer = TimerPool.getTimer(this, "Load Dictionary");
            this.loadTimer.start();
            this.logger.info("Loading dictionary from: " + this.wordDictionaryFile);
            this.wordDictionary = this.loadDictionary(this.wordDictionaryFile.openStream(), false);
            this.loadCustomDictionaries(this.addendaUrlList);
            this.logger.info("Loading filler dictionary from: " + this.fillerDictionaryFile);
            this.fillerDictionary = this.loadDictionary(this.fillerDictionaryFile.openStream(), true);
            this.loadTimer.stop();
            this.logger.finest(this.dumpToString());
            this.allocated = true;
        }
    }

    @Override
    public void deallocate() {
        if (this.allocated) {
            this.fillerDictionary = null;
            this.wordDictionary = null;
            this.loadTimer = null;
            this.allocated = false;
        }
    }

    protected Map<String, Word> loadDictionary(InputStream inputStream, boolean isFillerDict) throws IOException {
        String word;
        HashMap<String, List<Pronunciation>> dictPronunciations = new HashMap<String, List<Pronunciation>>();
        ExtendedStreamTokenizer est = new ExtendedStreamTokenizer(inputStream, true);
        while ((word = est.getString()) != null) {
            String unitText;
            word = this.removeParensFromWord(word);
            word = word.toLowerCase();
            ArrayList<Unit> units = new ArrayList<Unit>(20);
            LinkedList<Pronunciation> pronunciations = (LinkedList<Pronunciation>)dictPronunciations.get(word);
            if (pronunciations == null) {
                pronunciations = new LinkedList<Pronunciation>();
            }
            while ((unitText = est.getString()) != null) {
                units.add(this.getCIUnit(unitText, isFillerDict));
            }
            pronunciations.add(new Pronunciation(units));
            if (!isFillerDict && this.addSilEndingPronunciation) {
                units.add(UnitManager.SILENCE);
                pronunciations.add(new Pronunciation(units));
            }
            dictPronunciations.put(word, pronunciations);
        }
        inputStream.close();
        est.close();
        return this.createWords(dictPronunciations, isFillerDict);
    }

    protected HashMap<String, Word> createWords(Map<String, List<Pronunciation>> pronunciationList, boolean isFillerDict) {
        HashMap<String, Word> result = new HashMap<String, Word>();
        for (Map.Entry<String, List<Pronunciation>> entry : pronunciationList.entrySet()) {
            String spelling = entry.getKey();
            List<Pronunciation> pronunciations = entry.getValue();
            Pronunciation[] pros = new Pronunciation[pronunciations.size()];
            pronunciations.toArray(pros);
            Word word = new Word(spelling, pros, isFillerDict);
            for (Pronunciation pro : pros) {
                pro.setWord(word);
            }
            result.put(spelling, word);
        }
        return result;
    }

    protected Unit getCIUnit(String name, boolean isFiller) {
        return this.unitManager.getUnit(name, isFiller, Context.EMPTY_CONTEXT);
    }

    protected String removeParensFromWord(String word) {
        int index;
        if (word.charAt(word.length() - 1) == ')' && (index = word.lastIndexOf(40)) > 0) {
            word = word.substring(0, index);
        }
        return word;
    }

    @Override
    public Word getWord(String text) {
        Word word = this.lookupWord(text = text.toLowerCase());
        if (word == null) {
            this.logger.warning("Missing word: " + text);
            if (this.wordReplacement != null) {
                word = this.lookupWord(this.wordReplacement);
                this.logger.warning("Replacing " + text + " with " + this.wordReplacement);
                if (word == null) {
                    this.logger.severe("Replacement word " + this.wordReplacement + " not found!");
                }
            } else if (this.allowMissingWords) {
                if (this.createMissingWords) {
                    word = new Word(text, null, false);
                    this.wordDictionary.put(text, word);
                }
                return null;
            }
        }
        return word;
    }

    private Word lookupWord(String spelling) {
        Word word = this.wordDictionary.get(spelling);
        if (word == null) {
            word = this.fillerDictionary.get(spelling);
        }
        return word;
    }

    @Override
    public Word getSentenceStartWord() {
        return this.getWord("<s>");
    }

    @Override
    public Word getSentenceEndWord() {
        return this.getWord("</s>");
    }

    @Override
    public Word getSilenceWord() {
        return this.getWord("<sil>");
    }

    @Override
    public WordClassification[] getPossibleWordClassifications() {
        return null;
    }

    public URL getWordDictionaryFile() {
        return this.wordDictionaryFile;
    }

    public URL getFillerDictionaryFile() {
        return this.fillerDictionaryFile;
    }

    public String toString() {
        return super.toString() + "numWords=" + this.wordDictionary.size() + " dictLlocation=" + this.getWordDictionaryFile();
    }

    private String dumpToString() {
        TreeMap<String, Word> sorted = new TreeMap<String, Word>(this.wordDictionary);
        StringBuilder result = new StringBuilder();
        sorted.putAll(this.fillerDictionary);
        for (String text : sorted.keySet()) {
            Word word = this.getWord(text);
            Pronunciation[] pronunciations = word.getPronunciations(null);
            result.append(word).append('\n');
            for (Pronunciation pronunciation : pronunciations) {
                result.append("   ").append(pronunciation).append('\n');
            }
        }
        return result.toString();
    }

    @Override
    public Word[] getFillerWords() {
        return this.fillerDictionary.values().toArray(new Word[this.fillerDictionary.size()]);
    }

    private void loadCustomDictionaries(List<URL> addenda) throws IOException {
        if (addenda != null) {
            for (URL addendumUrl : addenda) {
                this.loadDictionary(addendumUrl.openStream(), false);
            }
        }
    }
}

