/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.acoustic.tiedstate;

import edu.cmu.sphinx.linguist.acoustic.UnitManager;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.Pool;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.Sphinx3Loader;
import edu.cmu.sphinx.util.ExtendedStreamTokenizer;
import edu.cmu.sphinx.util.LogMath;
import edu.cmu.sphinx.util.props.ConfigurationManagerUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SphinxAsciiLoader
extends Sphinx3Loader {
    public SphinxAsciiLoader(URL location, String model, String dataLocation, LogMath logMath, UnitManager unitManager, float distFloor, float mixtureWeightFloor, float varianceFloor, boolean useCDUnits) {
        this.init(location, model, dataLocation, logMath, unitManager, distFloor, mixtureWeightFloor, varianceFloor, useCDUnits, Logger.getLogger(this.getClass().getName()));
    }

    public SphinxAsciiLoader(String location, String model, String dataLocation, LogMath logMath, UnitManager unitManager, float distFloor, float mixtureWeightFloor, float varianceFloor, boolean useCDUnits) throws MalformedURLException, ClassNotFoundException {
        this.init(ConfigurationManagerUtils.resourceToURL(location), model, dataLocation, logMath, unitManager, distFloor, mixtureWeightFloor, varianceFloor, useCDUnits, Logger.getLogger(this.getClass().getName()));
    }

    public SphinxAsciiLoader() {
    }

    @Override
    protected void loadModelFiles(String modelDef) throws IOException, URISyntaxException {
        this.logger.config("Loading Sphinx3 acoustic model: " + modelDef);
        this.logger.config("    modelName: " + this.model);
        this.logger.config("    dataLocation   : " + this.dataLocation);
        this.meansPool = this.loadDensityFile(this.dataLocation + "means.ascii", -3.4028235E38f);
        this.variancePool = this.loadDensityFile(this.dataLocation + "variances.ascii", this.varianceFloor);
        this.mixtureWeightsPool = this.loadMixtureWeights(this.dataLocation + "mixture_weights.ascii", this.mixtureWeightFloor);
        this.transitionsPool = this.loadTransitionMatrices(this.dataLocation + "transition_matrices.ascii");
        this.senonePool = this.createSenonePool(this.distFloor, this.varianceFloor);
        InputStream modelStream = this.getDataStream(this.model);
        if (modelStream == null) {
            throw new IOException("can't find modelDef " + this.model);
        }
        this.loadHMMPool(this.useCDUnits, modelStream, this.model);
    }

    @Override
    protected Pool<float[]> loadDensityFile(String path, float floor) throws IOException, URISyntaxException {
        this.logger.fine("Loading density file from: " + path);
        InputStream inputStream = this.getDataStream(path);
        if (inputStream == null) {
            throw new FileNotFoundException("Error trying to read file " + path);
        }
        ExtendedStreamTokenizer est = new ExtendedStreamTokenizer(inputStream, 35, false);
        Pool<float[]> pool = new Pool<float[]>(path);
        est.expectString("param");
        int numStates = est.getInt("numStates");
        int numStreams = est.getInt("numStreams");
        int numGaussiansPerState = est.getInt("numGaussiansPerState");
        pool.setFeature(Pool.Feature.NUM_SENONES, numStates);
        pool.setFeature(Pool.Feature.NUM_STREAMS, numStreams);
        pool.setFeature(Pool.Feature.NUM_GAUSSIANS_PER_STATE, numGaussiansPerState);
        int vectorLength = 39;
        for (int i = 0; i < numStates; ++i) {
            est.expectString("mgau");
            est.expectInt("mgau index", i);
            est.expectString("feat");
            est.expectInt("feat index", 0);
            for (int j = 0; j < numGaussiansPerState; ++j) {
                est.expectString("density");
                est.expectInt("densityValue", j);
                float[] density = new float[vectorLength];
                for (int k = 0; k < vectorLength; ++k) {
                    density[k] = est.getFloat("val");
                    if (!(density[k] < floor)) continue;
                    density[k] = floor;
                }
                int id = i * numGaussiansPerState + j;
                pool.put(id, density);
            }
        }
        est.close();
        return pool;
    }

    @Override
    protected Pool<float[]> loadMixtureWeights(String path, float floor) throws IOException, URISyntaxException {
        this.logger.fine("Loading mixture weights from: " + path);
        InputStream inputStream = this.getDataStream(path);
        if (inputStream == null) {
            throw new FileNotFoundException("Error trying to read file " + path);
        }
        Pool<float[]> pool = new Pool<float[]>(path);
        ExtendedStreamTokenizer est = new ExtendedStreamTokenizer(inputStream, 35, false);
        est.expectString("mixw");
        int numStates = est.getInt("numStates");
        int numStreams = est.getInt("numStreams");
        int numGaussiansPerState = est.getInt("numGaussiansPerState");
        pool.setFeature(Pool.Feature.NUM_SENONES, numStates);
        pool.setFeature(Pool.Feature.NUM_STREAMS, numStreams);
        pool.setFeature(Pool.Feature.NUM_GAUSSIANS_PER_STATE, numGaussiansPerState);
        for (int i = 0; i < numStates; ++i) {
            est.expectString("mixw");
            est.expectString("[" + i);
            est.expectString("0]");
            float[] logMixtureWeight = new float[numGaussiansPerState];
            for (int j = 0; j < numGaussiansPerState; ++j) {
                float val = est.getFloat("mixwVal");
                if (val < floor) {
                    val = floor;
                }
                logMixtureWeight[j] = val;
            }
            this.logMath.linearToLog(logMixtureWeight);
            pool.put(i, logMixtureWeight);
        }
        est.close();
        return pool;
    }

    @Override
    protected Pool<float[][]> loadTransitionMatrices(String path) throws IOException, URISyntaxException {
        this.logger.fine("Loading transition matrices from: " + path);
        InputStream inputStream = this.getDataStream(path);
        if (inputStream == null) {
            throw new FileNotFoundException("Error trying to read file " + path);
        }
        Pool<float[][]> pool = new Pool<float[][]>(path);
        ExtendedStreamTokenizer est = new ExtendedStreamTokenizer(inputStream, 35, false);
        est.expectString("tmat");
        int numMatrices = est.getInt("numMatrices");
        int numStates = est.getInt("numStates");
        this.logger.fine("with " + numMatrices + " and " + numStates + " states");
        for (int i = 0; i < numMatrices; ++i) {
            est.expectString("tmat");
            est.expectString("[" + i + ']');
            float[][] tmat = new float[numStates][numStates];
            for (int j = 0; j < numStates; ++j) {
                for (int k = 0; k < numStates; ++k) {
                    if (j < numStates - 1 && (k == j || k == j + 1)) {
                        tmat[j][k] = est.getFloat("tmat value");
                    }
                    tmat[j][k] = this.logMath.linearToLog(tmat[j][k]);
                    if (!this.logger.isLoggable(Level.FINE)) continue;
                    this.logger.fine("tmat j " + j + " k " + k + " tm " + tmat[j][k]);
                }
            }
            pool.put(i, tmat);
        }
        est.close();
        return pool;
    }
}

