/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.acoustic.tiedstate;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;

public class PropertiesDumper {
    private final Properties props;

    public static void main(String[] argv) {
        try {
            PropertiesDumper dumper = new PropertiesDumper("model.props");
            System.out.println();
            System.out.println(dumper);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public PropertiesDumper(String propsFile) throws IOException {
        this.props = new Properties();
        this.props.load(this.getClass().getResource(propsFile).openStream());
    }

    public PropertiesDumper(Properties properties) throws IOException {
        this.props = properties;
    }

    public String toString() {
        StringBuilder result = new StringBuilder().append(this.props.get("description")).append('\n');
        ArrayList propnames = Collections.list(this.props.propertyNames());
        ArrayList<String> list = new ArrayList<String>();
        for (Object obj : propnames) {
            if (!(obj instanceof String)) continue;
            list.add((String)obj);
        }
        Collections.sort(list);
        for (String key : list) {
            String value = (String)this.props.get(key);
            result.append("\n\t").append(key).append(": ").append(value);
        }
        result.append('\n');
        return result.toString();
    }
}

