/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.feature;

import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataEndSignal;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.DataStartSignal;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Double;
import edu.cmu.sphinx.util.props.S4Integer;

public class LiveCMN
extends BaseDataProcessor {
    @S4Double(defaultValue=12.0)
    public static final String PROP_INITIAL_MEAN = "initialMean";
    private double initialMean;
    @S4Integer(defaultValue=100)
    public static final String PROP_CMN_WINDOW = "cmnWindow";
    private int cmnWindow;
    @S4Integer(defaultValue=160)
    public static final String PROP_CMN_SHIFT_WINDOW = "shiftWindow";
    private int cmnShiftWindow;
    private double[] currentMean;
    private double[] sum;
    private int numberFrame;

    public LiveCMN(double initialMean, int cmnWindow, int cmnShiftWindow) {
        this.initLogger();
        this.initialMean = initialMean;
        this.cmnWindow = cmnWindow;
        this.cmnShiftWindow = cmnShiftWindow;
    }

    public LiveCMN() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        super.newProperties(ps);
        this.initialMean = ps.getDouble(PROP_INITIAL_MEAN);
        this.cmnWindow = ps.getInt(PROP_CMN_WINDOW);
        this.cmnShiftWindow = ps.getInt(PROP_CMN_SHIFT_WINDOW);
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    private void initMeansSums(int cepstrumLength) {
        this.currentMean = new double[cepstrumLength];
        this.currentMean[0] = this.initialMean;
        if (this.sum == null) {
            this.sum = new double[cepstrumLength];
        }
    }

    @Override
    public Data getData() throws DataProcessingException {
        Data input = this.getPredecessor().getData();
        if (input instanceof DataStartSignal) {
            this.sum = null;
            this.numberFrame = 0;
        }
        this.getTimer().start();
        if (input != null) {
            if (input instanceof DoubleData) {
                DoubleData data = (DoubleData)input;
                if (this.sum == null) {
                    this.initMeansSums(data.getValues().length);
                }
                this.normalize(data);
            } else if (input instanceof DataEndSignal) {
                this.updateMeanSumBuffers();
            }
        }
        this.getTimer().stop();
        return input;
    }

    private void normalize(DoubleData cepstrumObject) {
        double[] cepstrum = cepstrumObject.getValues();
        if (cepstrum.length != this.sum.length) {
            throw new Error("Data length (" + cepstrum.length + ") not equal sum array length (" + this.sum.length + ')');
        }
        for (int j = 0; j < cepstrum.length; ++j) {
            int n = j;
            this.sum[n] = this.sum[n] + cepstrum[j];
            int n2 = j;
            cepstrum[n2] = cepstrum[n2] - this.currentMean[j];
        }
        ++this.numberFrame;
        if (this.numberFrame > this.cmnShiftWindow) {
            this.updateMeanSumBuffers();
        }
    }

    private void updateMeanSumBuffers() {
        if (this.numberFrame > 0) {
            double sf = 1.0 / (double)this.numberFrame;
            System.arraycopy(this.sum, 0, this.currentMean, 0, this.sum.length);
            LiveCMN.multiplyArray(this.currentMean, sf);
            if (this.numberFrame >= this.cmnShiftWindow) {
                LiveCMN.multiplyArray(this.sum, sf * (double)this.cmnWindow);
                this.numberFrame = this.cmnWindow;
            }
        }
    }

    private static void multiplyArray(double[] array, double multiplier) {
        int i = 0;
        while (i < array.length) {
            int n = i++;
            array[n] = array[n] * multiplier;
        }
    }
}

