/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.endpoint;

import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataEndSignal;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.DataStartSignal;
import edu.cmu.sphinx.frontend.endpoint.SpeechEndSignal;
import edu.cmu.sphinx.frontend.endpoint.SpeechStartSignal;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;

public class NonSpeechDataFilter
extends BaseDataProcessor {
    private boolean inSpeech;

    public NonSpeechDataFilter() {
        this.initLogger();
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        super.newProperties(ps);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.inSpeech = false;
    }

    @Override
    public Data getData() throws DataProcessingException {
        Data data = this.readData();
        while (!(data == null || data instanceof DataEndSignal || data instanceof DataStartSignal || data instanceof SpeechEndSignal || this.inSpeech)) {
            data = this.readData();
        }
        return data;
    }

    private Data readData() {
        Data data = this.getPredecessor().getData();
        if (data instanceof SpeechStartSignal) {
            this.inSpeech = true;
        }
        if (data instanceof SpeechEndSignal) {
            this.inSpeech = false;
        }
        return data;
    }
}

