/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.decoder.search;

import edu.cmu.sphinx.decoder.search.ActiveList;
import edu.cmu.sphinx.util.LogMath;
import edu.cmu.sphinx.util.props.Configurable;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4Component;
import edu.cmu.sphinx.util.props.S4Double;
import edu.cmu.sphinx.util.props.S4Integer;

public abstract class ActiveListFactory
implements Configurable {
    @S4Component(type=LogMath.class)
    public static final String PROP_LOG_MATH = "logMath";
    @S4Integer(defaultValue=-1)
    public static final String PROP_ABSOLUTE_BEAM_WIDTH = "absoluteBeamWidth";
    @S4Double(defaultValue=1.0E-80)
    public static final String PROP_RELATIVE_BEAM_WIDTH = "relativeBeamWidth";
    @S4Boolean(defaultValue=true)
    public static final String PROP_STRICT_PRUNING = "strictPruning";
    protected int absoluteBeamWidth;
    protected float logRelativeBeamWidth;

    public ActiveListFactory(int absoluteBeamWidth, double relativeBeamWidth, LogMath logMath) {
        this.absoluteBeamWidth = absoluteBeamWidth;
        this.logRelativeBeamWidth = logMath.linearToLog(relativeBeamWidth);
    }

    public ActiveListFactory() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        this.absoluteBeamWidth = ps.getInt(PROP_ABSOLUTE_BEAM_WIDTH);
        double relativeBeamWidth = ps.getDouble(PROP_RELATIVE_BEAM_WIDTH);
        LogMath logMath = (LogMath)ps.getComponent(PROP_LOG_MATH);
        this.logRelativeBeamWidth = logMath.linearToLog(relativeBeamWidth);
    }

    public abstract ActiveList newInstance();
}

