/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.os.DynamicLookupHelper;
import com.jogamp.common.os.MachineDescription;
import com.jogamp.gluegen.ArrayTypes;
import com.jogamp.gluegen.CMethodBindingEmitter;
import com.jogamp.gluegen.CodeGenUtils;
import com.jogamp.gluegen.ConstantDefinition;
import com.jogamp.gluegen.FunctionEmitter;
import com.jogamp.gluegen.GlueEmitter;
import com.jogamp.gluegen.GlueEmitterControls;
import com.jogamp.gluegen.GlueGen;
import com.jogamp.gluegen.JavaConfiguration;
import com.jogamp.gluegen.JavaMethodBindingEmitter;
import com.jogamp.gluegen.JavaType;
import com.jogamp.gluegen.MethodBinding;
import com.jogamp.gluegen.SymbolFilter;
import com.jogamp.gluegen.TypeInfo;
import com.jogamp.gluegen.cgram.types.CompoundType;
import com.jogamp.gluegen.cgram.types.Field;
import com.jogamp.gluegen.cgram.types.FunctionSymbol;
import com.jogamp.gluegen.cgram.types.FunctionType;
import com.jogamp.gluegen.cgram.types.PointerType;
import com.jogamp.gluegen.cgram.types.SizeThunk;
import com.jogamp.gluegen.cgram.types.StructLayout;
import com.jogamp.gluegen.cgram.types.Type;
import com.jogamp.gluegen.cgram.types.TypeDictionary;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.Buffer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jogamp.common.os.MachineDescriptionRuntime;

public class JavaEmitter
implements GlueEmitter {
    private StructLayout layout;
    private TypeDictionary typedefDictionary;
    private Map<Type, Type> canonMap;
    protected JavaConfiguration cfg;
    private PrintWriter javaWriter;
    private PrintWriter javaImplWriter;
    private PrintWriter cWriter;
    private final MachineDescription machDescJava;
    private final MachineDescription.StaticConfig[] machDescTargetConfigs;
    protected static final Logger LOG = Logger.getLogger(JavaEmitter.class.getPackage().getName());

    public JavaEmitter() {
        this.machDescJava = MachineDescription.StaticConfig.X86_64_UNIX.md;
        this.machDescTargetConfigs = MachineDescription.StaticConfig.values();
    }

    @Override
    public void readConfigurationFile(String string) throws Exception {
        this.cfg = this.createConfig();
        this.cfg.read(string);
    }

    @Override
    public void beginEmission(GlueEmitterControls glueEmitterControls) throws IOException {
        for (String string : this.cfg.forcedStructs()) {
            glueEmitterControls.forceStructEmission(string);
        }
        if (!this.cfg.structsOnly()) {
            try {
                this.openWriters();
            }
            catch (Exception exception) {
                throw new RuntimeException("Unable to open files for writing", exception);
            }
            this.emitAllFileHeaders();
            glueEmitterControls.runSymbolFilter(new ConstantRenamer());
        }
    }

    @Override
    public void endEmission() {
        if (!this.cfg.structsOnly()) {
            this.emitAllFileFooters();
            try {
                this.closeWriters();
            }
            catch (Exception exception) {
                throw new RuntimeException("Unable to close open files", exception);
            }
        }
    }

    @Override
    public void beginDefines() throws Exception {
        if ((this.cfg.allStatic() || this.cfg.emitInterface()) && !this.cfg.structsOnly()) {
            this.javaWriter().println();
        }
    }

    protected static int getJavaRadix(String string, String string2) {
        try {
            String string3;
            int n;
            if (string2.startsWith("0x") || string2.startsWith("0X")) {
                n = 16;
                string3 = string2.substring(2);
            } else if (string2.startsWith("0") && string2.length() > 1) {
                n = 8;
                string3 = string2.substring(1);
            } else {
                n = 10;
                string3 = string2;
            }
            Long.parseLong(string3, n);
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            try {
                Double.parseDouble(string2);
                return 10;
            }
            catch (NumberFormatException numberFormatException2) {
                throw new RuntimeException("Cannot emit define \"" + string + "\": value \"" + string2 + "\" cannot be assigned to a int, long, float, or double", numberFormatException2);
            }
        }
    }

    protected static Object getJavaValue(String string, String string2) {
        Scanner scanner = new Scanner(string2).useDelimiter("[+-/*/></(/)]");
        Object object = null;
        while (scanner.hasNext()) {
            String string3 = scanner.next().trim();
            if (0 >= string3.length()) continue;
            Object object2 = JavaEmitter.getJavaValue2(string, string3);
            if (object2 instanceof Double) {
                return object2;
            }
            if (object != null) {
                if (object instanceof Integer) {
                    if (object2 instanceof Long || object2 instanceof Float || object2 instanceof Double) {
                        object = object2;
                    }
                } else if (object instanceof Long) {
                    if (object2 instanceof Float || object2 instanceof Double) {
                        object = object2;
                    }
                } else if (object instanceof Float && object2 instanceof Float) {
                    object = object2;
                }
            } else {
                object = object2;
            }
            if (!(object instanceof Double)) continue;
            return object2;
        }
        return object;
    }

    private static Object getJavaValue2(String string, String string2) {
        char c = string2.charAt(string2.length() - 1);
        try {
            long l;
            String string3;
            int n;
            if (string2.startsWith("0x") || string2.startsWith("0X")) {
                n = 16;
                string3 = string2.substring(2);
            } else if (string2.startsWith("0") && string2.length() > 1) {
                n = 8;
                string3 = string2.substring(1);
            } else {
                n = 10;
                string3 = string2;
            }
            if (c == 'u' || c == 'U') {
                string3 = string3.substring(0, string3.length() - 1);
            }
            if ((l = Long.parseLong(string3, n)) > Integer.MIN_VALUE && l < Integer.MAX_VALUE) {
                return (int)l;
            }
            return l;
        }
        catch (NumberFormatException numberFormatException) {
            try {
                double d = Double.parseDouble(string2);
                double d2 = Math.abs(d);
                if (d2 < (double)1.4E-45f || d2 > 3.4028234663852886E38) {
                    return new Double(d);
                }
                return new Float((float)d);
            }
            catch (NumberFormatException numberFormatException2) {
                throw new RuntimeException("Cannot emit define \"" + string + "\": value \"" + string2 + "\" cannot be assigned to a int, long, float, or double", numberFormatException2);
            }
        }
    }

    protected static String getJavaType(String string, String string2) {
        Object object = JavaEmitter.getJavaValue(string, string2);
        return JavaEmitter.getJavaType(string, object);
    }

    protected static String getJavaType(String string, Object object) {
        if (object instanceof Integer) {
            return "int";
        }
        if (object instanceof Long) {
            return "long";
        }
        if (object instanceof Float) {
            return "float";
        }
        if (object instanceof Double) {
            return "double";
        }
        throw new RuntimeException("Cannot emit define (2) \"" + string + "\": value \"" + object + "\" cannot be assigned to a int, long, float, or double");
    }

    @Override
    public void emitDefine(ConstantDefinition constantDefinition, String string) throws Exception {
        if (this.cfg.allStatic() || this.cfg.emitInterface()) {
            String string2 = constantDefinition.getName();
            String string3 = constantDefinition.getValue();
            if (!this.cfg.shouldIgnoreInInterface(string2)) {
                String string4 = JavaEmitter.getJavaType(string2, string3);
                if (string != null && string.length() != 0) {
                    this.javaWriter().println("  /** " + string + " */");
                }
                String string5 = "";
                if (!string3.endsWith(")")) {
                    if (string4.equals("float") && !string3.endsWith("f")) {
                        string5 = "f";
                    } else if (string3.endsWith("u") || string3.endsWith("U")) {
                        string3 = string3.substring(0, string3.length() - 1);
                    }
                }
                this.javaWriter().println("  public static final " + string4 + " " + string2 + " = " + string3 + string5 + ";");
            }
        }
    }

    @Override
    public void endDefines() throws Exception {
    }

    @Override
    public void beginFunctions(TypeDictionary typeDictionary, TypeDictionary typeDictionary2, Map<Type, Type> map) throws Exception {
        this.typedefDictionary = typeDictionary;
        this.canonMap = map;
        if ((this.cfg.allStatic() || this.cfg.emitInterface()) && !this.cfg.structsOnly()) {
            this.javaWriter().println();
        }
    }

    @Override
    public Iterator<FunctionSymbol> emitFunctions(List<FunctionSymbol> list) throws Exception {
        HashSet<FunctionSymbol> hashSet = new HashSet<FunctionSymbol>(100);
        for (FunctionSymbol object2 : list) {
            if (hashSet.contains(object2)) continue;
            hashSet.add(object2);
        }
        ArrayList arrayList = new ArrayList(hashSet);
        Collections.sort(arrayList, new Comparator<FunctionSymbol>(){

            @Override
            public int compare(FunctionSymbol functionSymbol, FunctionSymbol functionSymbol2) {
                return functionSymbol.getName().compareTo(functionSymbol2.getName());
            }
        });
        HashSet<MethodBinding> hashSet2 = new HashSet<MethodBinding>();
        ArrayList<? extends FunctionEmitter> arrayList2 = new ArrayList<FunctionEmitter>(2 * arrayList.size());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            FunctionSymbol functionSymbol = (FunctionSymbol)iterator.next();
            if (this.cfg.shouldIgnoreInImpl(functionSymbol.getName())) continue;
            arrayList2.addAll(this.generateMethodBindingEmitters(hashSet2, functionSymbol));
        }
        for (FunctionEmitter functionEmitter : arrayList2) {
            try {
                if (functionEmitter.isInterface() && this.cfg.shouldIgnoreInInterface(functionEmitter.getName())) continue;
                functionEmitter.emit();
                functionEmitter.getDefaultOutput().println();
            }
            catch (Exception exception) {
                throw new RuntimeException("Error while emitting binding for \"" + functionEmitter.getName() + "\"", exception);
            }
        }
        return arrayList.iterator();
    }

    protected JavaConfiguration createConfig() {
        return new JavaConfiguration();
    }

    protected JavaConfiguration getConfig() {
        return this.cfg;
    }

    protected void generatePublicEmitters(MethodBinding methodBinding, List<FunctionEmitter> list, boolean bl) {
        if (this.cfg.manuallyImplement(methodBinding.getName()) && !bl) {
            return;
        }
        MethodAccess methodAccess = this.cfg.accessControl(methodBinding.getName());
        if (bl && methodAccess != MethodAccess.PUBLIC) {
            return;
        }
        PrintWriter printWriter = bl || this.cfg.allStatic() ? this.javaWriter() : this.javaImplWriter();
        boolean bl2 = this.cfg.isUnimplemented(methodBinding.getName());
        List<String> list2 = this.cfg.javaPrologueForMethod(methodBinding, false, false);
        List<String> list3 = this.cfg.javaEpilogueForMethod(methodBinding, false, false);
        boolean bl3 = bl2 || methodBinding.needsNIOWrappingOrUnwrapping() || methodBinding.signatureUsesJavaPrimitiveArrays() || list2 != null || list3 != null;
        JavaMethodBindingEmitter javaMethodBindingEmitter = new JavaMethodBindingEmitter(methodBinding, printWriter, this.cfg.runtimeExceptionType(), this.cfg.unsupportedExceptionType(), !bl && bl3, this.cfg.tagNativeBinding(), false, this.cfg.useNIOOnly(methodBinding.getName()), this.cfg.useNIODirectOnly(methodBinding.getName()), false, false, false, bl2, bl, this.cfg);
        switch (methodAccess) {
            case PUBLIC: {
                javaMethodBindingEmitter.addModifier(JavaMethodBindingEmitter.PUBLIC);
                break;
            }
            case PROTECTED: {
                javaMethodBindingEmitter.addModifier(JavaMethodBindingEmitter.PROTECTED);
                break;
            }
            case PRIVATE: {
                javaMethodBindingEmitter.addModifier(JavaMethodBindingEmitter.PRIVATE);
                break;
            }
        }
        if (this.cfg.allStatic()) {
            javaMethodBindingEmitter.addModifier(JavaMethodBindingEmitter.STATIC);
        }
        if (!(bl2 || bl3 || bl)) {
            javaMethodBindingEmitter.addModifier(JavaMethodBindingEmitter.NATIVE);
        }
        javaMethodBindingEmitter.setReturnedArrayLengthExpression(this.cfg.returnedArrayLength(methodBinding.getName()));
        javaMethodBindingEmitter.setPrologue(list2);
        javaMethodBindingEmitter.setEpilogue(list3);
        list.add(javaMethodBindingEmitter);
    }

    protected void generatePrivateEmitters(MethodBinding methodBinding, List<FunctionEmitter> list) {
        Object object;
        boolean bl;
        if (this.cfg.manuallyImplement(methodBinding.getName())) {
            return;
        }
        boolean bl2 = bl = this.cfg.javaPrologueForMethod(methodBinding, false, false) != null || this.cfg.javaEpilogueForMethod(methodBinding, false, false) != null;
        if (!this.cfg.isUnimplemented(methodBinding.getName()) && (methodBinding.needsNIOWrappingOrUnwrapping() || methodBinding.signatureUsesJavaPrimitiveArrays() || bl)) {
            Object object2 = object = this.cfg.allStatic() ? this.javaWriter() : this.javaImplWriter();
            if (!methodBinding.signatureUsesJavaPrimitiveArrays()) {
                JavaMethodBindingEmitter javaMethodBindingEmitter = new JavaMethodBindingEmitter(methodBinding, (PrintWriter)object, this.cfg.runtimeExceptionType(), this.cfg.unsupportedExceptionType(), false, this.cfg.tagNativeBinding(), true, this.cfg.useNIOOnly(methodBinding.getName()), this.cfg.useNIODirectOnly(methodBinding.getName()), true, true, false, false, false, this.cfg);
                javaMethodBindingEmitter.addModifier(JavaMethodBindingEmitter.PRIVATE);
                if (this.cfg.allStatic()) {
                    javaMethodBindingEmitter.addModifier(JavaMethodBindingEmitter.STATIC);
                }
                javaMethodBindingEmitter.addModifier(JavaMethodBindingEmitter.NATIVE);
                javaMethodBindingEmitter.setReturnedArrayLengthExpression(this.cfg.returnedArrayLength(methodBinding.getName()));
                list.add(javaMethodBindingEmitter);
            }
        }
        if (!this.cfg.isUnimplemented(methodBinding.getName()) && !methodBinding.signatureUsesJavaPrimitiveArrays()) {
            object = new CMethodBindingEmitter(methodBinding, this.cWriter(), this.cfg.implPackageName(), this.cfg.implClassName(), true, this.cfg.allStatic(), methodBinding.needsNIOWrappingOrUnwrapping() || bl, !this.cfg.useNIODirectOnly(methodBinding.getName()), this.machDescJava);
            this.prepCEmitter(methodBinding, (CMethodBindingEmitter)object);
            list.add((FunctionEmitter)object);
        }
    }

    protected void prepCEmitter(MethodBinding methodBinding, CMethodBindingEmitter cMethodBindingEmitter) {
        JavaType javaType = methodBinding.getJavaReturnType();
        if (javaType.isNIOBuffer() || javaType.isCompoundTypeWrapper()) {
            String string = this.cfg.returnValueCapacity(methodBinding.getName());
            if (string != null) {
                cMethodBindingEmitter.setReturnValueCapacityExpression(new MessageFormat(string));
            }
        } else if (javaType.isArray() || javaType.isArrayOfCompoundTypeWrappers()) {
            if (javaType.isPrimitiveArray()) {
                throw new RuntimeException("Primitive array return types not yet supported");
            }
            String string = this.cfg.returnValueLength(methodBinding.getName());
            if (string != null) {
                cMethodBindingEmitter.setReturnValueLengthExpression(new MessageFormat(string));
            }
        }
        cMethodBindingEmitter.setTemporaryCVariableDeclarations(this.cfg.temporaryCVariableDeclarations(methodBinding.getName()));
        cMethodBindingEmitter.setTemporaryCVariableAssignments(this.cfg.temporaryCVariableAssignments(methodBinding.getName()));
    }

    protected List<? extends FunctionEmitter> generateMethodBindingEmitters(Set<MethodBinding> set, FunctionSymbol functionSymbol) throws Exception {
        ArrayList<FunctionEmitter> arrayList = new ArrayList<FunctionEmitter>();
        try {
            MethodBinding methodBinding = this.bindFunction(functionSymbol, null, null, this.machDescJava);
            List<MethodBinding> list = this.expandMethodBinding(methodBinding);
            for (MethodBinding methodBinding2 : list) {
                if (!set.add(methodBinding2)) continue;
                if (this.cfg.allStatic() && methodBinding2.hasContainingType()) {
                    throw new IllegalArgumentException("Cannot create binding in AllStatic mode because method has containing type: \"" + methodBinding2 + "\"");
                }
                if (this.cfg.emitInterface()) {
                    this.generatePublicEmitters(methodBinding2, arrayList, true);
                }
                if (!this.cfg.emitImpl()) continue;
                this.generatePublicEmitters(methodBinding2, arrayList, false);
                this.generatePrivateEmitters(methodBinding2, arrayList);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Error while generating bindings for \"" + functionSymbol + "\"", exception);
        }
        return arrayList;
    }

    @Override
    public void endFunctions() throws Exception {
        if (!this.cfg.structsOnly()) {
            if (this.cfg.allStatic() || this.cfg.emitInterface()) {
                this.emitCustomJavaCode(this.javaWriter(), this.cfg.className());
            }
            if (!this.cfg.allStatic() && this.cfg.emitImpl()) {
                this.emitCustomJavaCode(this.javaImplWriter(), this.cfg.implClassName());
            }
        }
    }

    @Override
    public void beginStructLayout() throws Exception {
    }

    @Override
    public void layoutStruct(CompoundType compoundType) throws Exception {
        this.getLayout().layout(compoundType);
    }

    @Override
    public void endStructLayout() throws Exception {
    }

    @Override
    public void beginStructs(TypeDictionary typeDictionary, TypeDictionary typeDictionary2, Map<Type, Type> map) throws Exception {
        this.typedefDictionary = typeDictionary;
        this.canonMap = map;
    }

    @Override
    public void emitStruct(CompoundType compoundType, String string) throws Exception {
        Object object;
        String string2;
        String string3;
        Type type;
        int n;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        String string4 = compoundType.getName();
        if (string4 == null && string != null) {
            string4 = string;
        }
        if (string4 == null) {
            LOG.log(Level.WARNING, "skipping emission of unnamed struct \"{0}\"", compoundType);
            return;
        }
        if (this.cfg.shouldIgnoreInInterface(string4)) {
            return;
        }
        Type type2 = this.canonicalize(new PointerType(SizeThunk.POINTER, compoundType, 0));
        JavaType javaType = this.typeToJavaType(type2, false, null);
        if (!javaType.isCompoundTypeWrapper()) {
            return;
        }
        String string5 = javaType.getName();
        boolean bl = false;
        for (int i = 0; i < compoundType.getNumFields(); ++i) {
            if (!compoundType.getField(i).getType().isFunctionPointer()) continue;
            bl = true;
            break;
        }
        String string6 = this.cfg.packageForStruct(string4);
        PrintWriter printWriter = null;
        PrintWriter printWriter2 = null;
        try {
            printWriter = this.openFile(this.cfg.javaOutputDir() + File.separator + CodeGenUtils.packageAsPath(string6) + File.separator + string5 + ".java", string5);
            CodeGenUtils.emitAutogeneratedWarning(printWriter, this);
            if (bl) {
                object5 = this.cfg.nativeOutputDir();
                if (this.cfg.nativeOutputUsesJavaHierarchy()) {
                    object5 = (String)object5 + File.separator + CodeGenUtils.packageAsPath(this.cfg.packageName());
                }
                printWriter2 = this.openFile((String)object5 + File.separator + string5 + "_JNI.c", string5);
                CodeGenUtils.emitAutogeneratedWarning(printWriter2, this);
                this.emitCHeader(printWriter2, string5);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to open files for emission of struct class", exception);
        }
        printWriter.println();
        printWriter.println("package " + string6 + ";");
        printWriter.println();
        printWriter.println("import java.nio.*;");
        printWriter.println();
        printWriter.println("import " + this.cfg.gluegenRuntimePackage() + ".*;");
        printWriter.println("import " + DynamicLookupHelper.class.getPackage().getName() + ".*;");
        printWriter.println("import " + Buffers.class.getPackage().getName() + ".*;");
        printWriter.println("import " + MachineDescriptionRuntime.class.getName() + ";");
        printWriter.println();
        object5 = this.cfg.imports();
        Object object6 = object5.iterator();
        while (object6.hasNext()) {
            object4 = (String)object6.next();
            printWriter.print("import ");
            printWriter.print((String)object4);
            printWriter.println(";");
        }
        printWriter.println();
        object6 = this.cfg.javadocForClass(string5);
        object4 = object6.iterator();
        while (object4.hasNext()) {
            object3 = (String)object4.next();
            printWriter.println((String)object3);
        }
        printWriter.print("public class " + string5 + " ");
        boolean bl2 = true;
        object3 = this.cfg.implementedInterfaces(string5);
        Iterator iterator = object3.iterator();
        while (iterator.hasNext()) {
            object2 = (String)iterator.next();
            if (bl2) {
                printWriter.print("implements ");
            }
            bl2 = false;
            printWriter.print((String)object2);
            printWriter.print(" ");
        }
        printWriter.println("{");
        printWriter.println();
        printWriter.println("  StructAccessor accessor;");
        printWriter.println();
        printWriter.println("  private static final int mdIdx = MachineDescriptionRuntime.getStatic().ordinal();");
        printWriter.println();
        this.generateOffsetAndSizeArrays(printWriter, string5, compoundType, null);
        for (n = 0; n < compoundType.getNumFields(); ++n) {
            object2 = compoundType.getField(n);
            type = ((Field)object2).getType();
            if (this.cfg.shouldIgnoreInInterface(string4 + " " + ((Field)object2).getName())) continue;
            string3 = this.cfg.getJavaSymbolRename(((Field)object2).getName());
            String string7 = string2 = string3 == null ? ((Field)object2).getName() : string3;
            if (type.isFunctionPointer()) continue;
            if (type.isCompound()) {
                if (type.getName() == null) {
                    throw new RuntimeException("Anonymous structs as fields not supported yet (field \"" + object2 + "\" in type \"" + string4 + "\")");
                }
                this.generateOffsetAndSizeArrays(printWriter, string2, type, (Field)object2);
                continue;
            }
            if (type.isArray()) {
                object = ((Field)object2).getType().asArray().getBaseElementType();
                if (!((Type)object).isPrimitive()) break;
                this.generateOffsetAndSizeArrays(printWriter, string2, null, (Field)object2);
                continue;
            }
            object = null;
            try {
                object = this.typeToJavaType(type, false, this.machDescJava);
            }
            catch (Exception exception) {
                System.err.println("Error occurred while creating accessor for field \"" + ((Field)object2).getName() + "\" in type \"" + string4 + "\"");
                throw exception;
            }
            if (((JavaType)object).isPrimitive()) {
                this.generateOffsetAndSizeArrays(printWriter, string2, null, (Field)object2);
                continue;
            }
            LOG.log(Level.WARNING, "Complicated fields (field \"{0}\" of type \"{1}\") not implemented yet", new Object[]{object2, string4});
        }
        printWriter.println();
        printWriter.println("  public static int size() {");
        printWriter.println("    return " + string5 + "_size[mdIdx];");
        printWriter.println("  }");
        printWriter.println();
        printWriter.println("  public static " + string5 + " create() {");
        printWriter.println("    return create(Buffers.newDirectByteBuffer(size()));");
        printWriter.println("  }");
        printWriter.println();
        printWriter.println("  public static " + string5 + " create(java.nio.ByteBuffer buf) {");
        printWriter.println("      return new " + string5 + "(buf);");
        printWriter.println("  }");
        printWriter.println();
        printWriter.println("  " + string5 + "(java.nio.ByteBuffer buf) {");
        printWriter.println("    accessor = new StructAccessor(buf);");
        printWriter.println("  }");
        printWriter.println();
        printWriter.println("  public java.nio.ByteBuffer getBuffer() {");
        printWriter.println("    return accessor.getBuffer();");
        printWriter.println("  }");
        for (n = 0; n < compoundType.getNumFields(); ++n) {
            Object object7;
            Object object8;
            Object object9;
            Object object10;
            object2 = compoundType.getField(n);
            type = ((Field)object2).getType();
            if (this.cfg.shouldIgnoreInInterface(string4 + " " + ((Field)object2).getName())) continue;
            string3 = this.cfg.getJavaSymbolRename(((Field)object2).getName());
            String string8 = string2 = string3 == null ? ((Field)object2).getName() : string3;
            if (type.isFunctionPointer()) {
                try {
                    object = type.asPointer().getTargetType().asFunction();
                    FunctionSymbol functionSymbol = new FunctionSymbol(string2, (FunctionType)object);
                    object10 = this.bindFunction(functionSymbol, javaType, type2, this.machDescJava);
                    ((MethodBinding)object10).findThisPointer();
                    printWriter.println();
                    object9 = new JavaMethodBindingEmitter((MethodBinding)object10, printWriter, this.cfg.runtimeExceptionType(), this.cfg.unsupportedExceptionType(), true, this.cfg.tagNativeBinding(), false, true, true, false, false, false, false, false, this.cfg);
                    ((FunctionEmitter)object9).addModifier(JavaMethodBindingEmitter.PUBLIC);
                    ((FunctionEmitter)object9).emit();
                    object9 = new JavaMethodBindingEmitter((MethodBinding)object10, printWriter, this.cfg.runtimeExceptionType(), this.cfg.unsupportedExceptionType(), false, this.cfg.tagNativeBinding(), true, true, true, true, true, false, false, false, this.cfg);
                    ((FunctionEmitter)object9).addModifier(JavaMethodBindingEmitter.PRIVATE);
                    ((FunctionEmitter)object9).addModifier(JavaMethodBindingEmitter.NATIVE);
                    ((FunctionEmitter)object9).emit();
                    object8 = new CMethodBindingEmitter((MethodBinding)object10, printWriter2, string6, string5, true, false, true, false, this.machDescJava);
                    this.prepCEmitter((MethodBinding)object10, (CMethodBindingEmitter)object8);
                    ((FunctionEmitter)object8).emit();
                    continue;
                }
                catch (Exception exception) {
                    System.err.println("While processing field " + object2 + " of type " + string4 + ":");
                    throw exception;
                }
            }
            if (type.isCompound()) {
                if (type.getName() == null) {
                    throw new RuntimeException("Anonymous structs as fields not supported yet (field \"" + object2 + "\" in type \"" + string4 + "\")");
                }
                printWriter.println();
                this.generateGetterSignature(printWriter, false, type.getName(), this.capitalizeString(string2));
                printWriter.println(" {");
                printWriter.println("    return " + type.getName() + ".create( accessor.slice( " + string2 + "_offset[mdIdx], " + string2 + "_size[mdIdx] ) );");
                printWriter.println(" }");
                continue;
            }
            if (type.isArray()) {
                object = ((Field)object2).getType().asArray().getBaseElementType();
                if (!((Type)object).isPrimitive()) break;
                String string9 = this.typeToJavaType((Type)object, false, this.machDescJava).getName();
                object10 = this.capitalizeString(string2);
                printWriter.println();
                this.generateSetterSignature(printWriter, false, string5, (String)object10, string9 + "[]");
                printWriter.println(" {");
                printWriter.print("    accessor.set" + this.capitalizeString(string9) + "sAt(" + string2 + "_offset[mdIdx], val);");
                printWriter.println("    return this;");
                printWriter.println("  }");
                printWriter.println();
                this.generateGetterSignature(printWriter, false, string9 + "[]", (String)object10);
                printWriter.println(" {");
                printWriter.print("    return accessor.get" + this.capitalizeString(string9) + "sAt(" + string2 + "_offset[mdIdx], new " + string9 + "[" + type.asArray().getLength() + "]);");
                printWriter.println(" }");
                continue;
            }
            object = null;
            try {
                object = this.typeToJavaType(type, false, this.machDescJava);
            }
            catch (Exception exception) {
                System.err.println("Error occurred while creating accessor for field \"" + ((Field)object2).getName() + "\" in type \"" + string4 + "\"");
                throw exception;
            }
            if (!((JavaType)object).isPrimitive()) continue;
            boolean bl3 = type.getSize().hasFixedNativeSize();
            object10 = this.isOpaque(type) ? this.compatiblePrimitiveJavaTypeName(type, (JavaType)object, this.machDescJava) : ((JavaType)object).getName();
            object9 = this.capitalizeString((String)object10);
            object8 = this.capitalizeString(string2);
            Object object11 = object7 = type.isPointer() ? "pointer" : object10;
            if (GlueGen.debug()) {
                System.err.println("Java.StructEmitter.Primitive: " + ((Field)object2).getName() + ", " + type.getName(true) + ", " + (String)object10 + ", " + ", fixedSize " + bl3 + ", opaque " + this.isOpaque(type) + ", isPointer " + type.isPointer() + ", isCompound " + type.isCompound() + ", sizeDenominator " + (String)object7);
            }
            printWriter.println();
            this.generateSetterSignature(printWriter, false, string5, (String)object8, (String)object10);
            printWriter.println(" {");
            if (bl3) {
                printWriter.println("    accessor.set" + (String)object9 + "At(" + string2 + "_offset[mdIdx], val);");
            } else {
                printWriter.println("    accessor.set" + (String)object9 + "At(" + string2 + "_offset[mdIdx], val, MachineDescriptionRuntime.getStatic().md." + (String)object7 + "SizeInBytes());");
            }
            printWriter.println("    return this;");
            printWriter.println("  }");
            printWriter.println();
            this.generateGetterSignature(printWriter, false, (String)object10, (String)object8);
            printWriter.println(" {");
            printWriter.print("    return ");
            if (bl3) {
                printWriter.println("accessor.get" + (String)object9 + "At(" + string2 + "_offset[mdIdx]);");
            } else {
                printWriter.println("accessor.get" + (String)object9 + "At(" + string2 + "_offset[mdIdx], MachineDescriptionRuntime.getStatic().md." + (String)object7 + "SizeInBytes());");
            }
            printWriter.println("  }");
        }
        this.emitCustomJavaCode(printWriter, string5);
        printWriter.println("}");
        printWriter.flush();
        printWriter.close();
        if (bl) {
            printWriter2.flush();
            printWriter2.close();
        }
    }

    @Override
    public void endStructs() throws Exception {
    }

    public static int addStrings2Buffer(StringBuilder stringBuilder, String string, String string2, Collection<String> collection) {
        int n = 0;
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        Iterator<String> iterator = collection.iterator();
        if (null != string2) {
            stringBuilder.append(string2);
            if (iterator.hasNext()) {
                stringBuilder.append(string);
            }
            ++n;
        }
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next());
            if (iterator.hasNext()) {
                stringBuilder.append(string);
            }
            ++n;
        }
        return n;
    }

    private void generateGetterSignature(PrintWriter printWriter, boolean bl, String string, String string2) {
        printWriter.print("  public " + (bl ? "abstract " : "") + string + " get" + string2 + "()");
    }

    private void generateSetterSignature(PrintWriter printWriter, boolean bl, String string, String string2, String string3) {
        printWriter.print("  public " + (bl ? "abstract " : "") + string + " set" + string2 + "(" + string3 + " val)");
    }

    private void generateOffsetAndSizeArrays(PrintWriter printWriter, String string, Type type, Field field) {
        int n;
        if (null != field) {
            printWriter.print("  private static final int[] " + string + "_offset = new int[] { ");
            for (n = 0; n < this.machDescTargetConfigs.length; ++n) {
                if (0 < n) {
                    printWriter.print(", ");
                }
                printWriter.print(field.getOffset(this.machDescTargetConfigs[n].md) + " /* " + this.machDescTargetConfigs[n].name() + " */");
            }
            printWriter.println(" };");
        }
        if (null != type) {
            printWriter.print("  private static final int[] " + string + "_size = new int[] { ");
            for (n = 0; n < this.machDescTargetConfigs.length; ++n) {
                if (0 < n) {
                    printWriter.print(", ");
                }
                printWriter.print(type.getSize(this.machDescTargetConfigs[n].md) + " /* " + this.machDescTargetConfigs[n].name() + " */");
            }
            printWriter.println("  };");
        }
    }

    private JavaType typeToJavaType(Type type, boolean bl, MachineDescription machineDescription) {
        Object object;
        PointerType pointerType = type.asPointer();
        if (pointerType != null && pointerType.getTargetType().getName() != null && pointerType.getTargetType().getName().equals("JNIEnv")) {
            return JavaType.createForJNIEnv();
        }
        Type type2 = type;
        TypeInfo typeInfo = this.cfg.typeInfo(type2, this.typedefDictionary);
        if (typeInfo != null) {
            boolean bl2 = false;
            if (type2.pointerDepth() > 0 || type2.arrayDimension() > 0) {
                object = type2.isPointer() ? type2.asPointer().getTargetType() : type2.asArray().getElementType();
                if ((type2.pointerDepth() == 2 || type2.arrayDimension() == 2) && ((Type)object).isPointer()) {
                    bl2 = true;
                    Type type3 = ((Type)object).asPointer().getTargetType();
                    LOG.log(Level.INFO, "Opaque Type: {0}, targetType: {1}, bottomType: {2} is ptr-ptr", new Object[]{type2, object, type3});
                }
            }
            if (!bl2) {
                return typeInfo.javaType();
            }
        }
        if (type2.isInt() || type2.isEnum()) {
            switch ((int)type2.getSize(machineDescription)) {
                case 1: {
                    return this.javaType(Byte.TYPE);
                }
                case 2: {
                    return this.javaType(Short.TYPE);
                }
                case 4: {
                    return this.javaType(Integer.TYPE);
                }
                case 8: {
                    return this.javaType(Long.TYPE);
                }
            }
            throw new RuntimeException("Unknown integer type of size " + type2.getSize(machineDescription) + " and name " + type2.getName());
        }
        if (type2.isFloat()) {
            return this.javaType(Float.TYPE);
        }
        if (type2.isDouble()) {
            return this.javaType(Double.TYPE);
        }
        if (type2.isVoid()) {
            return this.javaType(Void.TYPE);
        }
        if (type2.pointerDepth() > 0 || type2.arrayDimension() > 0) {
            Type type4 = type2.isPointer() ? type2.asPointer().getTargetType() : type2.asArray().getElementType();
            if (type2.pointerDepth() == 1 || type2.arrayDimension() == 1) {
                if (type4.isVoid()) {
                    return JavaType.createForCVoidPointer();
                }
                if (type4.isInt()) {
                    object = type4.getSize();
                    if (null != object && SizeThunk.POINTER == object) {
                        return JavaType.forNIOPointerBufferClass();
                    }
                    switch ((int)type4.getSize(machineDescription)) {
                        case 1: {
                            return JavaType.createForCCharPointer();
                        }
                        case 2: {
                            return JavaType.createForCShortPointer();
                        }
                        case 4: {
                            return JavaType.createForCInt32Pointer();
                        }
                        case 8: {
                            return JavaType.createForCInt64Pointer();
                        }
                    }
                    throw new RuntimeException("Unknown integer array type of size " + type2.getSize(machineDescription) + " and name " + type2.getName());
                }
                if (type4.isFloat()) {
                    return JavaType.createForCFloatPointer();
                }
                if (type4.isDouble()) {
                    return JavaType.createForCDoublePointer();
                }
                if (type4.isCompound()) {
                    if (type2.isArray()) {
                        throw new RuntimeException("Arrays of compound types not handled yet");
                    }
                    if (type2.getName() != null && type2.getName().equals("jobject")) {
                        return this.javaType(Object.class);
                    }
                    object = type4.getName();
                    if (object == null && (object = type2.getName()) == null) {
                        throw new RuntimeException("Couldn't find a proper type name for pointer type " + type2);
                    }
                    return JavaType.createForCStruct(this.cfg.renameJavaType((String)object));
                }
                throw new RuntimeException("Don't know how to convert pointer/array type \"" + type2 + "\"");
            }
            if (type2.pointerDepth() == 2 || type2.arrayDimension() == 2) {
                if (type4.isPointer()) {
                    object = type4.asPointer().getTargetType();
                    return JavaType.forNIOPointerBufferClass();
                }
                object = type4.asArray().getElementType();
                LOG.log(Level.WARNING, "typeToJavaType(ptr-ptr): {0}, targetType: {1}, bottomType: {2} -> Unhandled!", new Object[]{type2, type4, object});
                if (((Type)object).isPrimitive()) {
                    if (((Type)object).isInt()) {
                        switch ((int)((Type)object).getSize(machineDescription)) {
                            case 1: {
                                return this.javaType(ArrayTypes.byteBufferArrayClass);
                            }
                            case 2: {
                                return this.javaType(ArrayTypes.shortBufferArrayClass);
                            }
                            case 4: {
                                return this.javaType(ArrayTypes.intBufferArrayClass);
                            }
                            case 8: {
                                return this.javaType(ArrayTypes.longBufferArrayClass);
                            }
                        }
                        throw new RuntimeException("Unknown two-dimensional integer array type of element size " + ((Type)object).getSize(machineDescription) + " and name " + ((Type)object).getName());
                    }
                    if (((Type)object).isFloat()) {
                        return this.javaType(ArrayTypes.floatBufferArrayClass);
                    }
                    if (((Type)object).isDouble()) {
                        return this.javaType(ArrayTypes.doubleBufferArrayClass);
                    }
                    throw new RuntimeException("Unexpected primitive type " + ((Type)object).getName() + " in two-dimensional array");
                }
                if (((Type)object).isVoid()) {
                    return this.javaType(ArrayTypes.bufferArrayClass);
                }
                if (type4.isPointer() && type4.pointerDepth() == 1 && type4.asPointer().getTargetType().isCompound()) {
                    return JavaType.createForCArray((Type)object);
                }
                throw new RuntimeException("Could not convert C type \"" + type2 + "\" " + "to appropriate Java type; need to add more support for " + "depth=2 pointer/array types [debug info: targetType=\"" + type4 + "\"]");
            }
            throw new RuntimeException("Could not convert C pointer/array \"" + type2 + "\" to " + "appropriate Java type; types with pointer/array depth " + "greater than 2 are not yet supported [debug info: " + "pointerDepth=" + type2.pointerDepth() + " arrayDimension=" + type2.arrayDimension() + " targetType=\"" + type4 + "\"]");
        }
        throw new RuntimeException("Could not convert C type \"" + type2 + "\" (class " + type2.getClass().getName() + ") to appropriate Java type");
    }

    private static boolean isIntegerType(Class<?> clazz) {
        return clazz == Byte.TYPE || clazz == Short.TYPE || clazz == Character.TYPE || clazz == Integer.TYPE || clazz == Long.TYPE;
    }

    private StructLayout getLayout() {
        if (this.layout == null) {
            this.layout = StructLayout.create(0);
        }
        return this.layout;
    }

    protected PrintWriter openFile(String string, String string2) throws IOException {
        File file = new File(string);
        String string3 = file.getParent();
        if (string3 != null) {
            File file2 = new File(string3);
            file2.mkdirs();
        }
        return new PrintWriter(new BufferedWriter(new FileWriter(file)));
    }

    private boolean isOpaque(Type type) {
        return this.cfg.typeInfo(type, this.typedefDictionary) != null;
    }

    private String compatiblePrimitiveJavaTypeName(Type type, JavaType javaType, MachineDescription machineDescription) {
        Class<?> clazz = javaType.getJavaClass();
        if (!JavaEmitter.isIntegerType(clazz)) {
            throw new RuntimeException("Can't yet handle opaque definitions of structs' fields to non-integer types (byte, short, int, long, etc.): type: " + type + ", javaType " + javaType + ", javaClass " + clazz);
        }
        switch ((int)type.getSize(machineDescription)) {
            case 1: {
                return "byte";
            }
            case 2: {
                return "short";
            }
            case 4: {
                return "int";
            }
            case 8: {
                return "long";
            }
        }
        throw new RuntimeException("Can't handle opaque definitions if the starting type isn't compatible with integral types");
    }

    private void openWriters() throws IOException {
        String string = null;
        if (this.cfg.allStatic() || this.cfg.emitInterface()) {
            string = this.cfg.javaOutputDir() + File.separator + CodeGenUtils.packageAsPath(this.cfg.packageName());
        }
        String string2 = null;
        if (!this.cfg.allStatic()) {
            string2 = this.cfg.javaOutputDir() + File.separator + CodeGenUtils.packageAsPath(this.cfg.implPackageName());
        }
        String string3 = this.cfg.nativeOutputDir();
        if (this.cfg.nativeOutputUsesJavaHierarchy()) {
            string3 = string3 + File.separator + CodeGenUtils.packageAsPath(this.cfg.packageName());
        }
        if (this.cfg.allStatic() || this.cfg.emitInterface()) {
            this.javaWriter = this.openFile(string + File.separator + this.cfg.className() + ".java", this.cfg.className());
        }
        if (!this.cfg.allStatic() && this.cfg.emitImpl()) {
            this.javaImplWriter = this.openFile(string2 + File.separator + this.cfg.implClassName() + ".java", this.cfg.implClassName());
        }
        if (this.cfg.emitImpl()) {
            this.cWriter = this.openFile(string3 + File.separator + this.cfg.implClassName() + "_JNI.c", this.cfg.implClassName());
        }
        if (this.javaWriter != null) {
            CodeGenUtils.emitAutogeneratedWarning(this.javaWriter, this);
        }
        if (this.javaImplWriter != null) {
            CodeGenUtils.emitAutogeneratedWarning(this.javaImplWriter, this);
        }
        if (this.cWriter != null) {
            CodeGenUtils.emitAutogeneratedWarning(this.cWriter, this);
        }
    }

    protected PrintWriter javaWriter() {
        if (!this.cfg.allStatic() && !this.cfg.emitInterface()) {
            throw new InternalError("Should not call this");
        }
        return this.javaWriter;
    }

    protected PrintWriter javaImplWriter() {
        if (this.cfg.allStatic() || !this.cfg.emitImpl()) {
            throw new InternalError("Should not call this");
        }
        return this.javaImplWriter;
    }

    protected PrintWriter cWriter() {
        if (!this.cfg.emitImpl()) {
            throw new InternalError("Should not call this");
        }
        return this.cWriter;
    }

    private void closeWriter(PrintWriter printWriter) throws IOException {
        printWriter.flush();
        printWriter.close();
    }

    private void closeWriters() throws IOException {
        if (this.javaWriter != null) {
            this.closeWriter(this.javaWriter);
        }
        if (this.javaImplWriter != null) {
            this.closeWriter(this.javaImplWriter);
        }
        if (this.cWriter != null) {
            this.closeWriter(this.cWriter);
        }
        this.javaWriter = null;
        this.javaImplWriter = null;
        this.cWriter = null;
    }

    protected String getJavaOutputDir() {
        return this.cfg.javaOutputDir();
    }

    protected String getJavaPackageName() {
        return this.cfg.packageName();
    }

    protected String getImplPackageName() {
        return this.cfg.implPackageName();
    }

    protected void emitCustomJavaCode(PrintWriter printWriter, String string) throws Exception {
        List<String> list = this.cfg.customJavaCodeForClass(string);
        if (list.isEmpty()) {
            return;
        }
        printWriter.println();
        printWriter.println("  // --- Begin CustomJavaCode .cfg declarations");
        for (String string2 : list) {
            printWriter.println(string2);
        }
        printWriter.println("  // ---- End CustomJavaCode .cfg declarations");
    }

    protected void emitAllFileHeaders() throws IOException {
        try {
            Object object;
            String[] stringArray;
            String[] stringArray2;
            List<String> list;
            ArrayList<String> arrayList = new ArrayList<String>(this.cfg.imports());
            arrayList.add(this.cfg.gluegenRuntimePackage() + ".*");
            arrayList.add(DynamicLookupHelper.class.getPackage().getName() + ".*");
            arrayList.add(Buffers.class.getPackage().getName() + ".*");
            arrayList.add(Buffer.class.getPackage().getName() + ".*");
            if (this.cfg.allStatic() || this.cfg.emitInterface()) {
                list = null;
                list = this.cfg.emitInterface() ? this.cfg.extendedInterfaces(this.cfg.className()) : this.cfg.implementedInterfaces(this.cfg.className());
                stringArray2 = new String[list.size()];
                list.toArray(stringArray2);
                stringArray = this.cfg.javadocForClass(this.cfg.className());
                object = new CodeGenUtils.EmissionCallback((List)stringArray){
                    final /* synthetic */ List val$intfDocs;
                    {
                        this.val$intfDocs = list;
                    }

                    @Override
                    public void emit(PrintWriter printWriter) {
                        Iterator iterator = this.val$intfDocs.iterator();
                        while (iterator.hasNext()) {
                            printWriter.println((String)iterator.next());
                        }
                    }
                };
                String[] stringArray3 = null;
                stringArray3 = this.cfg.accessControl(this.cfg.className()) == MethodAccess.PUBLIC_ABSTRACT ? new String[]{"public", "abstract"} : new String[]{"public"};
                CodeGenUtils.emitJavaHeaders(this.javaWriter, this.cfg.packageName(), this.cfg.className(), this.cfg.allStatic(), arrayList, stringArray3, stringArray2, this.cfg.extendedParentClass(this.cfg.className()), (CodeGenUtils.EmissionCallback)object);
            }
            if (!this.cfg.allStatic() && this.cfg.emitImpl()) {
                stringArray2 = this.cfg.javadocForClass(this.cfg.implClassName());
                list = new CodeGenUtils.EmissionCallback((List)stringArray2){
                    final /* synthetic */ List val$implDocs;
                    {
                        this.val$implDocs = list;
                    }

                    @Override
                    public void emit(PrintWriter printWriter) {
                        Iterator iterator = this.val$implDocs.iterator();
                        while (iterator.hasNext()) {
                            printWriter.println((String)iterator.next());
                        }
                    }
                };
                object = null;
                object = this.cfg.implementedInterfaces(this.cfg.implClassName());
                int n = 0;
                if (this.cfg.className() != null) {
                    n = 1;
                }
                stringArray = new String[n + object.size()];
                object.toArray(stringArray);
                if (n == 1) {
                    stringArray[object.size()] = this.cfg.className();
                }
                String[] stringArray4 = null;
                stringArray4 = this.cfg.accessControl(this.cfg.implClassName()) == MethodAccess.PUBLIC_ABSTRACT ? new String[]{"public", "abstract"} : new String[]{"public"};
                CodeGenUtils.emitJavaHeaders(this.javaImplWriter, this.cfg.implPackageName(), this.cfg.implClassName(), true, arrayList, stringArray4, stringArray, this.cfg.extendedParentClass(this.cfg.implClassName()), (CodeGenUtils.EmissionCallback)((Object)list));
            }
            if (this.cfg.emitImpl()) {
                this.emitCHeader(this.cWriter(), this.cfg.implClassName());
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Error emitting all file headers: cfg.allStatic()=" + this.cfg.allStatic() + " cfg.emitImpl()=" + this.cfg.emitImpl() + " cfg.emitInterface()=" + this.cfg.emitInterface(), exception);
        }
    }

    protected void emitCHeader(PrintWriter printWriter, String string) {
        printWriter.println("#include <jni.h>");
        printWriter.println("#include <stdlib.h>");
        printWriter.println();
        if (this.getConfig().emitImpl()) {
            printWriter.println("#include <assert.h>");
            printWriter.println();
        }
        for (String string2 : this.cfg.customCCode()) {
            printWriter.println(string2);
        }
        printWriter.println();
    }

    protected void emitAllFileFooters() {
        if (this.cfg.allStatic() || this.cfg.emitInterface()) {
            this.javaWriter().println();
            this.javaWriter().println("} // end of class " + this.cfg.className());
        }
        if (!this.cfg.allStatic() && this.cfg.emitImpl()) {
            this.javaImplWriter().println();
            this.javaImplWriter().println("} // end of class " + this.cfg.implClassName());
        }
    }

    private JavaType javaType(Class<?> clazz) {
        return JavaType.createForClass(clazz);
    }

    private MethodBinding bindFunction(FunctionSymbol functionSymbol, JavaType javaType, Type type, MachineDescription machineDescription) {
        Object object;
        MethodBinding methodBinding = new MethodBinding(functionSymbol, javaType, type);
        methodBinding.renameMethodName(this.cfg.getJavaSymbolRename(functionSymbol.getName()));
        if (this.cfg.returnsString(methodBinding.getName())) {
            object = functionSymbol.getReturnType().asPointer();
            if (object == null || ((PointerType)object).getTargetType().asInt() == null || ((PointerType)object).getTargetType().getSize(machineDescription) != 1L) {
                throw new RuntimeException("Cannot apply ReturnsString configuration directive to \"" + functionSymbol + "\". ReturnsString requires native method to have return type \"char *\"");
            }
            methodBinding.setJavaReturnType(this.javaType(String.class));
        } else {
            methodBinding.setJavaReturnType(this.typeToJavaType(functionSymbol.getReturnType(), false, machineDescription));
        }
        object = this.cfg.stringArguments(methodBinding.getName());
        for (int i = 0; i < functionSymbol.getNumArguments(); ++i) {
            Type type2 = functionSymbol.getArgumentType(i);
            JavaType javaType2 = this.typeToJavaType(type2, true, machineDescription);
            if (object != null && object.contains(i)) {
                if (javaType2.isCVoidPointerType() || javaType2.isCCharPointerType() || javaType2.isCShortPointerType() || javaType2.isNIOPointerBuffer() || javaType2.isArray() && javaType2.getJavaClass() == ArrayTypes.byteBufferArrayClass || javaType2.getJavaClass() == ArrayTypes.shortBufferArrayClass) {
                    javaType2 = javaType2.isArray() || javaType2.isNIOPointerBuffer() ? this.javaType(ArrayTypes.stringArrayClass) : this.javaType(String.class);
                } else {
                    throw new RuntimeException("Cannot apply ArgumentIsString configuration directive to argument " + i + " of \"" + functionSymbol + "\": argument type is not " + "a \"void*\", \"char *\", \"short *\", \"char**\", or \"short**\" equivalent");
                }
            }
            methodBinding.addJavaArgumentType(javaType2);
        }
        return methodBinding;
    }

    private MethodBinding lowerMethodBindingPointerTypes(MethodBinding methodBinding, boolean bl, boolean[] blArray) {
        MethodBinding methodBinding2 = methodBinding;
        boolean bl2 = false;
        for (int i = 0; i < methodBinding.getNumArguments(); ++i) {
            JavaType javaType = methodBinding.getJavaArgumentType(i);
            if (!javaType.isCPrimitivePointerType()) continue;
            if (javaType.isCVoidPointerType()) {
                methodBinding2 = methodBinding2.replaceJavaArgumentType(i, JavaType.forNIOBufferClass());
                continue;
            }
            if (javaType.isCCharPointerType()) {
                bl2 = true;
                if (bl) {
                    methodBinding2 = methodBinding2.replaceJavaArgumentType(i, this.javaType(ArrayTypes.byteArrayClass));
                    continue;
                }
                methodBinding2 = methodBinding2.replaceJavaArgumentType(i, JavaType.forNIOByteBufferClass());
                continue;
            }
            if (javaType.isCShortPointerType()) {
                bl2 = true;
                if (bl) {
                    methodBinding2 = methodBinding2.replaceJavaArgumentType(i, this.javaType(ArrayTypes.shortArrayClass));
                    continue;
                }
                methodBinding2 = methodBinding2.replaceJavaArgumentType(i, JavaType.forNIOShortBufferClass());
                continue;
            }
            if (javaType.isCInt32PointerType()) {
                bl2 = true;
                if (bl) {
                    methodBinding2 = methodBinding2.replaceJavaArgumentType(i, this.javaType(ArrayTypes.intArrayClass));
                    continue;
                }
                methodBinding2 = methodBinding2.replaceJavaArgumentType(i, JavaType.forNIOIntBufferClass());
                continue;
            }
            if (javaType.isCInt64PointerType()) {
                bl2 = true;
                if (bl) {
                    methodBinding2 = methodBinding2.replaceJavaArgumentType(i, this.javaType(ArrayTypes.longArrayClass));
                    continue;
                }
                methodBinding2 = methodBinding2.replaceJavaArgumentType(i, JavaType.forNIOLongBufferClass());
                continue;
            }
            if (javaType.isCFloatPointerType()) {
                bl2 = true;
                if (bl) {
                    methodBinding2 = methodBinding2.replaceJavaArgumentType(i, this.javaType(ArrayTypes.floatArrayClass));
                    continue;
                }
                methodBinding2 = methodBinding2.replaceJavaArgumentType(i, JavaType.forNIOFloatBufferClass());
                continue;
            }
            if (javaType.isCDoublePointerType()) {
                bl2 = true;
                if (bl) {
                    methodBinding2 = methodBinding2.replaceJavaArgumentType(i, this.javaType(ArrayTypes.doubleArrayClass));
                    continue;
                }
                methodBinding2 = methodBinding2.replaceJavaArgumentType(i, JavaType.forNIODoubleBufferClass());
                continue;
            }
            throw new RuntimeException("Unknown C pointer type " + javaType);
        }
        JavaType javaType = methodBinding2.getJavaReturnType();
        if (javaType.isCPrimitivePointerType()) {
            if (javaType.isCVoidPointerType()) {
                methodBinding2 = methodBinding2.replaceJavaArgumentType(-1, JavaType.forNIOByteBufferClass());
            } else if (javaType.isCCharPointerType()) {
                methodBinding2 = methodBinding2.replaceJavaArgumentType(-1, JavaType.forNIOByteBufferClass());
            } else if (javaType.isCShortPointerType()) {
                methodBinding2 = methodBinding2.replaceJavaArgumentType(-1, JavaType.forNIOShortBufferClass());
            } else if (javaType.isCInt32PointerType()) {
                methodBinding2 = methodBinding2.replaceJavaArgumentType(-1, JavaType.forNIOIntBufferClass());
            } else if (javaType.isCInt64PointerType()) {
                methodBinding2 = methodBinding2.replaceJavaArgumentType(-1, JavaType.forNIOLongBufferClass());
            } else if (javaType.isCFloatPointerType()) {
                methodBinding2 = methodBinding2.replaceJavaArgumentType(-1, JavaType.forNIOFloatBufferClass());
            } else if (javaType.isCDoublePointerType()) {
                methodBinding2 = methodBinding2.replaceJavaArgumentType(-1, JavaType.forNIODoubleBufferClass());
            } else {
                throw new RuntimeException("Unknown C pointer type " + javaType);
            }
        }
        if (blArray != null) {
            blArray[0] = bl2;
        }
        return methodBinding2;
    }

    protected List<MethodBinding> expandMethodBinding(MethodBinding methodBinding) {
        ArrayList<MethodBinding> arrayList = new ArrayList<MethodBinding>();
        boolean[] blArray = new boolean[1];
        if (methodBinding.signatureUsesCPrimitivePointers() || methodBinding.signatureUsesCVoidPointers() || methodBinding.signatureUsesCArrays()) {
            arrayList.add(this.lowerMethodBindingPointerTypes(methodBinding, false, blArray));
            if (blArray[0] && (methodBinding.signatureUsesCPrimitivePointers() || methodBinding.signatureUsesCArrays()) && !this.cfg.useNIOOnly(methodBinding.getName())) {
                arrayList.add(this.lowerMethodBindingPointerTypes(methodBinding, true, null));
            }
        } else {
            arrayList.add(methodBinding);
        }
        return arrayList;
    }

    private Type canonicalize(Type type) {
        Type type2 = this.canonMap.get(type);
        if (type2 != null) {
            return type2;
        }
        this.canonMap.put(type, type);
        return type;
    }

    private final String capitalizeString(String string) {
        return Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }

    class ConstantRenamer
    implements SymbolFilter {
        private List<ConstantDefinition> constants;

        ConstantRenamer() {
        }

        @Override
        public void filterSymbols(List<ConstantDefinition> list, List<FunctionSymbol> list2) {
            this.constants = list;
            this.doWork();
        }

        @Override
        public List<ConstantDefinition> getConstants() {
            return this.constants;
        }

        @Override
        public List<FunctionSymbol> getFunctions() {
            return null;
        }

        private void doWork() {
            ArrayList<ConstantDefinition> arrayList = new ArrayList<ConstantDefinition>();
            JavaConfiguration javaConfiguration = JavaEmitter.this.getConfig();
            for (ConstantDefinition constantDefinition : this.constants) {
                constantDefinition.rename(javaConfiguration.getJavaSymbolRename(constantDefinition.getName()));
                arrayList.add(constantDefinition);
            }
            this.constants = arrayList;
        }
    }

    public static enum MethodAccess {
        PUBLIC("public"),
        PROTECTED("protected"),
        PRIVATE("private"),
        PACKAGE_PRIVATE("/* pp */"),
        PUBLIC_ABSTRACT("abstract");

        private final String javaName;

        public final String getJavaName() {
            return this.javaName;
        }

        private MethodAccess(String string2) {
            this.javaName = string2;
        }
    }

    public static enum EmissionStyle {
        AllStatic,
        InterfaceAndImpl,
        InterfaceOnly,
        ImplOnly;

    }
}

